/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.ConnectionHandlerFactory;
import org.hypertable.AsyncComm.ConnectionMap;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.IOHandlerAccept;
import org.hypertable.AsyncComm.IOHandlerData;

public class Comm {
    private static AtomicInteger msNextId = new AtomicInteger();
    public ConnectionMap mConnMap;

    public Comm(int handlerCount) {
        if (handlerCount != 0) {
            throw new AssertionError((Object)"handlerCount != 0");
        }
        this.mConnMap = new ConnectionMap();
    }

    public int Connect(InetSocketAddress addr, long timeout, DispatchHandler defaultHandler) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(addr);
            IOHandlerData handler = new IOHandlerData(channel, defaultHandler, this.mConnMap);
            handler.SetTimeout(timeout);
            handler.SetRemoteAddress(addr);
            this.mConnMap.Put(addr, handler);
            handler.SetInterest(8);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return 0;
    }

    public int Listen(int port, ConnectionHandlerFactory handlerFactory, DispatchHandler acceptHandler) {
        try {
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.socket().setReuseAddress(true);
            channel.socket().bind(new InetSocketAddress(port));
            channel.configureBlocking(false);
            IOHandlerAccept handler = new IOHandlerAccept(channel, acceptHandler, this.mConnMap, handlerFactory);
            handler.SetInterest(16);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return 0;
    }

    private int getUniqueId() {
        int id = msNextId.incrementAndGet();
        if (id == 0) {
            id = msNextId.incrementAndGet();
        }
        return id;
    }

    public int SendRequest(InetSocketAddress addr, CommBuf cbuf, DispatchHandler responseHandler) {
        IOHandlerData handler = (IOHandlerData)this.mConnMap.Get(addr);
        if (handler == null) {
            return 65537;
        }
        cbuf.header.flags = (short)(cbuf.header.flags | CommHeader.FLAGS_BIT_REQUEST);
        if (responseHandler == null) {
            cbuf.header.flags = (short)(cbuf.header.flags | CommHeader.FLAGS_BIT_IGNORE_RESPONSE);
            cbuf.header.id = 0;
        } else {
            cbuf.header.id = this.getUniqueId();
            handler.RegisterRequest(cbuf.header.id, responseHandler);
        }
        cbuf.write_header_and_reset();
        int error = handler.SendMessage(cbuf);
        if (error == 65538) {
            this.mConnMap.Remove(addr);
        }
        return error;
    }

    public int SendResponse(InetSocketAddress addr, CommBuf cbuf) {
        IOHandlerData handler = (IOHandlerData)this.mConnMap.Get(addr);
        if (handler == null) {
            return 65537;
        }
        cbuf.header.flags = (short)(cbuf.header.flags & CommHeader.FLAGS_MASK_REQUEST);
        cbuf.write_header_and_reset();
        int error = handler.SendMessage(cbuf);
        if (error == 65538) {
            this.mConnMap.Remove(addr);
        }
        return error;
    }
}

