/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;

class CommTestThreadFunction
implements Runnable {
    private Comm mComm;
    private InetSocketAddress mAddr;
    String mInputFile;
    String mOutputFile;

    public CommTestThreadFunction(Comm comm, InetSocketAddress addr, String input) {
        this.mComm = comm;
        this.mAddr = addr;
        this.mInputFile = input;
    }

    public void SetOutputFile(String output) {
        this.mOutputFile = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommHeader header = new CommHeader();
        ResponseHandler respHandler = new ResponseHandler();
        int maxOutstanding = 50;
        int outstanding = 0;
        try {
            Event event;
            String str;
            BufferedReader infile = new BufferedReader(new FileReader(this.mInputFile));
            BufferedWriter outfile = new BufferedWriter(new FileWriter(this.mOutputFile));
            while ((str = infile.readLine()) != null) {
                int error;
                CommBuf cbuf = new CommBuf(header, Serialization.EncodedLengthString(str));
                cbuf.AppendString(str);
                int retries = 0;
                while ((error = this.mComm.SendRequest(this.mAddr, cbuf, respHandler)) != 0) {
                    if (error == 65537) {
                        Integer intObj;
                        if (retries == 5) {
                            System.out.println("Connection timeout.");
                            System.exit(1);
                        }
                        Integer n = intObj = new Integer(0);
                        synchronized (n) {
                            intObj.wait(1000L);
                        }
                        ++retries;
                        continue;
                    }
                    System.err.println("CommEngine.SendMessage returned '" + Error.GetText(error) + "'");
                    System.exit(1);
                }
                if (++outstanding <= maxOutstanding) continue;
                event = respHandler.GetResponse();
                if (event == null) break;
                str = Serialization.DecodeString(event.payload);
                outfile.write(str);
                outfile.write("\n");
                --outstanding;
            }
            while (outstanding > 0 && (event = respHandler.GetResponse()) != null) {
                str = Serialization.DecodeString(event.payload);
                outfile.write(str);
                outfile.write("\n");
                --outstanding;
            }
            outfile.close();
            infile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ResponseHandler
    implements DispatchHandler {
        private LinkedList<Event> mQueue = new LinkedList();
        private boolean mConnected = true;

        private ResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Event event) {
            ResponseHandler responseHandler = this;
            synchronized (responseHandler) {
                if (event.type == Event.Type.MESSAGE) {
                    this.mQueue.add(event);
                    this.notify();
                } else {
                    System.err.println(event.toString());
                    this.mConnected = false;
                    this.notify();
                }
            }
        }

        public synchronized Event GetResponse() throws InterruptedException {
            while (this.mQueue.isEmpty()) {
                this.wait();
                if (this.mConnected) continue;
                return null;
            }
            return this.mQueue.remove();
        }
    }
}

