/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;

public class DispatchHandlerSynchronizer
implements DispatchHandler {
    static final Logger log = Logger.getLogger("org.hypertable.AsyncComm");
    private LinkedList<Event> mReceiveQueue = new LinkedList();
    private long mTimeoutMs;

    public DispatchHandlerSynchronizer(long timeoutSecs) {
        this.mTimeoutMs = timeoutSecs * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Event event) {
        DispatchHandlerSynchronizer dispatchHandlerSynchronizer = this;
        synchronized (dispatchHandlerSynchronizer) {
            this.mReceiveQueue.add(event);
            this.notify();
        }
    }

    public synchronized Event WaitForEvent() throws InterruptedException {
        if (this.mReceiveQueue.isEmpty()) {
            this.wait(this.mTimeoutMs);
        }
        if (this.mReceiveQueue.isEmpty()) {
            return null;
        }
        return this.mReceiveQueue.remove();
    }
}

