/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.Common.Error;
import org.hypertable.Common.HypertableException;

public class Event {
    public Type type;
    public InetSocketAddress addr;
    public int error;
    public CommHeader header = new CommHeader();
    public ByteBuffer payload;
    public long thread_group;

    public Event(Event other) {
        this.type = other.type;
        this.addr = other.addr;
        this.error = other.error;
        this.header = other.header;
        this.payload = other.payload;
        this.thread_group = other.thread_group;
    }

    public Event(Type ct, InetSocketAddress a, int err) {
        this.type = ct;
        this.addr = a;
        this.error = err;
    }

    public Event(Type ct, InetSocketAddress a) {
        this.type = ct;
        this.addr = a;
    }

    Event(Type ct, int err) {
        this.type = ct;
        this.error = err;
    }

    void load_header(int sd, ByteBuffer buf) throws HypertableException {
        this.header.decode(buf);
        this.thread_group = this.header.gid != 0 ? (long)sd << 32 | (long)this.header.gid : 0L;
    }

    public String toString() {
        String str = "[" + this.addr + " ; " + new Date().toString() + "] ";
        if (this.type == Type.CONNECTION_ESTABLISHED) {
            str = str + "Connection Established";
        } else if (this.type == Type.DISCONNECT) {
            str = str + "Disconnect";
        } else if (this.type == Type.MESSAGE) {
            str = str + "Message";
        } else if (this.type == Type.ERROR) {
            str = str + "Error";
        }
        if (this.error != 0) {
            str = str + " - " + Error.GetText(this.error);
        }
        return str;
    }

    public static enum Type {
        CONNECTION_ESTABLISHED,
        DISCONNECT,
        MESSAGE,
        ERROR,
        TIMER;

    }
}

