/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ConnectionMap;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.Reactor;
import org.hypertable.AsyncComm.ReactorFactory;

public abstract class IOHandler {
    protected static final Logger log = Logger.getLogger("org.hypertable");
    protected InetSocketAddress mAddr;
    protected DispatchHandler mDispatchHandler;
    protected ConnectionMap mConnMap;
    protected Reactor mReactor;
    protected AbstractSelectableChannel mChannel;
    protected int mInterest;
    protected boolean mShuttingDown = false;

    public IOHandler(AbstractSelectableChannel chan, DispatchHandler dh, ConnectionMap cm) {
        this.mChannel = chan;
        this.mDispatchHandler = dh;
        this.mConnMap = cm;
        this.mReactor = ReactorFactory.Get();
        this.mAddr = null;
        this.mInterest = 0;
    }

    public void DeliverEvent(Event event, DispatchHandler dh) {
        if (dh != null) {
            dh.handle(event);
        } else {
            this.DeliverEvent(event);
        }
    }

    public void DeliverEvent(Event event) {
        if (this.mDispatchHandler != null) {
            this.mDispatchHandler.handle(event);
        } else {
            log.info(event.toString());
        }
    }

    public abstract void run(SelectionKey var1);

    public void Register(Selector selector) {
        block4: {
            try {
                if (this.mShuttingDown) {
                    SelectionKey selkey = this.mChannel.register(selector, 0);
                    selkey.cancel();
                } else {
                    this.mChannel.register(selector, this.mInterest, this);
                }
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
                if (this.mAddr == null) break block4;
                this.mConnMap.Remove(this.mAddr);
            }
        }
    }

    public void Shutdown() {
        this.mShuttingDown = true;
        this.mReactor.AddToRegistrationQueue(this);
        this.mReactor.WakeUp();
    }

    public void SetInterest(int interest) {
        this.mInterest = interest;
        this.mReactor.AddToRegistrationQueue(this);
        this.mReactor.WakeUp();
    }

    public void AddInterest(int interest) {
        this.mInterest |= interest;
        this.mReactor.AddToRegistrationQueue(this);
        this.mReactor.WakeUp();
    }

    public void RemoveInterest(int interest) {
        this.mInterest &= ~interest;
        this.mReactor.AddToRegistrationQueue(this);
        this.mReactor.WakeUp();
    }

    Reactor GetReactor() {
        return this.mReactor;
    }
}

