/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.ConnectionMap;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.IOHandler;
import org.hypertable.Common.HypertableException;

class IOHandlerData
extends IOHandler {
    private static AtomicInteger msNextId = new AtomicInteger(1);
    private SocketChannel mSocketChannel;
    private ByteBuffer mHeaderBuffer;
    private ByteBuffer mPayloadBuffer;
    private boolean mGotHeader;
    private LinkedList<CommBuf> mSendQueue;
    private long mTimeout;
    private boolean mShutdown;
    private Event mEvent;

    public IOHandlerData(SocketChannel chan, DispatchHandler dh, ConnectionMap cm) {
        super(chan, dh, cm);
        this.mSocketChannel = chan;
        this.mHeaderBuffer = ByteBuffer.allocate(64);
        this.mHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.mSendQueue = new LinkedList();
        this.mShutdown = false;
        this.reset_incoming_message_state();
    }

    public void SetRemoteAddress(InetSocketAddress addr) {
        this.mAddr = addr;
        this.mEvent.addr = addr;
    }

    public void SetTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    InetSocketAddress GetAddress() {
        return this.mAddr;
    }

    private void reset_incoming_message_state() {
        this.mGotHeader = false;
        this.mEvent = new Event(Event.Type.MESSAGE, this.mAddr);
        this.mHeaderBuffer.clear();
        this.mHeaderBuffer.limit(this.mEvent.header.fixed_length());
        this.mPayloadBuffer = null;
    }

    private void handle_disconnect(int error) {
        if (this.mAddr != null) {
            this.mConnMap.Remove(this.mAddr);
        }
        this.DeliverEvent(new Event(Event.Type.DISCONNECT, this.mAddr, error));
        this.mReactor.CancelRequests(this);
        try {
            this.mSocketChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SelectionKey selkey) {
        block22: {
            try {
                Socket socket = this.mSocketChannel.socket();
                if (!selkey.isValid()) {
                    selkey.cancel();
                    this.handle_disconnect(65538);
                }
                if (selkey.isConnectable()) {
                    try {
                        if (!this.mSocketChannel.finishConnect()) {
                            this.mSocketChannel.close();
                            System.err.println("Connection error");
                            return;
                        }
                        this.mAddr = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
                        this.DeliverEvent(new Event(Event.Type.CONNECTION_ESTABLISHED, this.mAddr, 0));
                        this.SetInterest(1);
                        this.mConnMap.Put(this.mAddr, this);
                    }
                    catch (ConnectException e) {
                        selkey.cancel();
                        this.handle_disconnect(65539);
                    }
                    return;
                }
                if (selkey.isReadable()) {
                    while (true) {
                        int nread;
                        if (!this.mGotHeader) {
                            nread = this.mSocketChannel.read(this.mHeaderBuffer);
                            if (nread == -1) {
                                selkey.cancel();
                                this.handle_disconnect(65538);
                                return;
                            }
                            if (this.mHeaderBuffer.hasRemaining()) {
                                return;
                            }
                            this.handle_message_header();
                        }
                        if (!this.mGotHeader) continue;
                        nread = this.mSocketChannel.read(this.mPayloadBuffer);
                        if (nread == -1) {
                            selkey.cancel();
                            this.handle_disconnect(65538);
                            return;
                        }
                        if (this.mPayloadBuffer.hasRemaining()) {
                            return;
                        }
                        this.handle_message_body();
                    }
                }
                if (!selkey.isWritable()) break block22;
                IOHandlerData nread = this;
                synchronized (nread) {
                    if (!this.mSendQueue.isEmpty()) {
                        CommBuf cbuf;
                        while (!this.mSendQueue.isEmpty() && this.SendBuf(cbuf = this.mSendQueue.peek())) {
                            this.mSendQueue.remove();
                        }
                        if (this.mSendQueue.isEmpty()) {
                            this.RemoveInterest(4);
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    selkey.cancel();
                    this.handle_disconnect(65538);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.DeliverEvent(new Event(Event.Type.DISCONNECT, this.mAddr, 65538));
                e.printStackTrace();
            }
        }
    }

    private void handle_message_header() throws HypertableException {
        this.mHeaderBuffer.position(1);
        byte header_len = this.mHeaderBuffer.get();
        this.mHeaderBuffer.position(this.mHeaderBuffer.limit());
        if (header_len > this.mHeaderBuffer.limit()) {
            this.mHeaderBuffer.limit(header_len);
            return;
        }
        this.mHeaderBuffer.flip();
        this.mEvent.load_header(this.mSocketChannel.socket().getInetAddress().hashCode(), this.mHeaderBuffer);
        this.mPayloadBuffer = ByteBuffer.allocate(this.mEvent.header.total_len - header_len);
        this.mPayloadBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.mHeaderBuffer.clear();
        this.mGotHeader = true;
    }

    private void handle_message_body() {
        DispatchHandler dh = this.mReactor.RemoveRequest(this.mEvent.header.id);
        if ((this.mEvent.header.flags & CommHeader.FLAGS_BIT_REQUEST) == 0 && (this.mEvent.header.id == 0 || dh == null)) {
            if ((this.mEvent.header.flags & CommHeader.FLAGS_BIT_IGNORE_RESPONSE) == 0) {
                log.warning("Received response for non-pending event (id=" + this.mEvent.header.id + ",version=" + this.mEvent.header.version + ",total_len=" + this.mEvent.header.total_len + ")");
            } else {
                System.out.println("nope id=" + this.mEvent.header.id);
            }
            this.mPayloadBuffer = null;
            this.mEvent = null;
        } else {
            this.mPayloadBuffer.flip();
            this.mEvent.payload = this.mPayloadBuffer;
            this.DeliverEvent(this.mEvent, dh);
        }
        this.reset_incoming_message_state();
    }

    synchronized void RegisterRequest(int id, DispatchHandler responseHandler) {
        long now = System.currentTimeMillis();
        this.mReactor.AddRequest(id, this, responseHandler, now + this.mTimeout);
    }

    boolean SendBuf(CommBuf cbuf) throws IOException {
        int nwritten;
        if (cbuf.data != null && cbuf.data.remaining() > 0) {
            nwritten = this.mSocketChannel.write(cbuf.data);
            if (cbuf.data.remaining() > 0) {
                return false;
            }
        }
        if (cbuf.ext != null && cbuf.ext.remaining() > 0) {
            nwritten = this.mSocketChannel.write(cbuf.ext);
            if (cbuf.ext.remaining() > 0) {
                return false;
            }
        }
        return true;
    }

    synchronized int SendMessage(CommBuf cbuf) {
        boolean initiallyEmpty = this.mSendQueue.isEmpty();
        try {
            CommBuf tbuf;
            while (!this.mSendQueue.isEmpty() && this.SendBuf(tbuf = this.mSendQueue.peek())) {
                this.mSendQueue.remove();
            }
            if (this.mSendQueue.isEmpty() && this.SendBuf(cbuf)) {
                if (!initiallyEmpty) {
                    this.RemoveInterest(4);
                }
                return 0;
            }
            this.mSendQueue.add(cbuf);
            if (initiallyEmpty) {
                this.AddInterest(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Shutdown();
            return 65538;
        }
        return 0;
    }
}

