/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.ConnectionHandlerFactory;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ReactorFactory;
import org.hypertable.Common.Error;

public class SampleServer {
    static final Logger log = Logger.getLogger("org.hypertable");
    static String[] usage = new String[]{"", "usage: sampleServer [OPTIONS]", "", "OPTIONS:", "  --help          Display this help text and exit", "  --port=<n>      Specifies the port to connect to", "  --reactors=<n>  Specifies the number of reactors", "  --delay=<ms>    Specifies milliseconds to wait before echoing ", "                  message (default=0)", "", "This is a sample program to test the AsyncComm library.  It connects", "to the sampleServer and sends each line of the input file", "to the server.  Each reply from the server is echoed to stdout.", "", null};
    static final int DEFAULT_PORT = 11255;
    static int gDelay = 0;

    public static void main(String[] args) throws InterruptedException, IOException {
        Event event;
        int i;
        int port = 11255;
        short reactorCount = 1;
        if (args.length == 1 && args[0].equals("--help")) {
            i = 0;
            while (usage[i] != null) {
                System.out.println(usage[i]);
                ++i;
            }
            System.exit(0);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--port=")) {
                port = Integer.parseInt(args[i].substring(7));
                continue;
            }
            if (args[i].startsWith("--delay=")) {
                gDelay = Integer.parseInt(args[i].substring(8));
                continue;
            }
            if (args[i].startsWith("--reactors=")) {
                reactorCount = Short.parseShort(args[i].substring(11));
                continue;
            }
            int j = 0;
            while (usage[j] != null) {
                System.out.println(usage[j]);
                ++j;
            }
            System.exit(0);
        }
        ReactorFactory.Initialize(reactorCount);
        RequestHandler requestHandler = new RequestHandler();
        HandlerFactory handlerFactory = new HandlerFactory(requestHandler);
        Comm comm = new Comm(0);
        comm.Listen(port, handlerFactory, requestHandler);
        while ((event = requestHandler.GetRequest()) != null) {
            CommHeader header = new CommHeader();
            header.initialize_from_request_header(event.header);
            CommBuf cbuf = new CommBuf(header, event.payload.remaining());
            cbuf.AppendBytes(event.payload);
            int error = comm.SendResponse(event.addr, cbuf);
            if (error == 0) continue;
            log.log(Level.SEVERE, "Comm.SendResponse returned " + Error.GetText(error));
        }
    }

    private static class HandlerFactory
    implements ConnectionHandlerFactory {
        private DispatchHandler mDispatchHandler;

        public HandlerFactory(DispatchHandler cb) {
            this.mDispatchHandler = cb;
        }

        @Override
        public DispatchHandler newInstance() {
            return this.mDispatchHandler;
        }
    }

    private static class RequestHandler
    implements DispatchHandler {
        private LinkedList<Event> mQueue = new LinkedList();

        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Event event) {
            if (event.type == Event.Type.CONNECTION_ESTABLISHED) {
                log.info("Connection Established.");
            } else if (event.type == Event.Type.DISCONNECT) {
                if (event.error == 65539) {
                    log.info("Connect error.");
                } else {
                    log.info("Disconnect.");
                }
            } else if (event.type == Event.Type.ERROR) {
                log.info("Error : " + Error.GetText(event.error));
                System.exit(1);
            } else if (event.type == Event.Type.MESSAGE) {
                RequestHandler requestHandler = this;
                synchronized (requestHandler) {
                    Event newEvent = new Event(event);
                    this.mQueue.offer(newEvent);
                    this.notify();
                }
            }
        }

        public synchronized Event GetRequest() throws InterruptedException {
            while (this.mQueue.isEmpty()) {
                this.wait();
            }
            if (gDelay > 0) {
                this.wait(gDelay);
            }
            return this.mQueue.remove();
        }
    }
}

