/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;

public abstract class DiscreteRandomGenerator {
    protected int mMinValue;
    protected int mMaxValue;
    protected int mOrigSeed;
    protected int mValueCount;
    private Random mRandom;
    protected ByteBuffer mNumberBuffer;
    protected ByteBuffer mCmfBuffer;

    public DiscreteRandomGenerator(int min, int max, int seed) {
        this.mMinValue = min;
        this.mMaxValue = max;
        this.mOrigSeed = seed;
        this.mRandom = new Random(this.mOrigSeed);
    }

    public DiscreteRandomGenerator(String cmfFile) throws FileNotFoundException, IOException {
        File file = new File(cmfFile);
        FileChannel roChannel = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer buf = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 12L);
        this.mMinValue = buf.getInt();
        this.mMaxValue = buf.getInt();
        this.mValueCount = this.mMaxValue - this.mMinValue;
        this.mRandom = new Random(1L);
        this.mNumberBuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 8L, this.mValueCount * 8);
        long cmfOffset = 8 + this.mValueCount * 8;
        this.mCmfBuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, cmfOffset, roChannel.size() - cmfOffset);
    }

    void writeCmfFile(String cmfFile) {
        if (this.mCmfBuffer == null) {
            this.generateCmf();
        }
        try {
            FileChannel wChannel = new FileOutputStream(cmfFile, false).getChannel();
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putInt(this.mMinValue);
            buf.putInt(this.mMaxValue);
            buf.flip();
            wChannel.write(buf);
            this.mNumberBuffer.limit(this.mNumberBuffer.capacity());
            this.mNumberBuffer.position(0);
            wChannel.write(this.mNumberBuffer);
            this.mCmfBuffer.limit(this.mCmfBuffer.capacity());
            this.mCmfBuffer.position(0);
            wChannel.write(this.mCmfBuffer);
            wChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSeed(long seed) {
        if (this.mCmfBuffer == null) {
            this.generateCmf();
        }
        this.mRandom.setSeed(seed);
    }

    public int distributionRange() {
        return this.mMaxValue - this.mMinValue;
    }

    public long getSample() {
        if (this.mCmfBuffer == null) {
            this.generateCmf();
        }
        int upper = this.mValueCount;
        int lower = 0;
        int ii = 0;
        double rand = this.mRandom.nextDouble();
        try {
            while (ii < this.mValueCount - 1) {
                ii = (upper + lower) / 2;
                if (this.mCmfBuffer.getDouble(ii * 8) >= rand) {
                    if (ii != 0 && !(this.mCmfBuffer.getDouble((ii - 1) * 8) <= rand)) {
                        upper = ii - 1;
                        continue;
                    }
                    break;
                }
                lower = ii + 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("index = " + ii + " length = " + this.mValueCount + " cmfCapacity=" + this.mCmfBuffer.capacity());
            e.printStackTrace();
        }
        return this.mNumberBuffer.getLong(ii * 8);
    }

    protected void generateCmf() {
        int ii;
        this.mValueCount = this.mMaxValue - this.mMinValue;
        this.mCmfBuffer = ByteBuffer.allocate((this.mValueCount + 1) * 8);
        this.loadNumberBuffer();
        double prev = this.pmf(0L);
        this.mCmfBuffer.putDouble(prev);
        for (ii = 1; ii < this.mValueCount + 1; ++ii) {
            this.mCmfBuffer.putDouble(prev += this.pmf(ii));
        }
        double norm_const = prev;
        for (ii = 0; ii < this.mValueCount + 1; ++ii) {
            this.mCmfBuffer.putDouble(ii * 8, this.mCmfBuffer.getDouble(ii * 8) / norm_const);
        }
    }

    private void loadNumberBuffer() {
        this.mNumberBuffer = ByteBuffer.allocate(this.mValueCount * 8);
        for (int i = 0; i < this.mValueCount; ++i) {
            this.mNumberBuffer.putLong(i * 8, i);
        }
        for (int i = 0; i < this.mValueCount; ++i) {
            long tmpval = this.mNumberBuffer.getLong(i * 8);
            int ii = Math.abs(this.mRandom.nextInt()) % this.mValueCount;
            this.mNumberBuffer.putLong(i * 8, this.mNumberBuffer.getLong(ii * 8));
            this.mNumberBuffer.putLong(ii * 8, tmpval);
        }
    }

    protected abstract double pmf(long var1);
}

