/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

public class ProgressMeter {
    private long mCount;
    private long mNextTicCount;
    private int mTic;
    private long mExpectedCount;
    private boolean mCompleted;

    public ProgressMeter(long expectedCount) {
        this.mExpectedCount = expectedCount;
        System.out.println("0%   10   20   30   40   50   60   70   80   90   100%");
        System.out.println("|----|----|----|----|----|----|----|----|----|----|");
        System.out.flush();
    }

    public long add(long increment) {
        if ((this.mCount += increment) >= this.mNextTicCount) {
            this.displayTic();
        }
        return this.mCount;
    }

    void displayTic() {
        int tics_needed = (int)((double)this.mCount / (double)this.mExpectedCount * 50.0);
        do {
            System.out.print("*");
            System.out.flush();
        } while (++this.mTic < tics_needed);
        this.mNextTicCount = (long)((double)this.mTic / 50.0 * (double)this.mExpectedCount);
        if (this.mCount == this.mExpectedCount) {
            if (this.mTic < 51) {
                System.out.print("*");
            }
            System.out.println();
            System.out.flush();
            this.mCompleted = true;
        }
    }

    public void finished() {
        if (!this.mCompleted) {
            System.out.println();
            System.out.flush();
            this.mCompleted = true;
        }
    }
}

