/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackOpen;

public class RequestHandlerOpen
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerOpen(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block4: {
            ResponseCallbackOpen cb = new ResponseCallbackOpen(this.mComm, this.mEvent);
            try {
                if (this.mEvent.payload.remaining() < 4) {
                    throw new ProtocolException("Truncated message");
                }
                int flags = this.mEvent.payload.getInt();
                int bufferSize = this.mEvent.payload.getInt();
                String fileName = Serialization.DecodeString(this.mEvent.payload);
                if (fileName == null) {
                    throw new ProtocolException("Filename not properly encoded in request packet");
                }
                this.mBroker.Open(cb, fileName, flags, bufferSize);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (OPEN) - " + e.getMessage());
                if (error == 0) break block4;
                log.severe("Problem sending (OPEN) error back to client - " + Error.GetText(error));
            }
        }
    }
}

