/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackReaddir;

public class RequestHandlerReaddir
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerReaddir(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block3: {
            ResponseCallbackReaddir cb = new ResponseCallbackReaddir(this.mComm, this.mEvent);
            try {
                String fileName = Serialization.DecodeString(this.mEvent.payload);
                if (fileName == null) {
                    throw new ProtocolException("Filename not properly encoded in request packet");
                }
                this.mBroker.Readdir(cb, fileName);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (READDIR) - " + e.getMessage());
                if (error == 0) break block3;
                log.severe("Problem sending (READDIR) error back to client - " + Error.GetText(error));
            }
        }
    }
}

