/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Writable;
import org.hypertable.hadoop.util.Row;

public class LazyHTCellMap
extends LazyMap {
    private Row htRow;
    private String htColumnFamily;

    public LazyHTCellMap(LazyMapObjectInspector oi) {
        super(oi);
    }

    public void init(ByteArrayRef bytes, int start, int length) {
    }

    public void init(Row row, String columnFamily) {
        this.htRow = row;
        this.htColumnFamily = columnFamily;
        this.setParsed(false);
    }

    private void parse() {
        if (this.cachedMap == null) {
            this.cachedMap = new LinkedHashMap();
        } else {
            this.cachedMap.clear();
        }
        NavigableMap<byte[], byte[]> qualifierToValue = this.htRow.getColFamilyMap(this.htColumnFamily.getBytes());
        if (qualifierToValue != null) {
            for (byte[] colQualifier : qualifierToValue.keySet()) {
                byte[] colValue = (byte[])qualifierToValue.get(colQualifier);
                if (colValue == null || colValue.length == 0) continue;
                LazyPrimitive key = LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)((PrimitiveObjectInspector)((MapObjectInspector)this.getInspector()).getMapKeyObjectInspector()));
                ByteArrayRef keyRef = new ByteArrayRef();
                keyRef.setData(colQualifier);
                key.init(keyRef, 0, colQualifier.length);
                LazyObject value = LazyFactory.createLazyObject((ObjectInspector)((MapObjectInspector)this.getInspector()).getMapValueObjectInspector());
                ByteArrayRef valueRef = new ByteArrayRef();
                valueRef.setData(colValue);
                value.init(valueRef, 0, colValue.length);
                this.cachedMap.put(key.getObject(), value.getObject());
            }
        }
    }

    public Object getMapValueElement(Object key) {
        if (!this.getParsed()) {
            this.parse();
        }
        for (Map.Entry entry : this.cachedMap.entrySet()) {
            LazyPrimitive lazyKeyI = (LazyPrimitive)entry.getKey();
            Writable keyI = lazyKeyI.getWritableObject();
            if (keyI == null || !keyI.equals(key)) continue;
            LazyObject v = (LazyObject)entry.getValue();
            return v == null ? v : v.getObject();
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap;
    }

    public int getMapSize() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap.size();
    }
}

