/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapred;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.hypertable.Common.Time;
import org.hypertable.hadoop.mapred.TableSplit;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.Cell;
import org.hypertable.thriftgen.ClientException;
import org.hypertable.thriftgen.ColumnPredicate;
import org.hypertable.thriftgen.ColumnPredicateOperation;
import org.hypertable.thriftgen.Key;
import org.hypertable.thriftgen.RowInterval;

public class TextTableInputFormat
implements InputFormat<Text, Text>,
JobConfigurable {
    final Log LOG = LogFactory.getLog(InputFormat.class);
    public static final String NAMESPACE = "hypertable.mapreduce.namespace";
    public static final String INPUT_NAMESPACE = "hypertable.mapreduce.input.namespace";
    public static final String TABLE = "hypertable.mapreduce.input.table";
    public static final String COLUMNS = "hypertable.mapreduce.input.scan_spec.columns";
    public static final String VALUE_REGEXPS = "hypertable.mapreduce.input.scan_spec.value_regexps";
    public static final String COLUMN_PREDICATES = "hypertable.mapreduce.input.scan_spec.column_predicates";
    public static final String OPTIONS = "hypertable.mapreduce.input.scan_spec.options";
    public static final String ROW_INTERVAL = "hypertable.mapreduce.input.scan_spec.row_interval";
    public static final String TIMESTAMP_INTERVAL = "hypertable.mapreduce.input.scan_spec.timestamp_interval";
    public static final String INCLUDE_TIMESTAMPS = "hypertable.mapreduce.input.include_timestamps";
    private ThriftClient m_client = null;
    private ScanSpec m_base_spec = null;
    private String m_namespace = null;
    private String m_tablename = null;
    private boolean m_include_timestamps = false;

    private static String stripQuotes(String str) {
        if (str != null && str.length() > 0 && (str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"')) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public void parseOptions(JobConf job) throws ParseException {
        String str = job.get(OPTIONS);
        if (str != null) {
            String[] strs = str.split("\\s");
            for (int i = 0; i < strs.length; ++i) {
                int value;
                strs[i] = strs[i].toUpperCase();
                if (strs[i].equals("MAX_VERSIONS") || strs[i].equals("REVS")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setVersions(value);
                    continue;
                }
                if (strs[i].equals("OFFSET")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setRow_offset(value);
                    continue;
                }
                if (strs[i].equals("CELL_OFFSET")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setCell_offset(value);
                    continue;
                }
                if (strs[i].equals("LIMIT")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setRow_limit(value);
                    continue;
                }
                if (strs[i].equals("CELL_LIMIT")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setCell_limit(value);
                    continue;
                }
                if (strs[i].equals("CELL_LIMIT_PER_FAMILY")) {
                    if (++i == strs.length) {
                        throw new ParseException("Bad OPTIONS spec", i);
                    }
                    value = Integer.parseInt(strs[i]);
                    this.m_base_spec.setCell_limit_per_family(value);
                    continue;
                }
                if (strs[i].equals("KEYS_ONLY")) {
                    this.m_base_spec.setKeys_only(true);
                    continue;
                }
                if (strs[i].equals("RETURN_DELETES")) {
                    this.m_base_spec.setReturn_deletes(true);
                    continue;
                }
                throw new ParseException("Bad OPTIONS spec: " + strs[i], i);
            }
        }
    }

    public void parseColumns(JobConf job) {
        String str = job.get(COLUMNS);
        if (str != null) {
            String[] columns = str.split(",");
            for (int i = 0; i < columns.length; ++i) {
                this.m_base_spec.addToColumns(TextTableInputFormat.stripQuotes(columns[i]));
            }
        }
    }

    public void parseValueRegexps(JobConf job) {
        String str = job.get(VALUE_REGEXPS);
        if (str != null) {
            this.m_base_spec.setValue_regexp(TextTableInputFormat.stripQuotes(str));
        }
    }

    public void parseColumnPredicate(JobConf job) throws ParseException {
        ColumnPredicate cp = new ColumnPredicate();
        String str = job.get(COLUMN_PREDICATES);
        if (str == null) {
            return;
        }
        int offset = str.indexOf("=^");
        if (offset != -1) {
            cp.column_family = str.substring(0, offset).trim();
            cp.operation = ColumnPredicateOperation.PREFIX_MATCH;
            cp.value = str.substring(offset + 2).trim();
        } else {
            offset = str.indexOf("=");
            if (offset != -1) {
                cp.column_family = str.substring(0, offset).trim();
                cp.operation = ColumnPredicateOperation.EXACT_MATCH;
                cp.value = str.substring(offset + 1).trim();
            } else {
                throw new ParseException("Invalid COLUMN_PREDICATE: " + str, 0);
            }
        }
        this.m_base_spec.addToColumn_predicates(cp);
    }

    public String[] parseRelopSpec(String str, String name) {
        int offset;
        String name_uppercase = name.toUpperCase();
        String name_lowercase = name.toLowerCase();
        String[] strs = new String[5];
        int ts_offset = str.indexOf(name_uppercase);
        if (ts_offset == -1) {
            ts_offset = str.indexOf(name_lowercase);
        }
        if (ts_offset == -1) {
            return null;
        }
        strs[0] = str.substring(0, ts_offset).trim();
        strs[2] = str.substring(ts_offset, ts_offset + name.length());
        strs[4] = str.substring(ts_offset + name.length()).trim();
        if (strs[0].length() > 0) {
            for (offset = strs[0].length() - 1; offset > 0 && (strs[0].charAt(offset) == '<' || strs[0].charAt(offset) == '=' || strs[0].charAt(offset) == '>'); --offset) {
            }
            if (offset == -1 || offset == strs[0].length() - 1) {
                return null;
            }
            strs[1] = strs[0].substring(offset + 1);
            strs[0] = strs[0].substring(0, offset).trim();
        }
        if (strs[4].length() > 0) {
            for (offset = 0; offset < strs[4].length() && (strs[4].charAt(offset) == '<' || strs[4].charAt(offset) == '=' || strs[4].charAt(offset) == '>'); ++offset) {
            }
            if (offset == strs[4].length() || offset == 0) {
                return null;
            }
            strs[3] = strs[4].substring(0, offset);
            strs[4] = strs[4].substring(offset).trim();
        }
        if (strs[0].length() == 0 && strs[4].length() == 0) {
            return null;
        }
        if (strs[0].length() == 0) {
            if (strs[3].equals(">") || strs[3].equals(">=")) {
                strs[0] = strs[4];
                if (strs[3].equals(">")) {
                    strs[1] = "<=";
                } else if (strs[3].equals(">=")) {
                    strs[1] = "<";
                }
                strs[3] = null;
                strs[4] = null;
            }
        } else if (strs[4].length() == 0) {
            if (strs[1].equals(">") || strs[1].equals(">=")) {
                strs[4] = strs[0];
                if (strs[1].equals(">")) {
                    strs[3] = "<=";
                } else if (strs[1].equals(">=")) {
                    strs[3] = "<";
                }
                strs[1] = null;
                strs[0] = null;
            }
        } else if (strs[1].equals(">") || strs[1].equals(">=")) {
            if (!strs[3].equals(">") && !strs[3].equals(">=")) {
                return null;
            }
            String tmp = strs[0];
            strs[0] = strs[4];
            strs[4] = tmp;
            if (strs[1].equals(">")) {
                strs[1] = "<=";
            } else if (strs[1].equals(">=")) {
                strs[1] = "<";
            }
            if (strs[3].equals(">")) {
                strs[3] = "<=";
            } else if (strs[3].equals(">=")) {
                strs[3] = "<";
            }
        }
        if (strs[1] != null && strs[1].equals("=") && strs[3] != null && strs[3].equals("=")) {
            return null;
        }
        strs[0] = TextTableInputFormat.stripQuotes(strs[0]);
        strs[4] = TextTableInputFormat.stripQuotes(strs[4]);
        return strs;
    }

    public void parseTimestampInterval(JobConf job) throws ParseException {
        String str = job.get(TIMESTAMP_INTERVAL);
        if (str != null) {
            long epoch_time;
            Date ts;
            String[] parsedRelop = this.parseRelopSpec(str, "TIMESTAMP");
            if (parsedRelop == null) {
                throw new ParseException("Invalid TIMESTAMP interval: " + str, 0);
            }
            if (parsedRelop[0] != null && parsedRelop[0].length() > 0) {
                ts = Time.parse_ts(parsedRelop[0]);
                epoch_time = ts.getTime() * 1000000L;
                this.m_base_spec.setStart_time(epoch_time);
                if (parsedRelop[1].equals("=")) {
                    this.m_base_spec.setEnd_time(epoch_time);
                }
            }
            if (parsedRelop[4] != null && parsedRelop[4].length() > 0) {
                ts = Time.parse_ts(parsedRelop[4]);
                epoch_time = ts.getTime() * 1000000L;
                this.m_base_spec.setEnd_time(epoch_time);
                if (parsedRelop[3].equals("=")) {
                    this.m_base_spec.setStart_time(epoch_time);
                }
            }
        }
    }

    public void parseRowInterval(JobConf job) throws ParseException {
        String str = job.get(ROW_INTERVAL);
        if (str != null) {
            String[] parsedRelop = this.parseRelopSpec(str, "ROW");
            RowInterval interval = new RowInterval();
            if (parsedRelop == null) {
                throw new ParseException("Invalid ROW interval: " + str, 0);
            }
            if (parsedRelop[0] != null && parsedRelop[0].length() > 0) {
                interval.setStart_row(parsedRelop[0]);
                interval.setStart_rowIsSet(true);
                if (parsedRelop[1].equals("<")) {
                    interval.setStart_inclusive(false);
                } else if (parsedRelop[1].equals("<=")) {
                    interval.setStart_inclusive(true);
                } else {
                    throw new ParseException("Invalid ROW interval, bad RELOP (" + parsedRelop[1] + ")", 0);
                }
                interval.setStart_inclusiveIsSet(true);
            }
            if (parsedRelop[4] != null && parsedRelop[4].length() > 0) {
                interval.setEnd_row(parsedRelop[4]);
                interval.setEnd_rowIsSet(true);
                if (parsedRelop[3].equals("<")) {
                    interval.setEnd_inclusive(false);
                } else if (parsedRelop[3].equals("<=")) {
                    interval.setEnd_inclusive(true);
                } else {
                    throw new ParseException("Invalid ROW interval, bad RELOP (" + parsedRelop[3] + ")", 0);
                }
                interval.setEnd_inclusiveIsSet(true);
            }
            if (interval.isSetStart_row() || interval.isSetEnd_row()) {
                this.m_base_spec.addToRow_intervals(interval);
                this.m_base_spec.setRow_intervalsIsSet(true);
            }
        }
    }

    public void configure(JobConf job) {
        this.m_include_timestamps = job.getBoolean(INCLUDE_TIMESTAMPS, false);
        try {
            this.m_base_spec = new ScanSpec();
            this.parseColumns(job);
            this.parseOptions(job);
            this.parseTimestampInterval(job);
            this.parseRowInterval(job);
            this.parseValueRegexps(job);
            this.parseColumnPredicate(job);
            System.out.println(this.m_base_spec);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            TableSplit ts = (TableSplit)split;
            if (this.m_namespace == null) {
                this.m_namespace = job.get(INPUT_NAMESPACE);
                if (this.m_namespace == null) {
                    this.m_namespace = job.get(NAMESPACE);
                }
            }
            if (this.m_tablename == null) {
                this.m_tablename = job.get(TABLE);
            }
            ScanSpec scan_spec = ts.createScanSpec(this.m_base_spec);
            System.out.println(scan_spec);
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            return new HypertableRecordReader(this.m_client, this.m_namespace, this.m_tablename, scan_spec);
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        long ns = 0L;
        try {
            Iterator<RowInterval> iter;
            RowInterval ri = null;
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            String tablename = job.get(TABLE);
            String namespace = job.get(INPUT_NAMESPACE);
            if (namespace == null) {
                namespace = job.get(NAMESPACE);
            }
            if ((iter = this.m_base_spec.getRow_intervalsIterator()) != null && iter.hasNext()) {
                ri = iter.next();
                if (iter.hasNext()) {
                    System.out.println("InputFormat only allows a single ROW interval");
                    System.exit(-1);
                }
            }
            ns = this.m_client.namespace_open(namespace);
            List<org.hypertable.thriftgen.TableSplit> tsplits = this.m_client.table_get_splits(ns, tablename);
            ArrayList<TableSplit> splits = new ArrayList<TableSplit>(tsplits.size());
            for (org.hypertable.thriftgen.TableSplit ts : tsplits) {
                if (ri != null && (ri.isSetStart_row() && ts.end_row != null && ts.end_row.compareTo(ri.getStart_row()) <= 0 && (ts.end_row.compareTo(ri.getStart_row()) != 0 || !ri.isStart_inclusive()) || ri.isSetEnd_row() && ts.start_row != null && ts.start_row.compareTo(ri.getEnd_row()) >= 0)) continue;
                byte[] start_row = ts.start_row == null ? null : ts.start_row.getBytes("UTF-8");
                byte[] end_row = ts.end_row == null ? null : ts.end_row.getBytes("UTF-8");
                TableSplit split = new TableSplit(tablename.getBytes("UTF-8"), start_row, end_row, ts.hostname);
                splits.add(split);
            }
            InputSplit[] isplits = new InputSplit[splits.size()];
            InputSplit[] inputSplitArray = splits.toArray(isplits);
            return inputSplitArray;
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (ns != 0L) {
                try {
                    this.m_client.namespace_close(ns);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    protected class HypertableRecordReader
    implements RecordReader<Text, Text> {
        private ThriftClient m_client = null;
        private long m_ns = 0L;
        private long m_scanner = 0L;
        private String m_namespace = null;
        private String m_tablename = null;
        private ScanSpec m_scan_spec = null;
        private long m_bytes_read = 0L;
        private List<Cell> m_cells = null;
        private Iterator<Cell> m_iter = null;
        private boolean m_eos = false;
        private Text m_key = new Text();
        private Text m_value = new Text();
        private byte[] t_row = null;
        private byte[] t_column_family = null;
        private byte[] t_column_qualifier = null;
        private byte[] t_timestamp = null;
        private byte[] tab = "\t".getBytes();
        private byte[] colon = ":".getBytes();

        public HypertableRecordReader(ThriftClient client, String namespace, String tablename, ScanSpec scan_spec) throws IOException {
            this.m_client = client;
            this.m_namespace = namespace;
            this.m_tablename = tablename;
            this.m_scan_spec = scan_spec;
            try {
                this.m_ns = this.m_client.namespace_open(this.m_namespace);
                this.m_scanner = this.m_client.scanner_open(this.m_ns, this.m_tablename, this.m_scan_spec);
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }

        public Text createKey() {
            return new Text("");
        }

        public Text createValue() {
            return new Text("");
        }

        public void close() {
            try {
                this.m_client.scanner_close(this.m_scanner);
                if (this.m_ns != 0L) {
                    this.m_client.namespace_close(this.m_ns);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long getPos() throws IOException {
            return this.m_bytes_read;
        }

        public float getProgress() {
            if (this.m_bytes_read >= 200000000L) {
                return 1.0f;
            }
            return (float)this.m_bytes_read / 2.0E8f;
        }

        private void fill_key(Text key, Key cell_key) {
            boolean clear = false;
            try {
                if (TextTableInputFormat.this.m_include_timestamps && cell_key.isSetTimestamp()) {
                    this.t_timestamp = Long.toString(cell_key.timestamp).getBytes("UTF-8");
                    clear = true;
                }
                if (cell_key.isSetRow()) {
                    this.t_row = cell_key.row.getBytes("UTF-8");
                    clear = true;
                }
                if (cell_key.isSetColumn_family()) {
                    this.t_column_family = cell_key.column_family.getBytes("UTF-8");
                    clear = true;
                }
                if (cell_key.isSetColumn_qualifier()) {
                    this.t_column_qualifier = cell_key.column_qualifier.getBytes("UTF-8");
                    clear = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            if (clear) {
                key.clear();
                if (TextTableInputFormat.this.m_include_timestamps) {
                    key.append(this.t_timestamp, 0, this.t_timestamp.length);
                    key.append(this.tab, 0, this.tab.length);
                }
                key.append(this.t_row, 0, this.t_row.length);
                key.append(this.tab, 0, this.tab.length);
                key.append(this.t_column_family, 0, this.t_column_family.length);
                if (this.t_column_qualifier.length > 0) {
                    key.append(this.colon, 0, this.colon.length);
                    key.append(this.t_column_qualifier, 0, this.t_column_qualifier.length);
                }
            }
        }

        public boolean next(Text key, Text value) throws IOException {
            try {
                if (this.m_eos) {
                    return false;
                }
                if (this.m_cells == null || !this.m_iter.hasNext()) {
                    this.m_cells = this.m_client.scanner_get_cells(this.m_scanner);
                    if (this.m_cells.isEmpty()) {
                        this.m_eos = true;
                        return false;
                    }
                    this.m_iter = this.m_cells.iterator();
                }
                Cell cell = this.m_iter.next();
                this.fill_key(key, cell.key);
                this.m_bytes_read += (long)(24 + cell.key.row.length());
                if (cell.value == null || !cell.value.hasRemaining()) {
                    value.set("");
                } else {
                    this.m_bytes_read += (long)cell.value.remaining();
                    value.set(cell.value.array(), cell.value.arrayOffset() + cell.value.position(), cell.value.remaining());
                }
                if (cell.key.column_qualifier != null) {
                    this.m_bytes_read += (long)cell.key.column_qualifier.length();
                }
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            return true;
        }
    }
}

