/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.hypertable.hadoop.mapreduce.InputFormat;
import org.hypertable.hadoop.mapreduce.KeyWritable;
import org.hypertable.hadoop.mapreduce.Mapper;
import org.hypertable.hadoop.mapreduce.OutputFormat;
import org.hypertable.hadoop.mapreduce.Reducer;
import org.hypertable.hadoop.mapreduce.ScanSpec;

public class Helper {
    public static void initMapperJob(String namespace, String table, ScanSpec scan_spec, Class<? extends Mapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job) throws IOException {
        job.setInputFormatClass(InputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        job.getConfiguration().set("hypertable.mapreduce.input.namespace", namespace);
        job.getConfiguration().set("hypertable.mapreduce.input.table", table);
        job.getConfiguration().set("hypertable.mapreduce.input.scan-spec", scan_spec.toSerializedText());
    }

    public static void initReducerJob(String namespace, String table, Class<? extends Reducer> reducer, Job job) throws IOException {
        job.setOutputFormatClass(OutputFormat.class);
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        job.getConfiguration().set("hypertable.mapreduce.output.namespace", namespace);
        job.getConfiguration().set("hypertable.mapreduce.output.table", table);
        job.setOutputKeyClass(KeyWritable.class);
        job.setOutputValueClass(BytesWritable.class);
    }
}

