/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.hypertable.Common.CString;
import org.hypertable.Common.Checksum;
import org.hypertable.thriftgen.Key;
import org.hypertable.thriftgen.KeyFlag;

public class KeyWritable
extends Key
implements WritableComparable<Key> {
    private boolean m_dirty = true;
    private ByteBuffer m_input_buffer;
    private ByteBuffer m_output_buffer;
    private byte[] row_buffer;
    private int row_buffer_offset;
    private int row_buffer_length;
    private byte[] column_family_buffer;
    private int column_family_buffer_offset;
    private int column_family_buffer_length;
    private byte[] column_qualifier_buffer;
    private int column_qualifier_buffer_offset;
    private int column_qualifier_buffer_length;

    @Override
    public Key setRow(String row) {
        this.row = row;
        this.row_buffer = null;
        this.row_buffer_offset = 0;
        this.row_buffer_length = 0;
        this.m_dirty = true;
        return this;
    }

    public Key setRow(byte[] buffer, int offset, int length) {
        this.row = null;
        this.row_buffer = buffer;
        this.row_buffer_offset = offset;
        this.row_buffer_length = length;
        this.m_dirty = true;
        return this;
    }

    @Override
    public String getRow() {
        if (this.row == null && this.row_buffer != null && this.row_buffer_length > 0) {
            try {
                this.row = new String(this.row_buffer, this.row_buffer_offset, this.row_buffer_length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return this.row;
    }

    @Override
    public Key setColumn_family(String column_family) {
        this.column_family = column_family;
        this.column_family_buffer = null;
        this.column_family_buffer_offset = 0;
        this.column_family_buffer_length = 0;
        this.m_dirty = true;
        return this;
    }

    public Key setColumn_family(byte[] buffer, int offset, int length) {
        this.column_family = null;
        this.column_family_buffer = buffer;
        this.column_family_buffer_offset = offset;
        this.column_family_buffer_length = length;
        this.m_dirty = true;
        return this;
    }

    @Override
    public String getColumn_family() {
        if (this.column_family == null && this.column_family_buffer != null && this.column_family_buffer_length > 0) {
            try {
                this.column_family = new String(this.column_family_buffer, this.column_family_buffer_offset, this.column_family_buffer_length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return this.column_family;
    }

    @Override
    public Key setColumn_qualifier(String column_qualifier) {
        this.column_qualifier = column_qualifier;
        this.column_qualifier_buffer = null;
        this.column_qualifier_buffer_offset = 0;
        this.column_qualifier_buffer_length = 0;
        this.m_dirty = true;
        return this;
    }

    public Key setColumn_qualifier(byte[] buffer, int offset, int length) {
        this.column_qualifier = null;
        this.column_qualifier_buffer = buffer;
        this.column_qualifier_buffer_offset = offset;
        this.column_qualifier_buffer_length = length;
        this.m_dirty = true;
        return this;
    }

    @Override
    public String getColumn_qualifier() {
        if (this.column_qualifier == null && this.column_qualifier_buffer != null && this.column_qualifier_buffer_length > 0) {
            try {
                this.column_qualifier = new String(this.column_qualifier_buffer, this.column_qualifier_buffer_offset, this.column_qualifier_buffer_length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return this.column_qualifier;
    }

    @Override
    public Key setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setTimestampIsSet(true);
        this.m_dirty = true;
        return this;
    }

    @Override
    public Key setRevision(long revision) {
        this.revision = revision;
        this.setRevisionIsSet(true);
        this.m_dirty = true;
        return this;
    }

    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        if (this.m_input_buffer == null || len > this.m_input_buffer.capacity()) {
            this.m_input_buffer = ByteBuffer.allocate(len + 16);
            this.m_input_buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.m_input_buffer.clear();
            this.m_input_buffer.limit(len);
        }
        in.readFully(this.m_input_buffer.array(), 0, len);
        short flagVal = this.m_input_buffer.getShort();
        this.flag = KeyFlag.findByValue(flagVal);
        if (this.flag == null) {
            throw new IOException("Can't convert KeyFlag value " + flagVal + " to enum");
        }
        len = KeyWritable.readVInt(this.m_input_buffer);
        if (len > 0) {
            this.row_buffer = this.m_input_buffer.array();
            this.row_buffer_offset = this.m_input_buffer.position();
            this.m_input_buffer.position(this.row_buffer_offset + len);
        } else {
            this.row_buffer = null;
            this.row_buffer_offset = 0;
        }
        this.row_buffer_length = len;
        this.row = null;
        len = KeyWritable.readVInt(this.m_input_buffer);
        if (len > 0) {
            this.column_family_buffer = this.m_input_buffer.array();
            this.column_family_buffer_offset = this.m_input_buffer.position();
            this.m_input_buffer.position(this.column_family_buffer_offset + len);
        } else {
            this.column_family_buffer = null;
            this.column_family_buffer_offset = 0;
        }
        this.column_family_buffer_length = len;
        this.column_family = null;
        len = KeyWritable.readVInt(this.m_input_buffer);
        if (len > 0) {
            this.column_qualifier_buffer = this.m_input_buffer.array();
            this.column_qualifier_buffer_offset = this.m_input_buffer.position();
            this.m_input_buffer.position(this.column_qualifier_buffer_offset + len);
        } else {
            this.column_qualifier_buffer = null;
            this.column_qualifier_buffer_offset = 0;
        }
        this.column_qualifier_buffer_length = len;
        this.column_qualifier = null;
        this.timestamp = this.m_input_buffer.getLong();
        this.setTimestampIsSet(true);
        this.revision = this.m_input_buffer.getLong();
        this.setRevisionIsSet(true);
        this.m_dirty = false;
    }

    public void write(DataOutput out) throws IOException {
        int position;
        if (!this.m_dirty) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.m_input_buffer.position());
            out.write(this.m_input_buffer.array(), 0, this.m_input_buffer.position());
            return;
        }
        this.convert_strings_to_buffers();
        int serial_length = this.row_buffer_length + this.column_family_buffer_length + this.column_qualifier_buffer_length + 30;
        if (this.m_output_buffer == null || serial_length > this.m_output_buffer.capacity()) {
            this.m_output_buffer = ByteBuffer.allocate(serial_length + 16);
            this.m_output_buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.m_output_buffer.clear();
            this.m_output_buffer.limit(serial_length);
        }
        this.m_output_buffer.putShort((short)this.flag.getValue());
        if (this.row_buffer != null) {
            KeyWritable.writeVInt(this.m_output_buffer, this.row_buffer_length);
            position = this.m_output_buffer.position();
            this.m_output_buffer.put(this.row_buffer, this.row_buffer_offset, this.row_buffer_length);
            this.row_buffer = this.m_output_buffer.array();
            this.row_buffer_offset = position;
        } else {
            KeyWritable.writeVInt(this.m_output_buffer, 0);
        }
        if (this.column_family_buffer != null) {
            KeyWritable.writeVInt(this.m_output_buffer, this.column_family_buffer_length);
            position = this.m_output_buffer.position();
            this.m_output_buffer.put(this.column_family_buffer, this.column_family_buffer_offset, this.column_family_buffer_length);
            this.column_family_buffer = this.m_output_buffer.array();
            this.column_family_buffer_offset = position;
        } else {
            KeyWritable.writeVInt(this.m_output_buffer, 0);
        }
        if (this.column_qualifier_buffer != null) {
            KeyWritable.writeVInt(this.m_output_buffer, this.column_qualifier_buffer_length);
            position = this.m_output_buffer.position();
            this.m_output_buffer.put(this.column_qualifier_buffer, this.column_qualifier_buffer_offset, this.column_qualifier_buffer_length);
            this.column_qualifier_buffer = this.m_output_buffer.array();
            this.column_qualifier_buffer_offset = position;
        } else {
            KeyWritable.writeVInt(this.m_output_buffer, 0);
        }
        if (!this.isSetTimestamp()) {
            this.timestamp = -9223372036854775806L;
            this.setTimestampIsSet(true);
        }
        this.m_output_buffer.putLong(this.timestamp);
        if (!this.isSetRevision()) {
            this.revision = -9223372036854775806L;
            this.setRevisionIsSet(true);
        }
        this.m_output_buffer.putLong(this.revision);
        WritableUtils.writeVInt((DataOutput)out, (int)this.m_output_buffer.position());
        out.write(this.m_output_buffer.array(), 0, this.m_output_buffer.position());
    }

    @Override
    public int hashCode() {
        try {
            if (this.row_buffer == null) {
                this.row_string_to_buffer();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (this.row_buffer != null) {
            return Checksum.fletcher32(this.row_buffer, this.row_buffer_offset, this.row_buffer_length);
        }
        return 0;
    }

    @Override
    public int compareTo(Key other_key) {
        KeyWritable other;
        try {
            other = (KeyWritable)other_key;
        }
        catch (ClassCastException e) {
            this.convert_buffers_to_strings();
            return super.compareTo(other_key);
        }
        this.convert_strings_to_buffers();
        other.convert_strings_to_buffers();
        int cmp = CString.memcmp(this.row_buffer, this.row_buffer_offset, this.row_buffer_length, other.row_buffer, other.row_buffer_offset, other.row_buffer_length);
        if (cmp != 0) {
            return cmp;
        }
        cmp = CString.memcmp(this.column_family_buffer, this.column_family_buffer_offset, this.column_family_buffer_length, other.column_family_buffer, other.column_family_buffer_offset, other.column_family_buffer_length);
        if (cmp != 0) {
            return cmp;
        }
        cmp = CString.memcmp(this.column_qualifier_buffer, this.column_qualifier_buffer_offset, this.column_qualifier_buffer_length, other.column_qualifier_buffer, other.column_qualifier_buffer_offset, other.column_qualifier_buffer_length);
        return cmp;
    }

    public void load(Key key) {
        try {
            if (key.isSetRow()) {
                this.row = key.row;
                this.setRowIsSet(true);
                this.row_string_to_buffer();
            }
            if (key.isSetColumn_family()) {
                this.column_family = key.column_family;
                this.setColumn_familyIsSet(true);
                this.column_family_string_to_buffer();
            }
            if (key.isSetColumn_qualifier()) {
                this.column_qualifier = key.column_qualifier;
                this.setColumn_qualifierIsSet(true);
                this.column_qualifier_string_to_buffer();
            }
            if (key.isSetFlag()) {
                this.flag = key.flag;
                this.setFlagIsSet(true);
            }
            if (key.isSetTimestamp()) {
                this.timestamp = key.timestamp;
                this.setTimestampIsSet(true);
            } else {
                this.timestamp = -9223372036854775806L;
            }
            if (key.isSetRevision()) {
                this.revision = key.revision;
                this.setRevisionIsSet(true);
            } else {
                this.revision = -9223372036854775806L;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void convert_strings_to_buffers() {
        try {
            if (this.row_buffer == null) {
                this.row_string_to_buffer();
            }
            if (this.column_family_buffer == null) {
                this.column_family_string_to_buffer();
            }
            if (this.column_qualifier_buffer == null) {
                this.column_qualifier_string_to_buffer();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void row_string_to_buffer() throws UnsupportedEncodingException {
        if (this.row != null) {
            this.row_buffer = this.row.getBytes("UTF-8");
            this.row_buffer_offset = 0;
            this.row_buffer_length = this.row_buffer.length;
            this.m_dirty = true;
        }
    }

    private void column_family_string_to_buffer() throws UnsupportedEncodingException {
        if (this.column_family != null) {
            this.column_family_buffer = this.column_family.getBytes("UTF-8");
            this.column_family_buffer_offset = 0;
            this.column_family_buffer_length = this.column_family_buffer.length;
            this.m_dirty = true;
        }
    }

    private void column_qualifier_string_to_buffer() throws UnsupportedEncodingException {
        if (this.column_qualifier != null) {
            this.column_qualifier_buffer = this.column_qualifier.getBytes("UTF-8");
            this.column_qualifier_buffer_offset = 0;
            this.column_qualifier_buffer_length = this.column_qualifier_buffer.length;
            this.m_dirty = true;
        }
    }

    public void convert_buffers_to_strings() {
        try {
            if (this.row == null) {
                this.row_buffer_to_string();
            }
            if (this.column_family == null) {
                this.column_family_buffer_to_string();
            }
            if (this.column_qualifier == null) {
                this.column_qualifier_buffer_to_string();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void row_buffer_to_string() throws UnsupportedEncodingException {
        this.row = this.row_buffer != null ? new String(this.row_buffer, this.row_buffer_offset, this.row_buffer_length, "UTF-8") : new String();
    }

    private void column_family_buffer_to_string() throws UnsupportedEncodingException {
        this.column_family = this.column_family_buffer != null ? new String(this.column_family_buffer, this.column_family_buffer_offset, this.column_family_buffer_length, "UTF-8") : new String();
    }

    private void column_qualifier_buffer_to_string() throws UnsupportedEncodingException {
        this.column_qualifier = this.column_qualifier_buffer != null ? new String(this.column_qualifier_buffer, this.column_qualifier_buffer_offset, this.column_qualifier_buffer_length, "UTF-8") : new String();
    }

    public static void writeVInt(ByteBuffer buf, int i) throws IOException {
        if (i >= -112 && i <= 127) {
            buf.put((byte)i);
            return;
        }
        int len = -112;
        if (i < 0) {
            i = (int)((long)i ^ 0xFFFFFFFFFFFFFFFFL);
            len = -120;
        }
        int tmp = i;
        while (tmp != 0) {
            tmp >>= 8;
            --len;
        }
        buf.put((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            buf.put((byte)(((long)i & mask) >> shiftbits));
        }
    }

    public static int readVInt(ByteBuffer buf) throws IOException {
        byte firstByte = buf.get();
        int len = KeyWritable.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buf.get();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return (int)(KeyWritable.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i);
    }

    public static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static int getVIntSize(long i) {
        if (i >= -112L && i <= 127L) {
            return 1;
        }
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int dataBits = 64 - Long.numberOfLeadingZeros(i);
        return (dataBits + 7) / 8 + 1;
    }

    @Override
    public String toString() {
        this.convert_buffers_to_strings();
        return "row=\"" + this.row + "\" column=\"" + this.column_family + ":" + this.column_qualifier;
    }
}

