/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapreduce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.hypertable.hadoop.util.Base64;
import org.hypertable.hadoop.util.Serialization;
import org.hypertable.thriftgen.CellInterval;
import org.hypertable.thriftgen.ColumnPredicate;
import org.hypertable.thriftgen.ColumnPredicateOperation;
import org.hypertable.thriftgen.RowInterval;

public class ScanSpec
extends org.hypertable.thriftgen.ScanSpec {
    public ScanSpec() {
    }

    public ScanSpec(ScanSpec other) {
        super(other);
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int len;
        boolean isset = in.readBoolean();
        if (isset) {
            this.setRow_intervalsIsSet(true);
            len = in.readInt();
            if (len > 0) {
                RowInterval ri = null;
                this.row_intervals = new ArrayList(len);
                for (i = 0; i < len; ++i) {
                    ri = new RowInterval();
                    ri.start_row = new String(Serialization.readByteArray(in), "UTF-8");
                    ri.start_inclusive = in.readBoolean();
                    ri.end_row = new String(Serialization.readByteArray(in), "UTF-8");
                    ri.end_inclusive = in.readBoolean();
                    this.row_intervals.add(ri);
                }
            }
        }
        if (isset = in.readBoolean()) {
            this.setCell_intervalsIsSet(true);
            len = in.readInt();
            if (len > 0) {
                CellInterval ci = null;
                this.cell_intervals = new ArrayList(len);
                for (i = 0; i < len; ++i) {
                    ci = new CellInterval();
                    ci.start_row = new String(Serialization.readByteArray(in), "UTF-8");
                    ci.start_column = new String(Serialization.readByteArray(in), "UTF-8");
                    ci.start_inclusive = in.readBoolean();
                    ci.end_row = new String(Serialization.readByteArray(in), "UTF-8");
                    ci.end_column = new String(Serialization.readByteArray(in), "UTF-8");
                    ci.end_inclusive = in.readBoolean();
                    this.cell_intervals.add(ci);
                }
            }
        }
        if (isset = in.readBoolean()) {
            this.setColumnsIsSet(true);
            len = in.readInt();
            if (len > 0) {
                this.columns = new ArrayList(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    this.columns.add(new String(Serialization.readByteArray(in), "UTF-8"));
                }
            }
        }
        if (isset = in.readBoolean()) {
            this.setReturn_deletesIsSet(true);
            this.return_deletes = in.readBoolean();
        }
        if (isset = in.readBoolean()) {
            this.setVersionsIsSet(true);
            this.versions = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setRow_limitIsSet(true);
            this.row_limit = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setStart_timeIsSet(true);
            this.start_time = in.readLong();
        } else {
            this.start_time = Long.MIN_VALUE;
        }
        isset = in.readBoolean();
        if (isset) {
            this.setEnd_timeIsSet(true);
            this.end_time = in.readLong();
        } else {
            this.end_time = Long.MAX_VALUE;
        }
        isset = in.readBoolean();
        if (isset) {
            this.setKeys_onlyIsSet(true);
            this.keys_only = in.readBoolean();
        }
        if (isset = in.readBoolean()) {
            this.setCell_limitIsSet(true);
            this.cell_limit = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setCell_limit_per_familyIsSet(true);
            this.cell_limit_per_family = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setRow_offsetIsSet(true);
            this.row_offset = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setCell_offsetIsSet(true);
            this.cell_offset = in.readInt();
        }
        if (isset = in.readBoolean()) {
            this.setScan_and_filter_rowsIsSet(true);
            this.scan_and_filter_rows = in.readBoolean();
        }
        if (isset = in.readBoolean()) {
            this.setRow_regexpIsSet(true);
            this.row_regexp = new String(Serialization.readByteArray(in), "UTF-8");
        }
        if (isset = in.readBoolean()) {
            this.setValue_regexpIsSet(true);
            this.value_regexp = new String(Serialization.readByteArray(in), "UTF-8");
        }
        if (isset = in.readBoolean()) {
            this.setColumn_predicatesIsSet(true);
            len = in.readInt();
            if (len > 0) {
                this.column_predicates = new ArrayList(len);
                for (int i3 = 0; i3 < len; ++i3) {
                    ColumnPredicate cp = new ColumnPredicate();
                    cp.column_family = new String(Serialization.readByteArray(in), "UTF-8");
                    cp.setColumn_familyIsSet(true);
                    cp.value = new String(Serialization.readByteArray(in), "UTF-8");
                    cp.setValueIsSet(true);
                    cp.operation = ColumnPredicateOperation.findByValue(in.readInt());
                    cp.setOperationIsSet(true);
                    this.column_predicates.add(cp);
                }
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        byte[] empty = new byte[]{};
        try {
            if (this.isSetRow_intervals()) {
                out.writeBoolean(true);
                out.writeInt(this.row_intervals.size());
                for (RowInterval ri : this.row_intervals) {
                    if (ri.isSetStart_row()) {
                        Serialization.writeByteArray(out, ri.start_row.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ri.isSetStart_inclusive()) {
                        out.writeBoolean(ri.start_inclusive);
                    } else {
                        out.writeBoolean(true);
                    }
                    if (ri.isSetEnd_row()) {
                        Serialization.writeByteArray(out, ri.end_row.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ri.isSetEnd_inclusive()) {
                        out.writeBoolean(ri.end_inclusive);
                        continue;
                    }
                    out.writeBoolean(true);
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetCell_intervals()) {
                out.writeBoolean(true);
                out.writeInt(this.cell_intervals.size());
                for (CellInterval ci : this.cell_intervals) {
                    if (ci.isSetStart_row()) {
                        Serialization.writeByteArray(out, ci.start_row.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ci.isSetStart_column()) {
                        Serialization.writeByteArray(out, ci.start_column.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ci.isSetStart_inclusive()) {
                        out.writeBoolean(ci.start_inclusive);
                    } else {
                        out.writeBoolean(true);
                    }
                    if (ci.isSetEnd_row()) {
                        Serialization.writeByteArray(out, ci.end_row.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ci.isSetEnd_column()) {
                        Serialization.writeByteArray(out, ci.end_column.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (ci.isSetEnd_inclusive()) {
                        out.writeBoolean(ci.end_inclusive);
                        continue;
                    }
                    out.writeBoolean(true);
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetColumns()) {
                out.writeBoolean(true);
                out.writeInt(this.columns.size());
                for (String s : this.columns) {
                    Serialization.writeByteArray(out, s.getBytes("UTF-8"));
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetReturn_deletes()) {
                out.writeBoolean(true);
                out.writeBoolean(this.return_deletes);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetVersions()) {
                out.writeBoolean(true);
                out.writeInt(this.versions);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetRow_limit()) {
                out.writeBoolean(true);
                out.writeInt(this.row_limit);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetStart_time()) {
                out.writeBoolean(true);
                out.writeLong(this.start_time);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetEnd_time()) {
                out.writeBoolean(true);
                out.writeLong(this.end_time);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetKeys_only()) {
                out.writeBoolean(true);
                out.writeBoolean(this.keys_only);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetCell_limit()) {
                out.writeBoolean(true);
                out.writeInt(this.cell_limit);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetCell_limit_per_family()) {
                out.writeBoolean(true);
                out.writeInt(this.cell_limit_per_family);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetRow_offset()) {
                out.writeBoolean(true);
                out.writeInt(this.row_offset);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetCell_offset()) {
                out.writeBoolean(true);
                out.writeInt(this.cell_offset);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetScan_and_filter_rows()) {
                out.writeBoolean(true);
                out.writeBoolean(this.scan_and_filter_rows);
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetRow_regexp()) {
                out.writeBoolean(true);
                Serialization.writeByteArray(out, this.row_regexp.getBytes("UTF-8"));
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetValue_regexp()) {
                out.writeBoolean(true);
                Serialization.writeByteArray(out, this.value_regexp.getBytes("UTF-8"));
            } else {
                out.writeBoolean(false);
            }
            if (this.isSetColumn_predicates()) {
                out.writeBoolean(true);
                out.writeInt(this.column_predicates.size());
                for (ColumnPredicate cp : this.column_predicates) {
                    if (cp.isSetColumn_family()) {
                        Serialization.writeByteArray(out, cp.column_family.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    if (cp.isSetValue()) {
                        Serialization.writeByteArray(out, cp.value.getBytes("UTF-8"));
                    } else {
                        Serialization.writeByteArray(out, empty);
                    }
                    out.writeInt(cp.operation.getValue());
                }
            } else {
                out.writeBoolean(false);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String toSerializedText() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        this.write(dos);
        return Base64.encodeBytes(out.toByteArray());
    }

    public static ScanSpec serializedTextToScanSpec(String serializedText) throws IOException {
        ScanSpec scan_spec = new ScanSpec();
        if (serializedText != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decode(serializedText));
            DataInputStream dis = new DataInputStream(bis);
            scan_spec.readFields(dis);
        }
        return scan_spec;
    }

    public static void main(String[] args) {
        ScanSpec dest = null;
        ScanSpec src = new ScanSpec();
        ArrayList<RowInterval> row_intervals = new ArrayList<RowInterval>(2);
        RowInterval ri = new RowInterval();
        ri.start_row = "start1";
        ri.start_inclusive = true;
        ri.end_row = "end1";
        ri.end_inclusive = true;
        row_intervals.add(ri);
        ri = new RowInterval();
        ri.start_row = "start2";
        ri.setStart_inclusive(false);
        ri.end_row = "end2";
        ri.setEnd_inclusive(false);
        row_intervals.add(ri);
        src.setRow_intervals(row_intervals);
        ArrayList<CellInterval> cell_intervals = new ArrayList<CellInterval>(2);
        CellInterval ci = new CellInterval();
        ci.start_row = "start_row1";
        ci.start_column = "start_col1";
        ci.start_inclusive = true;
        ci.end_row = "end_row1";
        ci.end_column = "end_col1";
        ci.end_inclusive = true;
        cell_intervals.add(ci);
        ci = new CellInterval();
        ci.start_row = "start_row2";
        ci.start_column = "start_col2";
        ci.setStart_inclusive(false);
        ci.end_row = "end_row2";
        ci.end_column = "end_col2";
        ci.setEnd_inclusive(false);
        cell_intervals.add(ci);
        src.setCell_intervals(cell_intervals);
        src.setReturn_deletes(true);
        src.setVersions(3);
        src.setRow_limit(4);
        src.setStart_time(5L);
        src.setEnd_time(6L);
        ArrayList<String> columns = new ArrayList<String>(3);
        columns.add("col1");
        columns.add("col2");
        columns.add("col3");
        src.setColumns(columns);
        src.setKeys_only(true);
        src.setCell_limit(6);
        src.setCell_limit_per_family(7);
        src.setRow_offset(8);
        src.setCell_offset(9);
        src.setScan_and_filter_rows(true);
        src.setRow_regexp("aaa");
        src.setValue_regexp("bbb");
        ArrayList<ColumnPredicate> predicates = new ArrayList<ColumnPredicate>(2);
        ColumnPredicate cp = new ColumnPredicate();
        cp.column_family = "col1";
        cp.value = "val1";
        cp.operation = ColumnPredicateOperation.findByValue(1);
        predicates.add(cp);
        cp = new ColumnPredicate();
        cp.column_family = "col2";
        cp.value = "val2";
        cp.operation = ColumnPredicateOperation.findByValue(2);
        predicates.add(cp);
        src.setColumn_predicates(predicates);
        try {
            String s = src.toSerializedText();
            dest = ScanSpec.serializedTextToScanSpec(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        assert (dest.row_intervals.size() == 2);
        assert (dest.isSetRow_intervals());
        ri = (RowInterval)dest.row_intervals.get(0);
        assert (ri.start_row.equals("start1"));
        assert (ri.isSetStart_row());
        assert (ri.start_inclusive);
        assert (ri.end_row.equals("end1"));
        assert (ri.isSetEnd_row());
        assert (ri.end_inclusive);
        ri = (RowInterval)dest.row_intervals.get(1);
        assert (ri.start_row.equals("start2"));
        assert (ri.isSetStart_row());
        assert (!ri.start_inclusive);
        assert (ri.end_row.equals("end2"));
        assert (ri.isSetEnd_row());
        assert (!ri.end_inclusive);
        assert (dest.cell_intervals.size() == 2);
        assert (dest.isSetCell_intervals());
        ci = (CellInterval)dest.cell_intervals.get(0);
        assert (ci.start_row.equals("start_row1"));
        assert (ci.start_column.equals("start_col1"));
        assert (ci.start_inclusive);
        assert (ci.end_row.equals("end_row1"));
        assert (ci.end_column.equals("end_col1"));
        assert (ci.end_inclusive);
        ci = (CellInterval)dest.cell_intervals.get(1);
        assert (ci.start_row.equals("start_row2"));
        assert (ci.start_column.equals("start_col2"));
        assert (!ci.start_inclusive);
        assert (ci.end_row.equals("end_row2"));
        assert (ci.end_column.equals("end_col2"));
        assert (!ci.end_inclusive);
        assert (dest.isSetReturn_deletes());
        assert (dest.return_deletes);
        assert (dest.isSetVersions());
        assert (dest.versions == 3);
        assert (dest.isSetRow_limit());
        assert (dest.row_limit == 4);
        assert (dest.isSetStart_time());
        assert (dest.start_time == 5L);
        assert (dest.isSetEnd_time());
        assert (dest.end_time == 6L);
        assert (dest.isSetColumns());
        assert (dest.columns.size() == 3);
        assert (((String)dest.columns.get(0)).equals("col1"));
        assert (((String)dest.columns.get(1)).equals("col2"));
        assert (((String)dest.columns.get(2)).equals("col3"));
        assert (dest.isSetKeys_only());
        assert (dest.keys_only);
        assert (dest.isSetCell_limit());
        assert (dest.cell_limit == 6);
        assert (dest.isSetCell_limit_per_family());
        assert (dest.cell_limit_per_family == 7);
        assert (dest.isSetRow_offset());
        assert (dest.row_offset == 8);
        assert (dest.isSetCell_offset());
        assert (dest.cell_offset == 9);
        assert (dest.isSetScan_and_filter_rows());
        assert (dest.scan_and_filter_rows);
        assert (dest.isSetRow_regexp());
        assert (dest.row_regexp.equals("aaa"));
        assert (dest.isSetValue_regexp());
        assert (dest.value_regexp.equals("bbb"));
        assert (dest.column_predicates.size() == 2);
        assert (dest.isSetColumn_predicates());
        cp = (ColumnPredicate)dest.column_predicates.get(0);
        assert (cp.column_family.equals("col1"));
        assert (cp.value.equals("val1"));
        assert (cp.operation.getValue() == 1);
        cp = (ColumnPredicate)dest.column_predicates.get(1);
        assert (cp.column_family.equals("col2"));
        assert (cp.value.equals("val2"));
        assert (cp.operation.getValue() == 2);
        System.out.println("SUCCESS");
        System.exit(0);
    }
}

