/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.thrift;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.Cell;
import org.hypertable.thriftgen.HqlResult;
import org.hypertable.thriftgen.Key;
import org.hypertable.thriftgen.MutateSpec;
import org.hypertable.thriftgen.Result;
import org.hypertable.thriftgen.ScanSpec;
import org.hypertable.thriftgen.Schema;

public class BasicClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ThriftClient client = null;
        long ns = -1L;
        try {
            String s;
            byte[] tmp;
            List<Cell> cells;
            client = ThriftClient.create("localhost", 38080);
            ns = client.namespace_open("test");
            BasicClientTest.show(client.hql_query(ns, "show tables").toString());
            BasicClientTest.show(client.hql_query(ns, "select * from thrift_test").toString());
            Schema schema = new Schema();
            schema = client.table_get_schema(ns, "thrift_test");
            Iterator<String> ag_it = schema.access_groups.keySet().iterator();
            BasicClientTest.show("Access groups:");
            while (ag_it.hasNext()) {
                BasicClientTest.show("\t" + ag_it.next());
            }
            Iterator<String> cf_it = schema.column_families.keySet().iterator();
            BasicClientTest.show("Column families:");
            while (cf_it.hasNext()) {
                BasicClientTest.show("\t" + cf_it.next());
            }
            long mutator = client.mutator_open(ns, "thrift_test", 0, 0);
            try {
                Cell cell = new Cell();
                Key key = new Key();
                key.setRow("java-k1");
                key.setColumn_family("col");
                cell.setKey(key);
                String vtmp = "java-v1";
                cell.setValue(ByteBuffer.wrap(vtmp.getBytes()));
                client.mutator_set_cell(mutator, cell);
            }
            finally {
                client.mutator_close(mutator);
            }
            MutateSpec mutate_spec = new MutateSpec();
            mutate_spec.setAppname("test-java");
            mutate_spec.setFlush_interval(1000);
            Cell cell = new Cell();
            Key key = new Key();
            key.setRow("java-put1");
            key.setColumn_family("col");
            cell.setKey(key);
            String vtmp = "java-put-v1";
            cell.setValue(ByteBuffer.wrap(vtmp.getBytes()));
            client.offer_cell(ns, "thrift_test", mutate_spec, cell);
            key = new Key();
            key.setRow("java-put2");
            key.setColumn_family("col");
            cell.setKey(key);
            vtmp = "java-put-v2";
            cell.setValue(ByteBuffer.wrap(vtmp.getBytes()));
            client.shared_mutator_refresh(ns, "thrift_test", mutate_spec);
            client.shared_mutator_set_cell(ns, "thrift_test", mutate_spec, cell);
            Thread.sleep(2000L);
            System.out.println("Full scan");
            ScanSpec scanSpec = new ScanSpec();
            long scanner = client.scanner_open(ns, "thrift_test", scanSpec);
            try {
                cells = client.scanner_get_cells(scanner);
                while (cells.size() > 0) {
                    for (Cell cell2 : cells) {
                        tmp = cell2.getValue();
                        s = new String(tmp);
                        BasicClientTest.show(s);
                    }
                    cells = client.scanner_get_cells(scanner);
                }
            }
            finally {
                client.scanner_close(scanner);
            }
            scanSpec.addToColumns("col:/^.*$/");
            scanSpec.setRow_regexp("java.*");
            scanSpec.setValue_regexp("v2");
            scanner = client.scanner_open(ns, "thrift_test", scanSpec);
            System.out.println("Restricted scan");
            try {
                cells = client.scanner_get_cells(scanner);
                while (cells.size() > 0) {
                    for (Cell cell2 : cells) {
                        tmp = cell2.getValue();
                        s = new String(tmp);
                        BasicClientTest.show(s);
                    }
                    cells = client.scanner_get_cells(scanner);
                }
            }
            finally {
                client.scanner_close(scanner);
            }
            long future = 0L;
            long mutator_async_1 = 0L;
            long mutator_async_2 = 0L;
            long color_scanner = 0L;
            long location_scanner = 0L;
            long energy_scanner = 0L;
            int expected_cells = 6;
            int num_cells = 0;
            try {
                System.out.println("Asynchronous mutator");
                future = client.future_open(0);
                mutator_async_1 = client.async_mutator_open(ns, "thrift_test", future, 0);
                mutator_async_2 = client.async_mutator_open(ns, "thrift_test", future, 0);
                Cell cell3 = new Cell();
                Key key2 = new Key();
                key2.setRow("java-put1");
                key2.setColumn_family("col");
                cell3.setKey(key2);
                String vtmp2 = "java-async-put-v1";
                cell3.setValue(ByteBuffer.wrap(vtmp2.getBytes()));
                client.async_mutator_set_cell(mutator_async_1, cell3);
                key2 = new Key();
                key2.setRow("java-put2");
                key2.setColumn_family("col");
                cell3.setKey(key2);
                vtmp2 = "java-async-put-v2";
                cell3.setValue(ByteBuffer.wrap(vtmp2.getBytes()));
                client.async_mutator_set_cell(mutator_async_2, cell3);
                client.async_mutator_flush(mutator_async_1);
                client.async_mutator_flush(mutator_async_2);
                int num_flushes = 0;
                while (true) {
                    Result result = client.future_get_result(future, 0);
                    if (result.is_empty || result.is_error || result.is_scan) break;
                    ++num_flushes;
                }
                if (num_flushes > 2) {
                    System.out.println("Expected 2 flushes, received " + num_flushes);
                    System.exit(1);
                }
                if (client.future_is_cancelled(future) || client.future_is_full(future) || !client.future_is_empty(future) || client.future_has_outstanding(future)) {
                    System.out.println("Future object in unexpected state");
                    System.exit(1);
                }
            }
            finally {
                client.async_mutator_close(mutator_async_1);
                client.async_mutator_close(mutator_async_2);
            }
            try {
                block39: {
                    System.out.println("Asynchronous scan");
                    ScanSpec ss = new ScanSpec();
                    color_scanner = client.async_scanner_open(ns, "FruitColor", future, ss);
                    location_scanner = client.async_scanner_open(ns, "FruitLocation", future, ss);
                    energy_scanner = client.async_scanner_open(ns, "FruitEnergy", future, ss);
                    do {
                        Result result = client.future_get_result(future, 0);
                        if (result.is_empty || result.is_error || !result.is_scan) break block39;
                        for (Cell cell4 : result.cells) {
                            byte[] tmp2 = cell4.getValue();
                            String s2 = new String(tmp2);
                            BasicClientTest.show(s2);
                            ++num_cells;
                        }
                    } while (num_cells < 6);
                    client.future_cancel(future);
                }
                if (!client.future_is_cancelled(future)) {
                    System.out.println("Expected future object to be cancelled");
                    System.exit(1);
                }
            }
            finally {
                client.async_scanner_close(color_scanner);
                client.async_scanner_close(location_scanner);
                client.async_scanner_close(energy_scanner);
                client.future_close(future);
            }
            if (num_cells != 6) {
                System.out.println("Expected " + expected_cells + " cells got " + num_cells);
                System.exit(1);
            }
            client.hql_query(ns, "drop table if exists java_thrift_test");
            client.hql_query(ns, "create table java_thrift_test ( c1, c2, c3 )");
            mutator = client.mutator_open(ns, "java_thrift_test", 0, 0);
            Cell cell5 = new Cell();
            Key key3 = new Key();
            key3.setRow("000");
            key3.setColumn_family("c1");
            key3.setColumn_qualifier("test");
            cell5.setKey(key3);
            String str = "foo";
            cell5.setValue(ByteBuffer.wrap(str.getBytes()));
            client.mutator_set_cell(mutator, cell5);
            cell5 = new Cell();
            key3 = new Key();
            key3.setRow("000");
            key3.setColumn_family("c1");
            cell5.setKey(key3);
            str = "bar";
            cell5.setValue(ByteBuffer.wrap(str.getBytes()));
            client.mutator_set_cell(mutator, cell5);
            client.mutator_close(mutator);
            HqlResult result = client.hql_query(ns, "select * from java_thrift_test");
            List<Cell> cells2 = result.cells;
            int qualifier_count = 0;
            for (Cell c : cells2) {
                if (!c.key.isSetColumn_qualifier() || c.key.column_qualifier.length() != 0) continue;
                ++qualifier_count;
            }
            if (qualifier_count != 1) {
                System.out.println("ERROR: Expected qualifier_count of 1, got " + qualifier_count);
                client.namespace_close(ns);
                System.exit(1);
            }
            client.namespace_close(ns);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (client != null && ns != -1L) {
                    client.namespace_close(ns);
                }
            }
            catch (Exception ce) {
                System.err.println("Problen closing namespace \"test\" - " + e.getMessage());
            }
            System.exit(1);
        }
    }

    private static void show(String line) {
        System.out.println(line);
    }
}

