/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.thrift;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;

public class SerializedCellsReader {
    private boolean mEob = false;
    private byte[] mBase;
    private int mBaseOffset;
    private ByteBuffer mBuf;
    private byte mFlag;
    private byte[] mRow;
    private int mRowOffset;
    private int mRowLength;
    private byte[] mColumnFamily;
    private int mColumnFamilyOffset;
    private int mColumnFamilyLength;
    private byte[] mColumnQualifier;
    private int mColumnQualifierOffset;
    private int mColumnQualifierLength;
    private byte[] mValue;
    private int mValueOffset;
    private int mValueLength;
    private long mTimestamp;
    private byte mCellFlag;

    public SerializedCellsReader(byte[] buf) {
        this.mBase = buf;
        this.mBaseOffset = 0;
        if (buf != null) {
            this.mBuf = ByteBuffer.wrap(buf);
            this.mBuf.order(ByteOrder.LITTLE_ENDIAN);
            int version = this.mBuf.getInt();
            if (version != 1) {
                throw new AssertionError((Object)("SerializedCells version mismatch, expected 1, got " + version));
            }
        }
    }

    public void reset(byte[] buf) {
        this.mBase = buf;
        this.mBaseOffset = 0;
        this.mBuf = ByteBuffer.wrap(buf);
        this.mBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.mEob = false;
        this.mRow = null;
        this.mColumnFamily = null;
        this.mColumnQualifier = null;
        this.mValue = null;
        this.mCellFlag = 0;
        int version = this.mBuf.getInt();
        if (version != 1) {
            throw new AssertionError((Object)("SerializedCells version mismatch, expected 1, got " + version));
        }
    }

    public void reset(ByteBuffer buf) {
        try {
            buf.reset();
        }
        catch (InvalidMarkException e) {
            buf.mark();
        }
        this.mBase = buf.array();
        this.mBaseOffset = buf.arrayOffset();
        this.mBuf = buf;
        this.mBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.mEob = false;
        this.mRow = null;
        this.mColumnFamily = null;
        this.mColumnQualifier = null;
        this.mValue = null;
        this.mCellFlag = 0;
        int version = this.mBuf.getInt();
        if (version != 1) {
            throw new AssertionError((Object)("SerializedCells version mismatch, expected 1, got " + version));
        }
    }

    public boolean next() {
        if (this.mEob) {
            return false;
        }
        this.mFlag = this.mBuf.get();
        if ((this.mFlag & 1) != 0) {
            this.mEob = true;
            return false;
        }
        if ((this.mFlag & 0x40) != 0) {
            this.mTimestamp = this.mBuf.getLong();
        }
        if ((this.mFlag & 0xFFFFFF80) != 0 && (this.mFlag & 0x10) == 0) {
            long l = this.mBuf.getLong();
        }
        int row_offset = this.mBuf.position();
        int offset = this.mBuf.position();
        while (this.mBuf.get(offset) != 0) {
            ++offset;
        }
        int length = offset - row_offset;
        this.mBuf.position(offset + 1);
        if (length > 0) {
            this.mRowOffset = row_offset;
            this.mRowLength = length;
            this.mRow = null;
        }
        this.mColumnFamily = null;
        this.mColumnFamilyOffset = this.mBuf.position();
        offset = this.mBuf.position();
        while (this.mBuf.get(offset) != 0) {
            ++offset;
        }
        this.mColumnFamilyLength = offset - this.mColumnFamilyOffset;
        this.mBuf.position(offset + 1);
        this.mColumnQualifier = null;
        this.mColumnQualifierOffset = this.mBuf.position();
        offset = this.mBuf.position();
        while (this.mBuf.get(offset) != 0) {
            ++offset;
        }
        this.mColumnQualifierLength = offset - this.mColumnQualifierOffset;
        this.mBuf.position(offset + 1);
        this.mValue = null;
        this.mValueLength = this.mBuf.getInt();
        this.mValueOffset = this.mBuf.position();
        if (this.mValueLength < 0) {
            System.out.println("vo=" + this.mValueOffset + ", vl=" + this.mValueLength + ", bl=" + this.mBuf.limit());
            System.out.println("ro=" + this.mRowOffset + ", rl=" + this.mRowLength);
            System.out.println("cfo=" + this.mColumnFamilyOffset + ", cfl=" + this.mColumnFamilyLength);
            System.out.println("cqo=" + this.mColumnQualifierOffset + ", cql=" + this.mColumnQualifierLength);
            System.exit(-1);
        }
        this.mBuf.position(this.mValueOffset + this.mValueLength);
        this.mCellFlag = this.mBuf.get();
        return true;
    }

    public byte[] get_row() {
        if (this.mRow == null) {
            this.mRow = new byte[this.mRowLength];
            System.arraycopy(this.mBase, this.mBaseOffset + this.mRowOffset, this.mRow, 0, this.mRowLength);
        }
        return this.mRow;
    }

    public int get_row_length() {
        return this.mRowLength;
    }

    public byte[] get_column_family() {
        if (this.mColumnFamily == null) {
            this.mColumnFamily = new byte[this.mColumnFamilyLength];
            System.arraycopy(this.mBase, this.mBaseOffset + this.mColumnFamilyOffset, this.mColumnFamily, 0, this.mColumnFamilyLength);
        }
        return this.mColumnFamily;
    }

    public int get_column_family_length() {
        return this.mColumnFamilyLength;
    }

    public byte[] get_column_qualifier() {
        if (this.mColumnQualifier == null) {
            this.mColumnQualifier = new byte[this.mColumnQualifierLength];
            System.arraycopy(this.mBase, this.mBaseOffset + this.mColumnQualifierOffset, this.mColumnQualifier, 0, this.mColumnQualifierLength);
        }
        return this.mColumnQualifier;
    }

    public int get_column_qualifier_length() {
        return this.mColumnQualifierLength;
    }

    public long get_timestamp() {
        return this.mTimestamp;
    }

    public byte[] get_value() {
        if (this.mValue == null) {
            this.mValue = new byte[this.mValueLength];
            System.arraycopy(this.mBase, this.mBaseOffset + this.mValueOffset, this.mValue, 0, this.mValueLength);
        }
        return this.mValue;
    }

    public int get_value_length() {
        return this.mValueLength;
    }

    public byte get_flag() {
        return this.mCellFlag;
    }

    public boolean eos() {
        return (this.mFlag & 2) != 0;
    }
}

