/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.WritableComparable;

public class HRegionInfo
extends VersionedWritable
implements WritableComparable<HRegionInfo> {
    private static final byte VERSION = 0;
    private static final Log LOG = LogFactory.getLog(HRegionInfo.class);
    private static final int ENC_SEPARATOR = 46;
    public static final int MD5_HEX_LENGTH = 32;
    public static final int DELIMITER = 44;
    public static final HRegionInfo ROOT_REGIONINFO = new HRegionInfo(0L, HTableDescriptor.ROOT_TABLEDESC);
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, HTableDescriptor.META_TABLEDESC);
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private String regionNameStr = "";
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    protected HTableDescriptor tableDesc = null;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private volatile String encodedName = NO_HASH;
    private byte[] encodedNameAsBytes = null;

    private static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString(regionName, regionName.length - 32 - 1, 32);
        } else {
            int hashVal = Math.abs(JenkinsHash.getInstance().hash(regionName, regionName.length, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("70236052")) {
            return encodedRegionName + "/-ROOT-";
        }
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/.META.";
        }
        return encodedRegionName;
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        this.hashCode = result ^= this.tableDesc.hashCode();
    }

    private HRegionInfo(long regionId, HTableDescriptor tableDesc) {
        this.regionId = regionId;
        this.tableDesc = tableDesc;
        this.regionName = HRegionInfo.createRegionName(tableDesc.getName(), null, regionId, false);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.setHashCode();
    }

    public HRegionInfo() {
        this.tableDesc = new HTableDescriptor();
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableDesc, startKey, endKey, false);
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableDesc, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        if (tableDesc == null) {
            throw new IllegalArgumentException("tableDesc cannot be null");
        }
        this.offLine = false;
        this.regionId = regionid;
        this.regionName = HRegionInfo.createRegionName(tableDesc.getName(), startKey, this.regionId, true);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableDesc = tableDesc;
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.tableDesc = other.getTableDesc();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, long regionid, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, String id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes(id), newFormat);
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, byte[] id, boolean newFormat) {
        byte[] b = new byte[tableName.length + 2 + id.length + (startKey == null ? 0 : startKey.length) + (newFormat ? 34 : 0)];
        int offset = tableName.length;
        System.arraycopy(tableName, 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex(b, 0, offset);
            byte[] md5HashBytes = Bytes.toBytes(md5Hash);
            if (md5HashBytes.length != 32) {
                LOG.error((Object)("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length));
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            offset += 32;
            b[offset++] = 46;
        }
        return b;
    }

    public static byte[] getTableName(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        return tableName;
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        for (int i = regionName.length - 1; i > 0; --i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[regionName.length - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, regionName.length - offset - 1);
        byte[][] elements = new byte[][]{tableName, startKey, id};
        return elements;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        if (HRegionInfo.hasEncodedName(this.regionName)) {
            return this.regionNameStr;
        }
        return this.regionNameStr + "." + this.getEncodedName();
    }

    public synchronized String getEncodedName() {
        if (this.encodedName == NO_HASH) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes(this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo(rangeStartKey, rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo(rangeStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo(row, this.startKey) >= 0 && (Bytes.compareTo(row, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY));
    }

    public HTableDescriptor getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(HTableDescriptor newDesc) {
        this.tableDesc = newDesc;
    }

    public boolean isRootRegion() {
        return this.tableDesc.isRootRegion();
    }

    public boolean isMetaTable() {
        return this.tableDesc.isMetaTable();
    }

    public boolean isMetaRegion() {
        return this.tableDesc.isMetaRegion();
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
        }
        return true;
    }

    public String toString() {
        return "REGION => {NAME => '" + this.regionNameStr + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "', ENCODED => " + this.getEncodedName() + "," + (this.isOffline() ? " OFFLINE => true," : "") + (this.isSplit() ? " SPLIT => true," : "") + " TABLE => {" + this.tableDesc.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)((Object)o)) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte getVersion() {
        return 0;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.endKey);
        out.writeBoolean(this.offLine);
        out.writeLong(this.regionId);
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.split);
        Bytes.writeByteArray(out, this.startKey);
        this.tableDesc.write(out);
        out.writeInt(this.hashCode);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.endKey = Bytes.readByteArray(in);
        this.offLine = in.readBoolean();
        this.regionId = in.readLong();
        this.regionName = Bytes.readByteArray(in);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = in.readBoolean();
        this.startKey = Bytes.readByteArray(in);
        this.tableDesc.readFields(in);
        this.hashCode = in.readInt();
    }

    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = Bytes.compareTo(this.tableDesc.getName(), o.tableDesc.getName());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.startKey, o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.endKey, o.endKey);
        if (result != 0) {
            return result;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    public KeyValue.KVComparator getComparator() {
        return this.isRootRegion() ? KeyValue.ROOT_COMPARATOR : (this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR);
    }
}

