/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class MetaEditor {
    private static final Log LOG = LogFactory.getLog(MetaEditor.class);

    private static Put makePutFromRegionInfo(HRegionInfo regionInfo) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)regionInfo));
        return put;
    }

    public static void addRegionToMeta(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        catalogTracker.waitForMetaServerConnectionDefault().put(CatalogTracker.META_REGION, MetaEditor.makePutFromRegionInfo(regionInfo));
        LOG.info((Object)("Added region " + regionInfo.getRegionNameAsString() + " to META"));
    }

    public static void addRegionsToMeta(CatalogTracker catalogTracker, List<HRegionInfo> regionInfos) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (HRegionInfo regionInfo : regionInfos) {
            puts.add(MetaEditor.makePutFromRegionInfo(regionInfo));
            LOG.debug((Object)("Added region " + regionInfo.getRegionNameAsString() + " to META"));
        }
        catalogTracker.waitForMetaServerConnectionDefault().put(CatalogTracker.META_REGION, puts);
        LOG.info((Object)("Added " + puts.size() + " regions to META"));
    }

    public static void offlineParentInMeta(CatalogTracker catalogTracker, HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws NotAllMetaRegionsOnlineException, IOException {
        HRegionInfo copyOfParent = new HRegionInfo(parent);
        copyOfParent.setOffline(true);
        copyOfParent.setSplit(true);
        Put put = new Put(copyOfParent.getRegionName());
        MetaEditor.addRegionInfo(put, copyOfParent);
        put.add(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)a));
        put.add(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)b));
        catalogTracker.waitForMetaServerConnectionDefault().put(CatalogTracker.META_REGION, put);
        LOG.info((Object)("Offlined parent region " + parent.getRegionNameAsString() + " in META"));
    }

    public static void addDaughter(CatalogTracker catalogTracker, HRegionInfo regionInfo, HServerInfo serverInfo) throws NotAllMetaRegionsOnlineException, IOException {
        HRegionInterface server = catalogTracker.waitForMetaServerConnectionDefault();
        byte[] catalogRegionName = CatalogTracker.META_REGION;
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addRegionInfo(put, regionInfo);
        if (serverInfo != null) {
            MetaEditor.addLocation(put, serverInfo);
        }
        server.put(catalogRegionName, put);
        LOG.info((Object)("Added daughter " + regionInfo.getRegionNameAsString() + " in region " + Bytes.toString(catalogRegionName) + (serverInfo == null ? ", serverInfo=null" : ", serverInfo=" + serverInfo.getServerName())));
    }

    public static void updateMetaLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, HServerInfo serverInfo) throws IOException, ConnectException {
        HRegionInterface server = catalogTracker.waitForRootServerConnectionDefault();
        if (server == null) {
            throw new IOException("No server for -ROOT-");
        }
        MetaEditor.updateLocation(server, CatalogTracker.ROOT_REGION, regionInfo, serverInfo);
    }

    public static void updateRegionLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, HServerInfo serverInfo) throws IOException {
        MetaEditor.updateLocation(catalogTracker.waitForMetaServerConnectionDefault(), CatalogTracker.META_REGION, regionInfo, serverInfo);
    }

    private static void updateLocation(HRegionInterface server, byte[] catalogRegionName, HRegionInfo regionInfo, HServerInfo serverInfo) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addLocation(put, serverInfo);
        server.put(catalogRegionName, put);
        LOG.info((Object)("Updated row " + regionInfo.getRegionNameAsString() + " in region " + Bytes.toStringBinary(catalogRegionName) + " with " + "server=" + serverInfo.getHostnamePort() + ", " + "startcode=" + serverInfo.getStartCode()));
    }

    public static void deleteRegion(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        Delete delete = new Delete(regionInfo.getRegionName());
        catalogTracker.waitForMetaServerConnectionDefault().delete(CatalogTracker.META_REGION, delete);
        LOG.info((Object)("Deleted region " + regionInfo.getRegionNameAsString() + " from META"));
    }

    public static void deleteDaughterReferenceInParent(CatalogTracker catalogTracker, HRegionInfo parent, byte[] qualifier, HRegionInfo daughter) throws NotAllMetaRegionsOnlineException, IOException {
        Delete delete = new Delete(parent.getRegionName());
        delete.deleteColumns(HConstants.CATALOG_FAMILY, qualifier);
        catalogTracker.waitForMetaServerConnectionDefault().delete(CatalogTracker.META_REGION, delete);
        LOG.info((Object)("Deleted daughter reference " + daughter.getRegionNameAsString() + ", qualifier=" + Bytes.toStringBinary(qualifier) + ", from parent " + parent.getRegionNameAsString()));
    }

    public static void updateRegionInfo(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addRegionInfo(put, regionInfo);
        catalogTracker.waitForMetaServerConnectionDefault().put(CatalogTracker.META_REGION, put);
        LOG.info((Object)("Updated region " + regionInfo.getRegionNameAsString() + " in META"));
    }

    private static Put addRegionInfo(Put p, HRegionInfo hri) throws IOException {
        p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        return p;
    }

    private static Put addLocation(Put p, HServerInfo hsi) {
        p.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(hsi.getHostnamePort()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes(hsi.getStartCode()));
        return p;
    }
}

