/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class Get
implements Writable,
Row,
Comparable<Row> {
    private static final byte GET_VERSION = 1;
    private byte[] row = null;
    private long lockId = -1L;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private Filter filter = null;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Get() {
    }

    public Get(byte[] row) {
        this(row, null);
    }

    public Get(byte[] row, RowLock rowLock) {
        this.row = row;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Get addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Get addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Get setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Get setTimeStamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Get setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Get setMaxVersions(int maxVersions) throws IOException {
        if (maxVersions <= 0) {
            throw new IOException("maxVersions must be positive");
        }
        this.maxVersions = maxVersions;
        return this;
    }

    public Get setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toStringBinary(this.row));
        sb.append(", maxVersions=");
        sb.append("").append(this.maxVersions);
        sb.append(", cacheBlocks=");
        sb.append(this.cacheBlocks);
        sb.append(", timeRange=");
        sb.append("[").append(this.tr.getMin()).append(",");
        sb.append(this.tr.getMax()).append(")");
        sb.append(", families=");
        if (this.familyMap.size() == 0) {
            sb.append("ALL");
            return sb.toString();
        }
        boolean moreThanOne = false;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("ALL");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (byte[] column : entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(Bytes.toStringBinary(column));
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(Row other) {
        return Bytes.compareTo(this.getRow(), other.getRow());
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("unsupported version");
        }
        this.row = Bytes.readByteArray(in);
        this.lockId = in.readLong();
        this.maxVersions = in.readInt();
        boolean hasFilter = in.readBoolean();
        if (hasFilter) {
            this.filter = (Filter)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.filter.readFields(in);
        }
        this.cacheBlocks = in.readBoolean();
        this.tr = new TimeRange();
        this.tr.readFields(in);
        int numFamilies = in.readInt();
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            boolean hasColumns = in.readBoolean();
            TreeSet<byte[]> set = null;
            if (hasColumns) {
                int numColumns = in.readInt();
                set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                for (int j = 0; j < numColumns; ++j) {
                    byte[] qualifier = Bytes.readByteArray(in);
                    set.add(qualifier);
                }
            }
            this.familyMap.put(family, set);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.lockId);
        out.writeInt(this.maxVersions);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.filter.getClass().getName()));
            this.filter.write(out);
        }
        out.writeBoolean(this.cacheBlocks);
        this.tr.write(out);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            out.writeInt(columnSet.size());
            for (byte[] qualifier : columnSet) {
                Bytes.writeByteArray(out, qualifier);
            }
        }
    }

    private Writable createForName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }

    public Get addColumns(byte[][] columns) {
        if (columns == null) {
            return this;
        }
        for (byte[] column : columns) {
            try {
                this.addColumn(column);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return this;
    }

    public Get addColumn(byte[] column) {
        if (column == null) {
            return this;
        }
        byte[][] split = KeyValue.parseColumn(column);
        if (split.length > 1 && split[1] != null && split[1].length > 0) {
            this.addColumn(split[0], split[1]);
        } else {
            this.addFamily(split[0]);
        }
        return this;
    }
}

