/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class SkipFilter
extends FilterBase {
    private boolean filterRow = false;
    private Filter filter;

    public SkipFilter() {
    }

    public SkipFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() {
        this.filter.reset();
        this.filterRow = false;
    }

    private void changeFR(boolean value) {
        this.filterRow = this.filterRow || value;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        Filter.ReturnCode c = this.filter.filterKeyValue(v);
        this.changeFR(c != Filter.ReturnCode.INCLUDE);
        return c;
    }

    @Override
    public boolean filterRow() {
        return this.filterRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.filter.getClass().getName());
        this.filter.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        String className = in.readUTF();
        try {
            this.filter = (Filter)Class.forName(className).newInstance();
            this.filter.readFields(in);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
    }
}

