/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class TimestampsFilter
extends FilterBase {
    TreeSet<Long> timestamps;
    long minTimeStamp = Long.MAX_VALUE;

    public TimestampsFilter() {
    }

    public TimestampsFilter(List<Long> timestamps) {
        this.timestamps = new TreeSet<Long>(timestamps);
        this.init();
    }

    private void init() {
        if (this.timestamps.size() > 0) {
            this.minTimeStamp = this.timestamps.first();
        }
    }

    public long getMin() {
        return this.minTimeStamp;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.timestamps.contains(v.getTimestamp())) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (v.getTimestamp() < this.minTimeStamp) {
            return Filter.ReturnCode.NEXT_COL;
        }
        return Filter.ReturnCode.SKIP;
    }

    public void readFields(DataInput in) throws IOException {
        int numTimestamps = in.readInt();
        this.timestamps = new TreeSet();
        for (int idx = 0; idx < numTimestamps; ++idx) {
            this.timestamps.add(in.readLong());
        }
        this.init();
    }

    public void write(DataOutput out) throws IOException {
        int numTimestamps = this.timestamps.size();
        out.writeInt(numTimestamps);
        for (Long timestamp : this.timestamps) {
            out.writeLong(timestamp);
        }
    }
}

