/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.ReflectionUtils;

public final class Compression {
    static final Log LOG = LogFactory.getLog(Compression.class);

    private Compression() {
    }

    private static ClassLoader getClassLoaderForCodec() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Compression.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new RuntimeException("A ClassLoader to load the Codec could not be determined");
        }
        return cl;
    }

    public static Algorithm getCompressionAlgorithmByName(String compressName) {
        Algorithm[] algos;
        for (Algorithm a : algos = (Algorithm[])Algorithm.class.getEnumConstants()) {
            if (!a.getName().equals(compressName)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + compressName);
    }

    static String[] getSupportedAlgorithms() {
        Algorithm[] algos = (Algorithm[])Algorithm.class.getEnumConstants();
        String[] ret = new String[algos.length];
        int i = 0;
        for (Algorithm a : algos) {
            ret[i++] = a.getName();
        }
        return ret;
    }

    public static enum Algorithm {
        LZO("lzo"){
            private transient CompressionCodec lzoCodec;

            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lzoCodec == null) {
                    try {
                        Class<?> externalCodec = Compression.getClassLoaderForCodec().loadClass("com.hadoop.compression.lzo.LzoCodec");
                        this.lzoCodec = (CompressionCodec)ReflectionUtils.newInstance(externalCodec, (Configuration)new Configuration(conf));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.lzoCodec;
            }
        }
        ,
        GZ("gz"){
            private transient GzipCodec codec;

            DefaultCodec getCodec(Configuration conf) {
                if (this.codec == null) {
                    this.codec = new GzipCodec();
                    this.codec.setConf(new Configuration(conf));
                }
                return this.codec;
            }
        }
        ,
        NONE("none"){

            DefaultCodec getCodec(Configuration conf) {
                return null;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedInputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedOutputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }
        }
        ,
        SNAPPY("snappy"){
            private transient CompressionCodec snappyCodec;

            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.snappyCodec == null) {
                    try {
                        Class<?> externalCodec = Compression.getClassLoaderForCodec().loadClass("org.apache.hadoop.io.compress.SnappyCodec");
                        this.snappyCodec = (CompressionCodec)ReflectionUtils.newInstance(externalCodec, (Configuration)conf);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.snappyCodec;
            }
        };

        private final Configuration conf = new Configuration();
        private final String compressName;
        private static final int DATA_IBUF_SIZE = 1024;
        private static final int DATA_OBUF_SIZE = 4096;

        private Algorithm(String name) {
            this.conf.setBoolean("hadoop.native.lib", true);
            this.compressName = name;
        }

        abstract CompressionCodec getCodec(Configuration var1);

        public InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            if (downStreamBufferSize > 0) {
                ((Configurable)codec).getConf().setInt("io.file.buffer.size", downStreamBufferSize);
            }
            CompressionInputStream cis = codec.createInputStream(downStream, decompressor);
            BufferedInputStream bis2 = new BufferedInputStream((InputStream)cis, 1024);
            return bis2;
        }

        public OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            OutputStream bos1 = null;
            bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
            ((Configurable)codec).getConf().setInt("io.file.buffer.size", 32768);
            CompressionOutputStream cos = codec.createOutputStream(bos1, compressor);
            BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
            return bos2;
        }

        public Compressor getCompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Compressor compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (compressor != null) {
                    if (compressor.finished()) {
                        LOG.warn((Object)"Compressor obtained from CodecPool is already finished()");
                    }
                    compressor.reset();
                }
                return compressor;
            }
            return null;
        }

        public void returnCompressor(Compressor compressor) {
            if (compressor != null) {
                CodecPool.returnCompressor((Compressor)compressor);
            }
        }

        public Decompressor getDecompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (decompressor != null) {
                    if (decompressor.finished()) {
                        LOG.warn((Object)"Deompressor obtained from CodecPool is already finished()");
                    }
                    decompressor.reset();
                }
                return decompressor;
            }
            return null;
        }

        public void returnDecompressor(Decompressor decompressor) {
            if (decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)decompressor);
            }
        }

        public String getName() {
            return this.compressName;
        }
    }

    static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        public FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super((OutputStream)cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

