/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class Export {
    private static final Log LOG = LogFactory.getLog(Export.class);
    static final String NAME = "export";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path outputDir = new Path(args[1]);
        Job job = new Job(conf, "export_" + tableName);
        job.setJobName("export_" + tableName);
        job.setJarByClass(Exporter.class);
        Scan s = new Scan();
        int versions = args.length > 2 ? Integer.parseInt(args[2]) : 1;
        s.setMaxVersions(versions);
        long startTime = args.length > 3 ? Long.parseLong(args[3]) : 0L;
        long endTime = args.length > 4 ? Long.parseLong(args[4]) : Long.MAX_VALUE;
        s.setTimeRange(startTime, endTime);
        s.setCacheBlocks(false);
        if (conf.get("hbase.mapreduce.scan.column.family") != null) {
            s.addFamily(Bytes.toBytes(conf.get("hbase.mapreduce.scan.column.family")));
        }
        LOG.info((Object)("verisons=" + versions + ", starttime=" + startTime + ", endtime=" + endTime));
        TableMapReduceUtil.initTableMapperJob(tableName, s, Exporter.class, null, null, job);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]]]\n");
        System.err.println("  Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -D mapred.output.compress=true");
        System.err.println("   -D mapred.output.compression.codec=org.apache.hadoop.io.compress.GzipCodec");
        System.err.println("   -D mapred.output.compression.type=BLOCK");
        System.err.println("  Additionally, the following SCAN properties can be specified");
        System.err.println("  to control/limit what is exported..");
        System.err.println("   -D hbase.mapreduce.scan.column.family=<familyName>");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Export.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        System.exit((job = Export.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class Exporter
    extends TableMapper<ImmutableBytesWritable, Result> {
        Exporter() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                context.write((Object)row, (Object)value);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

