/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiTableOutputFormat
extends OutputFormat<ImmutableBytesWritable, Writable> {
    public static final String WAL_PROPERTY = "hbase.mapreduce.multitableoutputformat.wal";
    public static final boolean WAL_ON = true;
    public static final boolean WAL_OFF = false;

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public RecordWriter<ImmutableBytesWritable, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        return new MultiTableRecordWriter(HBaseConfiguration.create(conf), conf.getBoolean(WAL_PROPERTY, true));
    }

    protected static class MultiTableRecordWriter
    extends RecordWriter<ImmutableBytesWritable, Writable> {
        private static final Log LOG = LogFactory.getLog(MultiTableRecordWriter.class);
        Map<ImmutableBytesWritable, HTable> tables;
        Configuration conf;
        boolean useWriteAheadLogging;

        public MultiTableRecordWriter(Configuration conf, boolean useWriteAheadLogging) {
            LOG.debug((Object)("Created new MultiTableRecordReader with WAL " + (useWriteAheadLogging ? "on" : "off")));
            this.tables = new HashMap<ImmutableBytesWritable, HTable>();
            this.conf = conf;
            this.useWriteAheadLogging = useWriteAheadLogging;
        }

        HTable getTable(ImmutableBytesWritable tableName) throws IOException {
            if (!this.tables.containsKey(tableName)) {
                LOG.debug((Object)("Opening HTable \"" + Bytes.toString(tableName.get()) + "\" for writing"));
                HTable table = new HTable(this.conf, tableName.get());
                table.setAutoFlush(false);
                this.tables.put(tableName, table);
            }
            return this.tables.get(tableName);
        }

        public void close(TaskAttemptContext context) throws IOException {
            for (HTable table : this.tables.values()) {
                table.flushCommits();
            }
        }

        public void write(ImmutableBytesWritable tableName, Writable action) throws IOException {
            HTable table = this.getTable(tableName);
            if (action instanceof Put) {
                Put put = new Put((Put)action);
                put.setWriteToWAL(this.useWriteAheadLogging);
                table.put(put);
            } else if (action instanceof Delete) {
                Delete delete = new Delete((Delete)action);
                table.delete(delete);
            } else {
                throw new IllegalArgumentException("action must be either Delete or Put");
            }
        }
    }
}

