/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.HServerInfo;

public class DeadServer
implements Set<String> {
    private final Set<String> deadServers = new HashSet<String>();
    private final int maxDeadServers;
    private int numProcessing;

    public DeadServer(int maxDeadServers) {
        this.maxDeadServers = maxDeadServers;
        this.numProcessing = 0;
    }

    public boolean isDeadServer(String serverName) {
        return this.isDeadServer(serverName, false);
    }

    public boolean cleanPreviousInstance(String newServerName) {
        String serverAddress = HServerInfo.getServerNameLessStartCode(newServerName);
        for (String serverName : this.deadServers) {
            String deadServerAddress = HServerInfo.getServerNameLessStartCode(serverName);
            if (!deadServerAddress.equals(serverAddress)) continue;
            this.remove(serverName);
            return true;
        }
        return false;
    }

    boolean isDeadServer(String serverName, boolean hostAndPortOnly) {
        return HServerInfo.isServer(this, serverName, hostAndPortOnly);
    }

    public boolean areDeadServersInProgress() {
        return this.numProcessing != 0;
    }

    public synchronized Set<String> clone() {
        HashSet<String> clone = new HashSet<String>(this.deadServers.size());
        clone.addAll(this.deadServers);
        return clone;
    }

    @Override
    public synchronized boolean add(String e) {
        ++this.numProcessing;
        return this.deadServers.add(e);
    }

    public synchronized void finish(String e) {
        --this.numProcessing;
    }

    @Override
    public synchronized int size() {
        return this.deadServers.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.deadServers.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.deadServers.contains(o);
    }

    @Override
    public Iterator<String> iterator() {
        return this.deadServers.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.deadServers.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.deadServers.toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.deadServers.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.deadServers.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends String> c) {
        return this.deadServers.addAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.deadServers.retainAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.deadServers.removeAll(c);
    }

    @Override
    public synchronized void clear() {
        throw new NotImplementedException();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return ((Object)this.deadServers).equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return ((Object)this.deadServers).hashCode();
    }

    public synchronized String toString() {
        return this.deadServers.toString();
    }
}

