/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.LogCleaner;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ModifyTableHandler;
import org.apache.hadoop.hbase.master.handler.TableAddFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableDeleteFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableModifyFamilyHandler;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.DNS;
import org.apache.zookeeper.KeeperException;

public class HMaster
extends Thread
implements HMasterInterface,
HMasterRegionInterface,
MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final Configuration conf;
    private InfoServer infoServer;
    private ZooKeeperWatcher zooKeeper;
    private ActiveMasterManager activeMasterManager;
    private RegionServerTracker regionServerTracker;
    private final HBaseServer rpcServer;
    private final HServerAddress address;
    private final MasterMetrics metrics;
    private MasterFileSystem fileSystemManager;
    private HConnection connection;
    private ServerManager serverManager;
    AssignmentManager assignmentManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean stopped = false;
    private volatile boolean abort = false;
    private volatile boolean isActiveMaster = false;
    private volatile boolean initialized = false;
    ExecutorService executorService;
    private LoadBalancer balancer;
    private Thread balancerChore;
    private volatile boolean balanceSwitch = true;
    private Thread catalogJanitorChore;
    private LogCleaner logCleaner;

    public HMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = conf;
        HServerAddress a = new HServerAddress(HMaster.getMyAddress(this.conf));
        int numHandlers = conf.getInt("hbase.regionserver.handler.count", 10);
        this.rpcServer = HBaseRPC.getServer(this, new Class[]{HMasterInterface.class, HMasterRegionInterface.class}, a.getBindAddress(), a.getPort(), numHandlers, 0, false, conf, 0);
        this.address = new HServerAddress(this.rpcServer.getListenerAddress());
        User.login(conf, "hbase.master.keytab.file", "hbase.master.kerberos.principal", this.address.getHostname());
        this.setName("master-" + this.address);
        Replication.decorateMasterConfiguration(this.conf);
        this.rpcServer.startThreads();
        if (this.conf.get("mapred.task.id") == null) {
            this.conf.set("mapred.task.id", "hb_m_" + this.address.toString() + "_" + System.currentTimeMillis());
        }
        this.zooKeeper = new ZooKeeperWatcher(conf, "master:" + this.address.getPort(), this);
        this.metrics = new MasterMetrics(this.getServerName());
    }

    private static void stallIfBackupMaster(Configuration c, ActiveMasterManager amm) throws InterruptedException {
        if (!c.getBoolean("hbase.master.backup", false)) {
            return;
        }
        LOG.debug((Object)"HMaster started in backup mode.  Stalling until master znode is written.");
        while (!amm.isActiveMaster()) {
            LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
            Thread.sleep(c.getInt("zookeeper.session.timeout", 180000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MonitoredTask startupStatus = TaskMonitor.get().createStatus("Master startup");
        startupStatus.setDescription("Master startup");
        try {
            this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.address, this);
            this.zooKeeper.registerListener(this.activeMasterManager);
            HMaster.stallIfBackupMaster(this.conf, this.activeMasterManager);
            this.activeMasterManager.blockUntilBecomingActiveMaster(startupStatus);
            if (!this.stopped) {
                this.finishInitialization(startupStatus);
                this.loop();
            }
        }
        catch (Throwable t) {
            this.abort("Unhandled exception. Starting shutdown.", t);
        }
        finally {
            startupStatus.cleanup();
            this.stopChores();
            if (!this.abort && this.serverManager != null && this.serverManager.isClusterShutdown()) {
                this.serverManager.letRegionServersShutdown();
            }
            this.stopServiceThreads();
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
            if (this.catalogTracker != null) {
                this.catalogTracker.stop();
            }
            if (this.serverManager != null) {
                this.serverManager.stop();
            }
            if (this.assignmentManager != null) {
                this.assignmentManager.stop();
            }
            HConnectionManager.deleteConnection(this.conf, true);
            this.zooKeeper.close();
        }
        LOG.info((Object)"HMaster main thread exiting");
    }

    private void loop() {
        Sleeper sleeper = new Sleeper(1000, this);
        while (!this.stopped) {
            sleeper.sleep();
        }
    }

    private void finishInitialization(MonitoredTask status) throws IOException, InterruptedException, KeeperException {
        this.isActiveMaster = true;
        status.setStatus("Initializing Master file system");
        this.fileSystemManager = new MasterFileSystem(this, this.metrics);
        this.connection = HConnectionManager.getConnection(this.conf);
        this.executorService = new ExecutorService(this.getServerName());
        this.rsFatals = new MemoryBoundedLogMessageBuffer(this.conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        this.serverManager = new ServerManager(this, this, this.metrics);
        status.setStatus("Initializing ZK system trackers");
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.connection, this, this.conf.getInt("hbase.master.catalog.timeout", Integer.MAX_VALUE));
        this.catalogTracker.start();
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.catalogTracker, this.executorService);
        this.balancer = new LoadBalancer(this.conf);
        this.zooKeeper.registerListenerFirst(this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.clusterStatusTracker = new ClusterStatusTracker(this.getZooKeeper(), this);
        this.clusterStatusTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master; " + this.address + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getZooKeeper().getSessionId()) + ", cluster-up flag was=" + wasUp));
        status.setStatus("Initializing master service threads");
        this.startServiceThreads();
        int regionCount = this.serverManager.waitForRegionServers(status);
        status.setStatus("Splitting logs after master startup");
        this.fileSystemManager.splitLogAfterStartup(this.serverManager.getOnlineServers());
        this.assignRootAndMeta(status);
        if (regionCount == 0) {
            LOG.info((Object)"Master startup proceeding: cluster startup");
            this.assignmentManager.cleanoutUnassigned();
            this.assignmentManager.assignAllUserRegions();
        } else {
            LOG.info((Object)"Master startup proceeding: master failover");
            this.assignmentManager.processFailover();
        }
        status.setStatus("Starting balancer and catalog janitor");
        this.balancerChore = HMaster.getAndStartBalancerChore(this);
        this.catalogJanitorChore = Threads.setDaemonThreadRunning(new CatalogJanitor(this, this));
        status.markComplete("Initialization successful");
        LOG.info((Object)"Master has completed initialization");
        this.initialized = true;
    }

    int assignRootAndMeta(MonitoredTask status) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        status.setStatus("Assigning ROOT region");
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.ROOT_REGIONINFO);
        if (!this.catalogTracker.verifyRootRegionLocation(timeout)) {
            this.assignmentManager.assignRoot();
            this.catalogTracker.waitForRoot();
            ++assigned;
        }
        LOG.info((Object)("-ROOT- assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getRootLocation()));
        status.setStatus("Assigning META region");
        rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.FIRST_META_REGIONINFO);
        if (!this.catalogTracker.verifyMetaRegionLocation(timeout)) {
            this.assignmentManager.assignMeta();
            this.catalogTracker.waitForMeta();
            this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
            ++assigned;
        }
        LOG.info((Object)(".META. assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getMetaLocation()));
        status.setStatus("META and ROOT assigned.");
        return assigned;
    }

    private static String getMyAddress(Configuration c) throws UnknownHostException {
        String s = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)c.get("hbase.master.dns.interface", "default"), (String)c.get("hbase.master.dns.nameserver", "default")));
        s = s + ":" + c.get("hbase.master.port", Integer.toString(60000));
        return s;
    }

    public HServerAddress getMasterAddress() {
        return this.address;
    }

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 27L;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    private void startServiceThreads() throws IOException {
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 3));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        String n = Thread.currentThread().getName();
        this.logCleaner = new LogCleaner(this.conf.getInt("hbase.master.cleaner.interval", 60000), this, this.conf, this.getMasterFileSystem().getFileSystem(), this.getMasterFileSystem().getOldLogDir());
        Threads.setDaemonThreadRunning(this.logCleaner, n + ".oldLogCleaner");
        int port = this.conf.getInt("hbase.master.info.port", 60010);
        if (port >= 0) {
            String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
            this.infoServer = new InfoServer(MASTER, a, port, false);
            this.infoServer.addServlet("status", "/master-status", MasterStatusServlet.class);
            this.infoServer.addServlet("dump", "/dump", MasterDumpServlet.class);
            this.infoServer.setAttribute(MASTER, this);
            this.infoServer.start();
        }
        this.rpcServer.openServer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Started service threads");
        }
    }

    private void stopServiceThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.logCleaner != null) {
            this.logCleaner.interrupt();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private static Thread getAndStartBalancerChore(final HMaster master) {
        String name = master.getServerName() + "-BalancerChore";
        int period = master.getConfiguration().getInt("hbase.balancer.period", 300000);
        Chore chore = new Chore(name, period, master){

            @Override
            protected void chore() {
                master.balance();
            }
        };
        return Threads.setDaemonThreadRunning(chore);
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.interrupt();
        }
    }

    @Override
    public MapWritable regionServerStartup(HServerInfo serverInfo, long serverCurrentTime) throws IOException {
        InetSocketAddress address = new InetSocketAddress(HBaseServer.getRemoteIp().getHostName(), serverInfo.getServerAddress().getPort());
        serverInfo.setServerAddress(new HServerAddress(address));
        this.serverManager.regionServerStartup(serverInfo, serverCurrentTime);
        MapWritable mw = this.createConfigurationSubset();
        mw.put((Writable)new Text("hbase.regionserver.address"), (Writable)serverInfo.getServerAddress());
        return mw;
    }

    protected MapWritable createConfigurationSubset() {
        MapWritable mw = this.addConfig(new MapWritable(), "hbase.rootdir");
        return this.addConfig(mw, "fs.default.name");
    }

    private MapWritable addConfig(MapWritable mw, String key) {
        mw.put((Writable)new Text(key), (Writable)new Text(this.conf.get(key)));
        return mw;
    }

    @Override
    public HMsg[] regionServerReport(HServerInfo serverInfo, HMsg[] msgs, HRegionInfo[] mostLoadedRegions) throws IOException {
        return this.adornRegionServerAnswer(serverInfo, this.serverManager.regionServerReport(serverInfo, msgs, mostLoadedRegions));
    }

    @Override
    public void reportRSFatalError(HServerInfo serverInfo, String errorText) {
        String msg = "Region server " + serverInfo + " reported a fatal error:\n" + errorText;
        LOG.error((Object)msg);
        this.rsFatals.add(msg);
    }

    protected HMsg[] adornRegionServerAnswer(HServerInfo hsi, HMsg[] msgs) throws IOException {
        return msgs;
    }

    @Override
    public boolean isMasterRunning() {
        return !this.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balance() {
        if (!this.balanceSwitch) {
            return false;
        }
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (this.assignmentManager.isRegionsInTransition()) {
                LOG.debug((Object)("Not running balancer because " + this.assignmentManager.getRegionsInTransition().size() + " region(s) in transition: " + StringUtils.abbreviate((String)this.assignmentManager.getRegionsInTransition().toString(), (int)256)));
                return false;
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            Map<HServerInfo, List<HRegionInfo>> assignments = this.assignmentManager.getAssignments();
            for (Map.Entry<String, HServerInfo> e : this.serverManager.getOnlineServers().entrySet()) {
                HServerInfo hsi = e.getValue();
                if (assignments.containsKey(hsi)) continue;
                assignments.put(hsi, new ArrayList());
            }
            List<LoadBalancer.RegionPlan> plans = this.balancer.balanceCluster(assignments);
            if (plans != null && !plans.isEmpty()) {
                for (LoadBalancer.RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    this.assignmentManager.balance(plan);
                }
            }
        }
        return true;
    }

    @Override
    public boolean balanceSwitch(boolean b) {
        boolean oldValue = this.balanceSwitch;
        this.balanceSwitch = b;
        LOG.info((Object)("Balance=" + b));
        return oldValue;
    }

    public void setCatalogJanitorEnabled(boolean b) {
        ((CatalogJanitor)this.catalogJanitorChore).setEnabled(b);
    }

    @Override
    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException {
        Pair<HRegionInfo, HServerInfo> p = this.assignmentManager.getAssignment(encodedRegionName);
        if (p == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
        }
        HRegionInfo hri = p.getFirst();
        HServerInfo dest = null;
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null/empty so choosing a server at random");
            this.assignmentManager.clearRegionPlan(hri);
            this.assignmentManager.unassign(hri);
        } else {
            dest = this.serverManager.getServerInfo(new String(destServerName));
            LoadBalancer.RegionPlan rp = new LoadBalancer.RegionPlan(p.getFirst(), p.getSecond(), dest);
            this.assignmentManager.balance(rp);
        }
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc, splitKeys, false);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys, boolean sync) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        HRegionInfo[] newRegions = null;
        if (splitKeys == null || splitKeys.length == 0) {
            newRegions = new HRegionInfo[]{new HRegionInfo(desc, null, null)};
        } else {
            int numRegions = splitKeys.length + 1;
            newRegions = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                newRegions[i] = new HRegionInfo(desc, startKey, endKey);
                startKey = endKey;
            }
        }
        int timeout = this.conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (this.catalogTracker.waitForMeta(timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            throw new IOException(e);
        }
        this.createTable(newRegions, sync);
    }

    private synchronized void createTable(HRegionInfo[] newRegions, boolean sync) throws IOException {
        String tableName = newRegions[0].getTableDesc().getNameAsString();
        if (MetaReader.tableExists(this.catalogTracker, tableName)) {
            throw new TableExistsException(tableName);
        }
        try {
            this.assignmentManager.getZKTable().setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabled because of a ZooKeeper issue", e);
        }
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        int batchSize = this.conf.getInt("hbase.master.createtable.batchsize", 100);
        HLog hlog = null;
        for (int regionIdx = 0; regionIdx < newRegions.length; ++regionIdx) {
            HRegionInfo newRegion = newRegions[regionIdx];
            HRegion region = HRegion.createHRegion(newRegion, this.fileSystemManager.getRootDir(), this.conf, hlog);
            if (hlog == null) {
                hlog = region.getLog();
            }
            regionInfos.add(region.getRegionInfo());
            if (regionIdx % batchSize == 0) {
                MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
                regionInfos.clear();
            }
            region.close();
        }
        hlog.closeAndDelete();
        if (regionInfos.size() > 0) {
            MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
        }
        if (newRegions.length == 1) {
            this.assignmentManager.assign(newRegions[0], true);
        } else {
            List<HServerInfo> servers = this.serverManager.getOnlineServersList();
            this.assignmentManager.bulkAssignUserRegions(newRegions, servers, sync);
        }
        if (sync) {
            LOG.debug((Object)("Waiting for " + newRegions.length + " region(s) to be assigned"));
            for (HRegionInfo regionInfo : newRegions) {
                try {
                    this.assignmentManager.waitForAssignment(regionInfo);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Interrupted waiting for region to be assigned during create table call", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private static boolean isCatalogTable(byte[] tableName) {
        return Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) || Bytes.equals(tableName, HConstants.META_TABLE_NAME);
    }

    @Override
    public void deleteTable(byte[] tableName) throws IOException {
        this.executorService.submit(new DeleteTableHandler(tableName, this, this));
    }

    @Override
    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        new TableAddFamilyHandler(tableName, column, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        new TableModifyFamilyHandler(tableName, descriptor, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void deleteColumn(byte[] tableName, byte[] c) throws IOException {
        new TableDeleteFamilyHandler(tableName, c, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void enableTable(byte[] tableName) throws IOException {
        this.executorService.submit(new EnableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager));
    }

    @Override
    public void disableTable(byte[] tableName) throws IOException {
        this.executorService.submit(new DisableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager));
    }

    Pair<HRegionInfo, HServerAddress> getTableRegionForRow(final byte[] tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.metaRowToRegionPair(data);
                if (pair == null) {
                    return false;
                }
                if (!Bytes.equals(pair.getFirst().getTableDesc().getName(), tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan(this.conf, visitor, tableName, rowKey, 1);
        return result.get();
    }

    @Override
    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.executorService.submit(new ModifyTableHandler(tableName, htd, (Server)this, (MasterServices)this));
    }

    @Override
    public void checkTableModifiable(byte[] tableName) throws IOException {
        String tableNameStr = Bytes.toString(tableName);
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaReader.tableExists(this.getCatalogTracker(), tableNameStr)) {
            throw new TableNotFoundException(tableNameStr);
        }
        if (!this.getAssignmentManager().getZKTable().isDisabledTable(Bytes.toString(tableName))) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public void clearFromTransition(HRegionInfo hri) {
        if (this.assignmentManager.isRegionInTransition(hri) != null) {
            this.assignmentManager.clearRegionFromTransition(hri);
        }
    }

    @Override
    public ClusterStatus getClusterStatus() {
        ClusterStatus status = new ClusterStatus();
        status.setHBaseVersion(VersionInfo.getVersion());
        status.setServerInfo(this.serverManager.getOnlineServers().values());
        status.setDeadServers(this.serverManager.getDeadServers());
        status.setRegionsInTransition(this.assignmentManager.getRegionsInTransition());
        return status;
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (t != null) {
            LOG.fatal((Object)msg, t);
        } else {
            LOG.fatal((Object)msg);
        }
        this.abort = true;
        this.stop("Aborting");
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public String getServerName() {
        return this.address.toString();
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    @Override
    public void shutdown() {
        this.serverManager.shutdownCluster();
        try {
            this.clusterStatusTracker.setClusterDown();
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
        }
    }

    @Override
    public void stopMaster() {
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String why) {
        LOG.info((Object)why);
        this.stopped = true;
        AtomicBoolean atomicBoolean = this.activeMasterManager.clusterHasActiveMaster;
        synchronized (atomicBoolean) {
            this.activeMasterManager.clusterHasActiveMaster.notifyAll();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void assign(byte[] regionName, boolean force) throws IOException {
        Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toString(regionName));
        }
        this.assignRegion(pair.getFirst());
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    @Override
    public void unassign(byte[] regionName, boolean force) throws IOException {
        Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(regionName));
        }
        HRegionInfo hri = pair.getFirst();
        if (force) {
            this.assignmentManager.clearRegionFromTransition(hri);
        }
        this.assignmentManager.unassign(hri, force);
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (InvocationTargetException ite) {
            Throwable target;
            Throwable throwable = target = ite.getTargetException() != null ? ite.getTargetException() : ite;
            if (target.getCause() != null) {
                target = target.getCause();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString(), target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + (e.getCause() != null ? e.getCause().getMessage() : ""), e);
        }
    }

    public static void main(String[] args) throws Exception {
        new HMasterCommandLine(HMaster.class).doMain(args);
    }
}

