/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.tmpl.master.MasterStatusTmpl;

public class MasterStatusServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(MasterStatusServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        Configuration conf = master.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(conf);
        Map<String, Integer> frags = this.getFragmentationInfo(master, conf);
        HServerAddress rootLocation = this.getRootLocationOrNull(master);
        HServerAddress metaLocation = master.getCatalogTracker().getMetaLocation();
        Map<String, HServerInfo> servers = master.getServerManager().getOnlineServers();
        int interval = conf.getInt("hbase.regionserver.msginterval", 1000) / 1000;
        if (interval == 0) {
            interval = 1;
        }
        response.setContentType("text/html");
        new MasterStatusTmpl().setFrags(frags).setShowAppendWarning(MasterStatusServlet.shouldShowAppendWarning(conf)).setRootLocation(rootLocation).setMetaLocation(metaLocation).setServers(servers).setInterval(interval).render(response.getWriter(), master, admin);
    }

    private HServerAddress getRootLocationOrNull(HMaster master) {
        try {
            return master.getCatalogTracker().getRootLocation();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Unable to get root location", (Throwable)e);
            return null;
        }
    }

    private Map<String, Integer> getFragmentationInfo(HMaster master, Configuration conf) throws IOException {
        boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
        if (showFragmentation) {
            return FSUtils.getTableFragmentation(master);
        }
        return null;
    }

    static boolean shouldShowAppendWarning(Configuration conf) {
        try {
            return !FSUtils.isAppendSupported(conf) && FSUtils.isHDFS(conf);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to determine if append is supported", (Throwable)e);
            return false;
        }
    }
}

