/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;

public class TableAddFamilyHandler
extends TableEventHandler {
    private final HColumnDescriptor familyDesc;

    public TableAddFamilyHandler(byte[] tableName, HColumnDescriptor familyDesc, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_ADD_FAMILY, tableName, server, masterServices);
        this.familyDesc = familyDesc;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        byte[] familyName;
        HTableDescriptor htd = hris.get(0).getTableDesc();
        if (htd.hasFamily(familyName = this.familyDesc.getName())) {
            throw new InvalidFamilyOperationException("Family '" + Bytes.toString(familyName) + "' already exists so " + "cannot be added");
        }
        for (HRegionInfo hri : hris) {
            hri.getTableDesc().addFamily(this.familyDesc);
            MetaEditor.updateRegionInfo(this.server.getCatalogTracker(), hri);
            this.masterServices.getMasterFileSystem().updateRegionInfo(hri);
        }
    }
}

