/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;

class MonitoredTaskImpl
implements MonitoredTask {
    private long startTime;
    private long completionTimestamp = -1L;
    private String status;
    private String description;
    private MonitoredTask.State state = MonitoredTask.State.RUNNING;

    public MonitoredTaskImpl() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public MonitoredTask.State getState() {
        return this.state;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    @Override
    public void markComplete(String status) {
        this.state = MonitoredTask.State.COMPLETE;
        this.setStatus(status);
        this.completionTimestamp = System.currentTimeMillis();
    }

    @Override
    public void abort(String msg) {
        this.setStatus(msg);
        this.state = MonitoredTask.State.ABORTED;
        this.completionTimestamp = System.currentTimeMillis();
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void cleanup() {
        if (this.state == MonitoredTask.State.RUNNING) {
            this.state = MonitoredTask.State.ABORTED;
            this.completionTimestamp = System.currentTimeMillis();
        }
    }

    @VisibleForTesting
    void expireNow() {
        this.completionTimestamp -= 180000L;
    }
}

