/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.ReadWriteConsistencyControl;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class HRegion
implements HeapSize {
    public static final Log LOG = LogFactory.getLog(HRegion.class);
    static final String MERGEDIR = "merges";
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private final ConcurrentHashMap<HashedBytes, CountDownLatch> lockedRows = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, HashedBytes> lockIds = new ConcurrentHashMap();
    private final AtomicInteger lockIdGenerator = new AtomicInteger(1);
    private static Random rand = new Random();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    final AtomicLong memstoreSize = new AtomicLong(0L);
    final Path tableDir;
    final HLog log;
    final FileSystem fs;
    final Configuration conf;
    final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    final HRegionInfo regionInfo;
    final Path regiondir;
    KeyValue.KVComparator comparator;
    private volatile boolean forceMajorCompaction = false;
    private Pair<Long, Long> lastCompactInfo = null;
    private final Object closeLock = new Object();
    final WriteState writestate = new WriteState();
    final long memstoreFlushSize;
    private volatile long lastFlushTime;
    private List<Pair<Long, Long>> recentFlushes = new ArrayList<Pair<Long, Long>>();
    final FlushRequester flushRequester;
    private final long blockingMemStoreSize;
    final long threadWakeFrequency;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] splitPoint = null;
    private final ReadWriteConsistencyControl rwcc = new ReadWriteConsistencyControl();
    public static final String REGIONINFO_FILE = ".regioninfo";
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 32 + 4 + 2 + ClassSize.ARRAY + 23 * ClassSize.REFERENCE);
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)ClassSize.ATOMIC_LONG + (long)ClassSize.ATOMIC_INTEGER + (long)(2 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + (long)ClassSize.ARRAYLIST + ReadWriteConsistencyControl.FIXED_SIZE;
    private static final List<KeyValue> MOCKED_LIST = new AbstractList<KeyValue>(){

        @Override
        public void add(int index, KeyValue element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends KeyValue> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public HRegion() {
        this.tableDir = null;
        this.blockingMemStoreSize = 0L;
        this.conf = null;
        this.rowLockWaitDuration = 30000;
        this.flushRequester = null;
        this.fs = null;
        this.memstoreFlushSize = 0L;
        this.log = null;
        this.regiondir = null;
        this.regionInfo = null;
        this.threadWakeFrequency = 0L;
    }

    public HRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, FlushRequester flushRequester) {
        this.tableDir = tableDir;
        this.comparator = regionInfo.getComparator();
        this.log = log;
        this.fs = fs;
        this.conf = conf;
        this.rowLockWaitDuration = conf.getInt("hbase.rowlock.wait.duration", 30000);
        this.regionInfo = regionInfo;
        this.flushRequester = flushRequester;
        this.threadWakeFrequency = conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        String encodedNameStr = this.regionInfo.getEncodedName();
        this.regiondir = HRegion.getRegionDir(this.tableDir, encodedNameStr);
        long flushSize = regionInfo.getTableDesc().getMemStoreFlushSize();
        if (flushSize == 0x4000000L) {
            flushSize = conf.getLong("hbase.hregion.memstore.flush.size", 0x4000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * conf.getLong("hbase.hregion.memstore.block.multiplier", 2L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiated " + this));
        }
    }

    public long initialize() throws IOException {
        return this.initialize(null);
    }

    public long initialize(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        this.closing.set(false);
        this.closed.set(false);
        status.setStatus("Writing region info on filesystem");
        this.checkRegioninfoOnFilesystem();
        status.setStatus("Cleaning up temporary data from old regions");
        this.cleanupTmpDir();
        long maxSeqId = -1L;
        for (HColumnDescriptor c : this.regionInfo.getTableDesc().getFamilies()) {
            status.setStatus("Instantiating store for column family " + c);
            Store store = this.instantiateHStore(this.tableDir, c);
            this.stores.put(c.getName(), store);
            long storeSeqId = store.getMaxSequenceId();
            if (storeSeqId <= maxSeqId) continue;
            maxSeqId = storeSeqId;
        }
        maxSeqId = this.replayRecoveredEditsIfAny(this.regiondir, maxSeqId, reporter, status);
        status.setStatus("Cleaning up detritus from prior splits");
        SplitTransaction.cleanupAnySplitDetritus(this);
        FSUtils.deleteDirectory(this.fs, new Path(this.regiondir, MERGEDIR));
        this.writestate.setReadOnly(this.regionInfo.getTableDesc().isReadOnly());
        this.writestate.compacting = false;
        this.lastFlushTime = EnvironmentEdgeManager.currentTimeMillis();
        long nextSeqid = maxSeqId + 1L;
        LOG.info((Object)("Onlined " + this.toString() + "; next sequenceid=" + nextSeqid));
        status.markComplete("Region opened successfully");
        return nextSeqid;
    }

    static void moveInitialFilesIntoPlace(FileSystem fs, Path initialFiles, Path regiondir) throws IOException {
        if (initialFiles != null && fs.exists(initialFiles) && !fs.rename(initialFiles, regiondir)) {
            LOG.warn((Object)("Unable to rename " + initialFiles + " to " + regiondir));
        }
    }

    public boolean hasReferences() {
        for (Store store : this.stores.values()) {
            for (StoreFile sf : store.getStorefiles()) {
                if (!sf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRegioninfoOnFilesystem() throws IOException {
        Path regioninfoPath = new Path(this.regiondir, REGIONINFO_FILE);
        if (this.fs.exists(regioninfoPath) && this.fs.getFileStatus(regioninfoPath).getLen() > 0L) {
            return;
        }
        Path tmpPath = new Path(this.getTmpDir(), REGIONINFO_FILE);
        FSDataOutputStream out = this.fs.create(tmpPath, true);
        try {
            this.regionInfo.write((DataOutput)out);
            out.write(10);
            out.write(10);
            out.write(Bytes.toBytes(this.regionInfo.toString()));
        }
        finally {
            out.close();
        }
        if (!this.fs.rename(tmpPath, regioninfoPath)) {
            throw new IOException("Unable to rename " + tmpPath + " to " + regioninfoPath);
        }
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    public ReadWriteConsistencyControl getRWCC() {
        return this.rwcc;
    }

    public List<StoreFile> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreFile> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this + (abort ? " due to abort" : ""));
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                List<StoreFile> list = this.doClose(abort, status);
                return list;
            }
        }
        finally {
            status.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("Region " + this + " already closed"));
            return null;
        }
        status.setStatus("Disabling compacts and flushes for region");
        boolean wasFlushing = false;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            this.writestate.writesEnabled = false;
            wasFlushing = this.writestate.flushing;
            LOG.debug((Object)("Closing " + this + ": disabling compactions & flushes"));
            while (this.writestate.compacting || this.writestate.flushing) {
                LOG.debug((Object)("waiting for" + (this.writestate.compacting ? " compaction" : "") + (this.writestate.flushing ? (this.writestate.compacting ? "," : "") + " cache flush" : "") + " to complete for region " + this));
                try {
                    this.writestate.wait();
                }
                catch (InterruptedException iex) {}
            }
        }
        if (!abort && !wasFlushing && this.worthPreFlushing()) {
            status.setStatus("Pre-flushing region before close");
            LOG.info((Object)("Running close preflush of " + this.getRegionNameAsString()));
            this.internalFlushcache(status);
        }
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        this.lock.writeLock().lock();
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                writeState = null;
                return writeState;
            }
            LOG.debug((Object)("Updates disabled for region " + this));
            if (!abort) {
                this.internalFlushcache(status);
            }
            ArrayList<StoreFile> result = new ArrayList<StoreFile>();
            for (Store store : this.stores.values()) {
                result.addAll((Collection<StoreFile>)store.close());
            }
            this.closed.set(true);
            status.markComplete("Closed");
            LOG.info((Object)("Closed " + this));
            ArrayList<StoreFile> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean worthPreFlushing() {
        return this.memstoreSize.get() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    public byte[] getStartKey() {
        return this.regionInfo.getStartKey();
    }

    public byte[] getEndKey() {
        return this.regionInfo.getEndKey();
    }

    public long getRegionId() {
        return this.regionInfo.getRegionId();
    }

    public byte[] getRegionName() {
        return this.regionInfo.getRegionName();
    }

    public String getRegionNameAsString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public HTableDescriptor getTableDesc() {
        return this.regionInfo.getTableDesc();
    }

    public HLog getLog() {
        return this.log;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Path getRegionDir() {
        return this.regiondir;
    }

    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    public FileSystem getFilesystem() {
        return this.fs;
    }

    public Pair<Long, Long> getLastCompactInfo() {
        return this.lastCompactInfo;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public List<Pair<Long, Long>> getRecentFlushInfo() {
        this.lock.readLock().lock();
        List<Pair<Long, Long>> ret = this.recentFlushes;
        this.recentFlushes = new ArrayList<Pair<Long, Long>>();
        this.lock.readLock().unlock();
        return ret;
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    void doRegionCompactionPrep() throws IOException {
    }

    private void cleanupTmpDir() throws IOException {
        FSUtils.deleteDirectory(this.fs, this.getTmpDir());
    }

    Path getTmpDir() {
        return new Path(this.getRegionDir(), ".tmp");
    }

    void setForceMajorCompaction(boolean b) {
        this.forceMajorCompaction = b;
    }

    boolean getForceMajorCompaction() {
        return this.forceMajorCompaction;
    }

    public byte[] compactStores() throws IOException {
        boolean majorCompaction = this.forceMajorCompaction;
        this.forceMajorCompaction = false;
        return this.compactStores(majorCompaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    byte[] compactStores(boolean majorCompaction) throws IOException {
        if (this.closing.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing"));
            return null;
        }
        this.lock.readLock().lock();
        this.lastCompactInfo = null;
        byte[] splitRow = null;
        MonitoredTask status = TaskMonitor.get().createStatus("Compacting stores in " + this);
        try {
            block31: {
                if (this.closed.get()) {
                    LOG.debug((Object)("Skipping compaction on " + this + " because closed"));
                    byte[] byArray = null;
                    return byArray;
                }
                if (this.closed.get()) {
                    byte[] byArray = splitRow;
                    return byArray;
                }
                try {
                    String string;
                    StringBuilder stringBuilder;
                    block35: {
                        block33: {
                            block34: {
                                block32: {
                                    WriteState writeState = this.writestate;
                                    // MONITORENTER : writeState
                                    if (this.writestate.compacting || !this.writestate.writesEnabled) break block32;
                                    this.writestate.compacting = true;
                                    // MONITOREXIT : writeState
                                    stringBuilder = new StringBuilder().append("Starting");
                                    if (!majorCompaction) break block33;
                                    break block34;
                                }
                                String msg = "NOT compacting region " + this + ": compacting=" + this.writestate.compacting + ", writesEnabled=" + this.writestate.writesEnabled;
                                LOG.info((Object)msg);
                                status.abort(msg);
                                byte[] byArray = splitRow;
                                // MONITOREXIT : writeState
                                return byArray;
                            }
                            string = " major ";
                            break block35;
                        }
                        string = " ";
                    }
                    LOG.info((Object)stringBuilder.append(string).append("compaction on region ").append(this).toString());
                    long startTime = EnvironmentEdgeManager.currentTimeMillis();
                    this.doRegionCompactionPrep();
                    long lastCompactSize = 0L;
                    long maxSize = -1L;
                    boolean completed = false;
                    try {
                        for (Store store : this.stores.values()) {
                            status.setStatus("Compacting store " + store);
                            Store.StoreSize ss = store.compact(majorCompaction);
                            lastCompactSize += store.getLastCompactSize();
                            if (ss == null || ss.getSize() <= maxSize) continue;
                            maxSize = ss.getSize();
                            splitRow = ss.getSplitRow();
                        }
                        completed = true;
                    }
                    catch (InterruptedIOException iioe) {
                        try {
                            LOG.info((Object)"compaction interrupted by user: ", (Throwable)iioe);
                        }
                        catch (Throwable throwable) {
                            long now = EnvironmentEdgeManager.currentTimeMillis();
                            LOG.info((Object)((completed ? "completed" : "aborted") + " compaction on region " + this + " after " + StringUtils.formatTimeDiff((long)now, (long)startTime)));
                            if (!completed) throw throwable;
                            this.lastCompactInfo = new Pair<Long, Long>((now - startTime) / 1000L, lastCompactSize);
                            status.setStatus("Compaction complete: " + StringUtils.humanReadableInt((long)lastCompactSize) + " in " + (now - startTime) + "ms");
                            throw throwable;
                        }
                        long now = EnvironmentEdgeManager.currentTimeMillis();
                        LOG.info((Object)((completed ? "completed" : "aborted") + " compaction on region " + this + " after " + StringUtils.formatTimeDiff((long)now, (long)startTime)));
                        if (completed) {
                            this.lastCompactInfo = new Pair<Long, Long>((now - startTime) / 1000L, lastCompactSize);
                            status.setStatus("Compaction complete: " + StringUtils.humanReadableInt((long)lastCompactSize) + " in " + (now - startTime) + "ms");
                        }
                        break block31;
                    }
                    long now = EnvironmentEdgeManager.currentTimeMillis();
                    LOG.info((Object)((completed ? "completed" : "aborted") + " compaction on region " + this + " after " + StringUtils.formatTimeDiff((long)now, (long)startTime)));
                    if (completed) {
                        this.lastCompactInfo = new Pair<Long, Long>((now - startTime) / 1000L, lastCompactSize);
                        status.setStatus("Compaction complete: " + StringUtils.humanReadableInt((long)lastCompactSize) + " in " + (now - startTime) + "ms");
                    }
                }
                finally {
                    WriteState writeState = this.writestate;
                }
            }
            if (splitRow != null) {
                assert (this.splitPoint == null || Bytes.equals(splitRow, this.splitPoint));
                this.splitPoint = null;
            }
            status.markComplete("Compaction complete");
            Object object = splitRow;
            return object;
        }
        finally {
            status.cleanup();
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean flushcache() throws IOException {
        if (this.closing.get()) {
            HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closing"));
            return false;
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closed"));
                status.abort("Skipped: closed");
                var2_2 = false;
                return var2_2;
            }
            var2_3 = this.writestate;
            synchronized (var2_3) {
                if (!this.writestate.flushing && this.writestate.writesEnabled) {
                    this.writestate.flushing = true;
                    ** break block26
                }
                if (HRegion.LOG.isDebugEnabled()) {
                    HRegion.LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                }
                status.abort("Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled"));
                var3_5 = false;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 11] lbl24 : MonitorExitStatement: MONITOREXIT : var2_3
                var4_7 = this.writestate;
            }
            synchronized (var4_7) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_5;
lbl-1000:
            // 1 sources

            {
                // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 11] lbl39 : MonitorExitStatement: MONITOREXIT : var2_3
                {
                    catch (Throwable var6_10) {
                        throw var6_10;
                    }
                }
                result = this.internalFlushcache(status);
                status.markComplete("Flush successful");
                var3_6 = result;
                var4_8 = this.writestate;
            }
            synchronized (var4_8) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_6;
            {
                catch (Throwable var8_12) {
                    var9_13 = this.writestate;
                    synchronized (var9_13) {
                        this.writestate.flushing = false;
                        this.writestate.flushRequested = false;
                        this.writestate.notifyAll();
                    }
                    throw var8_12;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
            status.cleanup();
        }
    }

    protected boolean internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.log, -1L, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalFlushcache(HLog wal, long myseqid, MonitoredTask status) throws IOException {
        long startTime;
        this.lastFlushTime = startTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.memstoreSize.get() <= 0L) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Started memstore flush for " + this + ", current region memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + (wal != null ? "" : "; wal is null, using passed sequenceid=" + myseqid)));
        }
        long sequenceId = -1L;
        long completeSequenceId = -1L;
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        status.setStatus("Preparing to flush by snapshotting stores");
        long currentMemStoreSize = this.memstoreSize.get();
        ArrayList<StoreFlusher> storeFlushers = new ArrayList<StoreFlusher>(this.stores.size());
        try {
            sequenceId = wal == null ? myseqid : wal.startCacheFlush();
            completeSequenceId = this.getCompleteCacheFlushSequenceId(sequenceId);
            for (Store s : this.stores.values()) {
                storeFlushers.add(s.getStoreFlusher(completeSequenceId));
            }
            for (StoreFlusher flusher : storeFlushers) {
                flusher.prepare();
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        status.setStatus("Flushing stores");
        LOG.debug((Object)"Finished snapshotting, commencing flushing stores");
        boolean compactionRequested = false;
        try {
            for (StoreFlusher flusher : storeFlushers) {
                flusher.flushCache(status);
            }
            for (StoreFlusher flusher : storeFlushers) {
                boolean needsCompaction = flusher.commit();
                if (!needsCompaction) continue;
                compactionRequested = true;
            }
            storeFlushers.clear();
            this.memstoreSize.addAndGet(-currentMemStoreSize);
        }
        catch (Throwable t) {
            if (wal != null) {
                wal.abortCacheFlush();
            }
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary(this.getRegionName()));
            dse.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            throw dse;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.regionInfo.getEncodedNameAsBytes(), this.regionInfo.getTableDesc().getName(), completeSequenceId, this.getRegionInfo().isMetaRegion());
        }
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        String msg = "Finished memstore flush of ~" + StringUtils.humanReadableInt((long)currentMemStoreSize) + " for region " + this + " in " + time + "ms, sequenceid=" + sequenceId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info((Object)msg);
        status.setStatus(msg);
        this.recentFlushes.add(new Pair<Long, Long>(time / 1000L, currentMemStoreSize));
        return compactionRequested;
    }

    protected long getCompleteCacheFlushSequenceId(long currentSequenceId) {
        return currentSequenceId;
    }

    Result getClosestRowBefore(byte[] row) throws IOException {
        return this.getClosestRowBefore(row, HConstants.CATALOG_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        KeyValue key = null;
        this.checkRow(row);
        this.startRegionOperation();
        try {
            Store store = this.getStore(family);
            KeyValue kv = new KeyValue(row, Long.MAX_VALUE);
            key = store.getRowKeyAtOrBefore(kv);
            if (key == null) {
                Result result = null;
                return result;
            }
            Get get2 = new Get(key.getRow());
            get2.addFamily(family);
            Result result = this.get(get2, null);
            return result;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public InternalScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.startRegionOperation();
        try {
            if (scan.hasFamilies()) {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            } else {
                for (byte[] family : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                    scan.addFamily(family);
                }
            }
            InternalScanner internalScanner = this.instantiateInternalScanner(scan, additionalScanners);
            return internalScanner;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    protected InternalScanner instantiateInternalScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return new RegionScanner(scan, additionalScanners);
    }

    private void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyMap().isEmpty()) {
            for (byte[] family : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                delete.deleteFamily(family, delete.getTimeStamp());
            }
        } else {
            for (byte[] family : delete.getFamilyMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Delete delete, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        Integer lid = null;
        this.startRegionOperation();
        try {
            byte[] row = delete.getRow();
            lid = this.getLock(lockid, row, true);
            try {
                this.prepareDelete(delete);
                this.delete(delete.getFamilyMap(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Map<byte[], List<KeyValue>> familyMap, boolean writeToWAL) throws IOException {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> kvs = e.getValue();
                TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                for (KeyValue kv : kvs) {
                    if (kv.isLatestTimestamp() && kv.isDeleteType()) {
                        Integer count;
                        byte[] qual = kv.getQualifier();
                        if (qual == null) {
                            qual = HConstants.EMPTY_BYTE_ARRAY;
                        }
                        if ((count = (Integer)kvCount.get(qual)) == null) {
                            kvCount.put(qual, 1);
                        } else {
                            kvCount.put(qual, count + 1);
                        }
                        count = (Integer)kvCount.get(qual);
                        Get get2 = new Get(kv.getRow());
                        get2.setMaxVersions(count);
                        get2.addColumn(family, qual);
                        List<KeyValue> result = this.get(get2);
                        if (result.size() < count) {
                            kv.updateLatestStamp(byteNow);
                            continue;
                        }
                        if (result.size() > count) {
                            throw new RuntimeException("Unexpected size: " + result.size());
                        }
                        KeyValue getkv = result.get(count - 1);
                        Bytes.putBytes(kv.getBuffer(), kv.getTimestampOffset(), getkv.getBuffer(), getkv.getTimestampOffset(), 8);
                        continue;
                    }
                    kv.updateLatestStamp(byteNow);
                }
            }
            if (writeToWAL) {
                WALEdit walEdit = new WALEdit();
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                this.log.append(this.regionInfo, this.regionInfo.getTableDesc().getName(), walEdit, now);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap);
            flush = this.isFlushSize(this.memstoreSize.addAndGet(addedSize));
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (flush) {
            this.requestFlush();
        }
    }

    public void put(Put put) throws IOException {
        this.put(put, null, put.getWriteToWAL());
    }

    public void put(Put put, boolean writeToWAL) throws IOException {
        this.put(put, null, writeToWAL);
    }

    public void put(Put put, Integer lockid) throws IOException {
        this.put(put, lockid, put.getWriteToWAL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Put put, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        try {
            byte[] row = put.getRow();
            Integer lid = this.getLock(lockid, row, true);
            try {
                this.put(put.getFamilyMap(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public HConstants.OperationStatusCode[] put(Put[] puts) throws IOException {
        Pair[] putsAndLocks = new Pair[puts.length];
        for (int i = 0; i < puts.length; ++i) {
            putsAndLocks[i] = new Pair<Put, Object>(puts[i], null);
        }
        return this.put(putsAndLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HConstants.OperationStatusCode[] put(Pair<Put, Integer>[] putsAndLocks) throws IOException {
        BatchOperationInProgress<Pair<Put, Integer>> batchOp = new BatchOperationInProgress<Pair<Put, Integer>>(putsAndLocks);
        while (!batchOp.isDone()) {
            long newSize;
            this.checkReadOnly();
            this.checkResources();
            this.startRegionOperation();
            try {
                long addedSize = this.doMiniBatchPut(batchOp);
                newSize = this.memstoreSize.addAndGet(addedSize);
            }
            finally {
                this.closeRegionOperation();
            }
            if (!this.isFlushSize(newSize)) continue;
            this.requestFlush();
        }
        return batchOp.retCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMiniBatchPut(BatchOperationInProgress<Pair<Put, Integer>> batchOp) throws IOException {
        long l;
        boolean success;
        int lastIndexExclusive;
        ArrayList acquiredLocks;
        boolean locked;
        byte[] byteNow;
        long now;
        block24: {
            int firstIndex;
            now = EnvironmentEdgeManager.currentTimeMillis();
            byteNow = Bytes.toBytes(now);
            locked = false;
            acquiredLocks = Lists.newArrayListWithCapacity((int)((Pair[])batchOp.operations).length);
            lastIndexExclusive = firstIndex = batchOp.nextIndexToProcess;
            success = false;
            int numReadyToWrite = 0;
            while (lastIndexExclusive < ((Pair[])batchOp.operations).length) {
                Pair nextPair = ((Pair[])batchOp.operations)[lastIndexExclusive];
                Put put = (Put)nextPair.getFirst();
                Integer providedLockId = (Integer)nextPair.getSecond();
                try {
                    this.checkFamilies(put.getFamilyMap().keySet());
                }
                catch (NoSuchColumnFamilyException nscf) {
                    LOG.warn((Object)"No such column family in batch put", (Throwable)nscf);
                    batchOp.retCodes[lastIndexExclusive] = HConstants.OperationStatusCode.BAD_FAMILY;
                    ++lastIndexExclusive;
                    continue;
                }
                boolean shouldBlock = numReadyToWrite == 0;
                Integer acquiredLockId = this.getLock(providedLockId, put.getRow(), shouldBlock);
                if (acquiredLockId == null) {
                    assert (!shouldBlock) : "Should never fail to get lock when blocking";
                    break;
                }
                if (providedLockId == null) {
                    acquiredLocks.add(acquiredLockId);
                }
                ++lastIndexExclusive;
                ++numReadyToWrite;
            }
            if (numReadyToWrite > 0) break block24;
            long nextPair = 0L;
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
            for (Integer toRelease : acquiredLocks) {
                this.releaseRowLock(toRelease);
            }
            if (!success) {
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodes[i] != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodes[i] = HConstants.OperationStatusCode.FAILURE;
                }
            }
            batchOp.nextIndexToProcess = lastIndexExclusive;
            return nextPair;
        }
        try {
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                this.updateKVTimestamps(((Put)((Pair[])batchOp.operations)[i].getFirst()).getFamilyMap().values(), byteNow);
            }
            this.updatesLock.readLock().lock();
            locked = true;
            WALEdit walEdit = new WALEdit();
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                Put p;
                if (batchOp.retCodes[i] != HConstants.OperationStatusCode.NOT_RUN || !(p = (Put)((Pair[])batchOp.operations)[i].getFirst()).getWriteToWAL()) continue;
                this.addFamilyMapToWALEdit(p.getFamilyMap(), walEdit);
            }
            this.log.append(this.regionInfo, this.regionInfo.getTableDesc().getName(), walEdit, now);
            long addedSize = 0L;
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodes[i] != HConstants.OperationStatusCode.NOT_RUN) continue;
                Put p = (Put)((Pair[])batchOp.operations)[i].getFirst();
                addedSize += this.applyFamilyMapToMemstore(p.getFamilyMap());
                batchOp.retCodes[i] = HConstants.OperationStatusCode.SUCCESS;
            }
            success = true;
            l = addedSize;
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
        }
        catch (Throwable throwable) {
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
            for (Integer toRelease : acquiredLocks) {
                this.releaseRowLock(toRelease);
            }
            if (!success) {
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodes[i] != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodes[i] = HConstants.OperationStatusCode.FAILURE;
                }
            }
            batchOp.nextIndexToProcess = lastIndexExclusive;
            throw throwable;
        }
        for (Integer toRelease : acquiredLocks) {
            this.releaseRowLock(toRelease);
        }
        if (!success) {
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodes[i] != HConstants.OperationStatusCode.NOT_RUN) continue;
                batchOp.retCodes[i] = HConstants.OperationStatusCode.FAILURE;
            }
        }
        batchOp.nextIndexToProcess = lastIndexExclusive;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, byte[] expectedValue, Writable w, Integer lockId, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        boolean isPut = w instanceof Put;
        if (!isPut && !(w instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        Row r = (Row)w;
        if (Bytes.compareTo(row, r.getRow()) != 0) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        this.startRegionOperation();
        try {
            Integer lid;
            block18: {
                RowLock lock = isPut ? ((Put)w).getRowLock() : ((Delete)w).getRowLock();
                Get get2 = new Get(row, lock);
                this.checkFamily(family);
                get2.addColumn(family, qualifier);
                lid = this.getLock(lockId, get2.getRow(), true);
                List<Object> result = new ArrayList();
                try {
                    result = this.get(get2);
                    boolean matches = false;
                    if (result.size() == 0 && (expectedValue == null || expectedValue.length == 0)) {
                        matches = true;
                    } else if (result.size() == 1) {
                        byte[] actualValue = ((KeyValue)result.get(0)).getValue();
                        matches = Bytes.equals(expectedValue, actualValue);
                    }
                    if (!matches) break block18;
                    if (isPut) {
                        this.put(((Put)w).getFamilyMap(), writeToWAL);
                    } else {
                        Delete d = (Delete)w;
                        this.prepareDelete(d);
                        this.delete(d.getFamilyMap(), writeToWAL);
                    }
                    boolean bl = true;
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    throw throwable;
                }
            }
            boolean bl = false;
            if (lockId == null) {
                this.releaseRowLock(lid);
            }
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void updateKVTimestamps(Iterable<List<KeyValue>> keyLists, byte[] now) {
        for (List<KeyValue> keys : keyLists) {
            if (keys == null) continue;
            for (KeyValue key : keys) {
                key.updateLatestStamp(now);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResources() {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        boolean blocked = false;
        while (this.memstoreSize.get() > this.blockingMemStoreSize) {
            this.requestFlush();
            if (!blocked) {
                LOG.info((Object)("Blocking updates for '" + Thread.currentThread().getName() + "' on region " + Bytes.toStringBinary(this.getRegionName()) + ": memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + " is >= than blocking " + StringUtils.humanReadableInt((long)this.blockingMemStoreSize) + " size"));
            }
            blocked = true;
            HRegion hRegion = this;
            synchronized (hRegion) {
                try {
                    this.wait(this.threadWakeFrequency);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (blocked) {
            LOG.info((Object)("Unblocking updates for region " + this + " '" + Thread.currentThread().getName() + "'"));
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.writestate.isReadOnly()) {
            throw new IOException("region is read only");
        }
    }

    private void put(byte[] family, List<KeyValue> edits) throws IOException {
        HashMap<byte[], List<KeyValue>> familyMap = new HashMap<byte[], List<KeyValue>>();
        familyMap.put(family, edits);
        this.put(familyMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Map<byte[], List<KeyValue>> familyMap, boolean writeToWAL) throws IOException {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            this.checkFamilies(familyMap.keySet());
            this.updateKVTimestamps(familyMap.values(), byteNow);
            if (writeToWAL) {
                WALEdit walEdit = new WALEdit();
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                this.log.append(this.regionInfo, this.regionInfo.getTableDesc().getName(), walEdit, now);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap);
            flush = this.isFlushSize(this.memstoreSize.addAndGet(addedSize));
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (flush) {
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFamilyMapToMemstore(Map<byte[], List<KeyValue>> familyMap) {
        ReadWriteConsistencyControl.WriteEntry w = null;
        long size = 0L;
        try {
            w = this.rwcc.beginMemstoreInsert();
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> edits = e.getValue();
                Store store = this.getStore(family);
                for (KeyValue kv : edits) {
                    kv.setMemstoreTS(w.getWriteNumber());
                    size += store.add(kv);
                }
            }
        }
        finally {
            this.rwcc.completeMemstoreInsert(w);
        }
        return size;
    }

    private void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<KeyValue>> familyMap, WALEdit walEdit) {
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                walEdit.add(kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.flushRequester == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.flushRequester.requestFlush(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected long replayRecoveredEditsIfAny(Path regiondir, long minSeqId, CancelableProgressable reporter, MonitoredTask status) throws UnsupportedEncodingException, IOException {
        long seqid = minSeqId;
        NavigableSet<Path> files = HLog.getSplitEditFilesSorted(this.fs, regiondir);
        if (files == null || files.isEmpty()) {
            return seqid;
        }
        for (Path edits : files) {
            if (edits == null || !this.fs.exists(edits)) {
                LOG.warn((Object)("Null or non-existent edits file: " + edits));
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(this.fs, edits)) continue;
            try {
                seqid = this.replayRecoveredEdits(edits, seqid, reporter);
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.skip.errors", false);
                if (skipErrors) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    LOG.error((Object)("hbase.skip.errors=true so continuing. Renamed " + edits + " as " + p), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (seqid > minSeqId) {
            this.internalFlushcache(null, seqid, status);
        }
        for (Path file : files) {
            if (!this.fs.delete(file, false)) {
                LOG.error((Object)("Failed delete of " + file));
                continue;
            }
            LOG.debug((Object)("Deleted recovered.edits file=" + file));
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, long minSeqId, CancelableProgressable reporter) throws IOException {
        String msg = "Replaying edits from " + edits + "; minSequenceid=" + minSeqId;
        LOG.info((Object)msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        status.setStatus("Opening logs");
        HLog.Reader reader = HLog.getReader(this.fs, edits, this.conf);
        try {
            long currentEditSeqId = minSeqId;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            Store store = null;
            try {
                HLog.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", this.conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 180000) / 2);
                long lastReport = EnvironmentEdgeManager.currentTimeMillis();
                while ((entry = reader.next()) != null) {
                    HLogKey key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTimeMillis();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay";
                                LOG.warn((Object)msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            lastReport = cur;
                        }
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getLogSeqNum();
                    }
                    if (key.getLogSeqNum() <= currentEditSeqId) {
                        ++skippedEdits;
                        continue;
                    }
                    currentEditSeqId = key.getLogSeqNum();
                    boolean flush = false;
                    for (KeyValue kv : val.getKeyValues()) {
                        if (kv.matchingFamily(HLog.METAFAMILY) || !Bytes.equals(key.getEncodedRegionName(), this.regionInfo.getEncodedNameAsBytes())) {
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !kv.matchingFamily(store.getFamily().getName())) {
                            store = this.stores.get(kv.getFamily());
                        }
                        if (store == null) {
                            LOG.warn((Object)("No family for " + kv));
                            ++skippedEdits;
                            continue;
                        }
                        flush = this.restoreEdit(store, kv);
                        ++editsCount;
                    }
                    if (!flush) continue;
                    this.internalFlushcache(null, currentEditSeqId, status);
                }
            }
            catch (EOFException eof) {
                Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                msg = "Encountered EOF. Most likely due to Master failure during log spliting, so we have this data in another edit.  Continuing, but renaming " + edits + " as " + p;
                LOG.warn((Object)msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    msg = "File corruption encountered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn((Object)msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceidInLog=" + firstSeqIdInLog + ", maxSequenceidInLog=" + currentEditSeqId;
            status.markComplete(msg);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg);
            }
            long l = currentEditSeqId;
            return l;
        }
        finally {
            reader.close();
            status.cleanup();
        }
    }

    protected boolean restoreEdit(Store s, KeyValue kv) {
        return this.isFlushSize(this.memstoreSize.addAndGet(s.add(kv)));
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn((Object)("File " + p + " is zero-length, deleting."));
        fs.delete(p, false);
        return true;
    }

    protected Store instantiateHStore(Path tableDir, HColumnDescriptor c) throws IOException {
        return new Store(tableDir, this, c, this.fs, this.conf);
    }

    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    private void checkRow(byte[] row) throws IOException {
        if (!HRegion.rowIsInRange(this.regionInfo, row)) {
            throw new WrongRegionException("Requested row out of range for HRegion " + this + ", startKey='" + Bytes.toStringBinary(this.regionInfo.getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary(this.regionInfo.getEndKey()) + "', row='" + Bytes.toStringBinary(row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer obtainRowLock(byte[] row) throws IOException {
        this.startRegionOperation();
        try {
            Integer n = this.internalObtainRowLock(row, true);
            return n;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer tryObtainRowLock(byte[] row) throws IOException {
        this.startRegionOperation();
        try {
            Integer n = this.internalObtainRowLock(row, false);
            return n;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer internalObtainRowLock(byte[] row, boolean waitForLock) throws IOException {
        this.checkRow(row);
        this.startRegionOperation();
        try {
            rowKey = new HashedBytes(row);
            rowLatch = new CountDownLatch(1);
            while ((existingLatch = this.lockedRows.putIfAbsent(rowKey, rowLatch)) != null) {
                if (!waitForLock) {
                    var6_7 = null;
                    this.closeRegionOperation();
                    return var6_7;
                }
                if (existingLatch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) continue;
                var6_8 = null;
                this.closeRegionOperation();
                return var6_8;
            }
            while (true) {
                if ((existingRowKey = this.lockIds.putIfAbsent(lockId = Integer.valueOf(this.lockIdGenerator.incrementAndGet()), rowKey)) != null) ** break block9
                var7_10 = lockId;
                this.closeRegionOperation();
                return var7_10;
            }
        }
        catch (Throwable var8_11) {
            this.closeRegionOperation();
            throw var8_11;
        }
        {
            this.lockIdGenerator.set(HRegion.rand.nextInt());
            continue;
        }
    }

    byte[] getRowFromLock(Integer lockid) {
        HashedBytes rowKey = this.lockIds.get(lockid);
        return rowKey == null ? null : rowKey.getBytes();
    }

    void releaseRowLock(Integer lockId) {
        HashedBytes rowKey = this.lockIds.remove(lockId);
        if (rowKey == null) {
            LOG.warn((Object)("Release unknown lockId: " + lockId));
            return;
        }
        CountDownLatch rowLatch = this.lockedRows.remove(rowKey);
        if (rowLatch == null) {
            LOG.error((Object)("Releases row not locked, lockId: " + lockId + " row: " + rowKey));
            return;
        }
        rowLatch.countDown();
    }

    boolean isRowLocked(Integer lockId) {
        return this.lockIds.containsKey(lockId);
    }

    private Integer getLock(Integer lockid, byte[] row, boolean waitForLock) throws IOException {
        Integer lid = null;
        if (lockid == null) {
            lid = this.internalObtainRowLock(row, waitForLock);
        } else {
            if (!this.isRowLocked(lockid)) {
                throw new IOException("Invalid row lock");
            }
            lid = lockid;
        }
        return lid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkLoadHFile(String hfilePath, byte[] familyName) throws IOException {
        this.startRegionOperation();
        try {
            Store store = this.getStore(familyName);
            if (store == null) {
                throw new DoNotRetryIOException("No such column family " + Bytes.toStringBinary(familyName));
            }
            store.bulkLoadHFile(hfilePath);
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HRegion)) {
            return false;
        }
        return this.hashCode() == ((HRegion)o).hashCode();
    }

    public int hashCode() {
        return Bytes.hashCode(this.regionInfo.getRegionName());
    }

    public String toString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public Path getTableDir() {
        return this.tableDir;
    }

    public static HRegion newHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, FlushRequester flushListener) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, HLog.class, FileSystem.class, Configuration.class, HRegionInfo.class, FlushRequester.class);
            return (HRegion)c.newInstance(new Object[]{tableDir, log, fs, conf, regionInfo, flushListener});
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, null);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HLog hlog) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, info.getTableDesc().getName());
        Path regionDir = HRegion.getRegionDir(tableDir, info.getEncodedName());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(regionDir);
        HLog effectiveHLog = hlog;
        if (hlog == null) {
            effectiveHLog = new HLog(fs, new Path(regionDir, ".logs"), new Path(regionDir, ".oldlogs"), conf);
        }
        HRegion region = HRegion.newHRegion(tableDir, effectiveHLog, fs, conf, info, null);
        region.initialize();
        return region;
    }

    public static HRegion openHRegion(HRegionInfo info, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, wal, conf, null, null);
    }

    public static HRegion openHRegion(HRegionInfo info, HLog wal, Configuration conf, FlushRequester flusher, CancelableProgressable reporter) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        Path dir = HTableDescriptor.getTableDir(FSUtils.getRootDir(conf), info.getTableDesc().getName());
        HRegion r = HRegion.newHRegion(dir, wal, FileSystem.get((Configuration)conf), conf, info, flusher);
        return r.openHRegion(reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        this.checkCompressionCodecs();
        long seqid = this.initialize(reporter);
        if (this.log != null) {
            this.log.setSequenceNumber(seqid);
        }
        return this;
    }

    private void checkCompressionCodecs() throws IOException {
        for (HColumnDescriptor fam : this.regionInfo.getTableDesc().getColumnFamilies()) {
            CompressionTest.testCompression(fam.getCompression());
            CompressionTest.testCompression(fam.getCompactionCompression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionName();
        Integer lid = meta.obtainRowLock(row);
        try {
            ArrayList<KeyValue> edits = new ArrayList<KeyValue>(1);
            edits.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, EnvironmentEdgeManager.currentTimeMillis(), Writables.getBytes((Writable)r.getRegionInfo())));
            meta.put(HConstants.CATALOG_FAMILY, edits);
        }
        finally {
            meta.releaseRowLock(lid);
        }
    }

    public static void deleteRegion(FileSystem fs, Path rootdir, HRegionInfo info) throws IOException {
        HRegion.deleteRegion(fs, HRegion.getRegionDir(rootdir, info));
    }

    private static void deleteRegion(FileSystem fs, Path regiondir) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETING region " + regiondir.toString()));
        }
        if (!fs.delete(regiondir, true)) {
            LOG.warn((Object)("Failed delete of " + regiondir));
        }
    }

    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(HTableDescriptor.getTableDir(rootdir, info.getTableDesc().getName()), info.getEncodedName());
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), row) <= 0);
    }

    public static void makeColumnFamilyDirs(FileSystem fs, Path tabledir, HRegionInfo hri, byte[] colFamily) throws IOException {
        Path dir = Store.getStoreHomedir(tabledir, hri.getEncodedName(), colFamily);
        if (!fs.mkdirs(dir)) {
            LOG.warn((Object)("Failed to create " + dir));
        }
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getStartKey() == null) {
            if (srcB.getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getStartKey() == null || Bytes.compareTo(srcA.getStartKey(), srcB.getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo(a.getEndKey(), b.getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        byte[] startKey;
        if (!a.getRegionInfo().getTableDesc().getNameAsString().equals(b.getRegionInfo().getTableDesc().getNameAsString())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getFilesystem();
        a.flushcache();
        b.flushcache();
        a.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            HRegion.listPaths(fs, a.getRegionDir());
        }
        b.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            HRegion.listPaths(fs, b.getRegionDir());
        }
        Configuration conf = a.getConf();
        HTableDescriptor tabledesc = a.getTableDesc();
        HLog log = a.getLog();
        Path tableDir = a.getTableDir();
        byte[] byArray = a.comparator.matchingRows(a.getStartKey(), 0, a.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || b.comparator.matchingRows(b.getStartKey(), 0, b.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (startKey = a.comparator.compareRows(a.getStartKey(), 0, a.getStartKey().length, b.getStartKey(), 0, b.getStartKey().length) <= 0 ? a.getStartKey() : b.getStartKey());
        byte[] endKey = a.comparator.matchingRows(a.getEndKey(), 0, a.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || a.comparator.matchingRows(b.getEndKey(), 0, b.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (a.comparator.compareRows(a.getEndKey(), 0, a.getEndKey().length, b.getEndKey(), 0, b.getEndKey().length) <= 0 ? b.getEndKey() : a.getEndKey());
        HRegionInfo newRegionInfo = new HRegionInfo(tabledesc, startKey, endKey);
        LOG.info((Object)("Creating new region " + newRegionInfo.toString()));
        String encodedName = newRegionInfo.getEncodedName();
        Path newRegionDir = HRegion.getRegionDir(a.getTableDir(), encodedName);
        if (fs.exists(newRegionDir)) {
            throw new IOException("Cannot merge; target file collision at " + newRegionDir);
        }
        fs.mkdirs(newRegionDir);
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + newRegionInfo.toString() + " with start key <" + Bytes.toStringBinary(startKey) + "> and end key <" + Bytes.toStringBinary(endKey) + ">"));
        Map<byte[], List<StoreFile>> byFamily = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
        byFamily = HRegion.filesByFamily(byFamily, a.close());
        byFamily = HRegion.filesByFamily(byFamily, b.close());
        for (Map.Entry<byte[], List<StoreFile>> es : byFamily.entrySet()) {
            long seqB;
            long seqA;
            byte[] colFamily = es.getKey();
            HRegion.makeColumnFamilyDirs(fs, tableDir, newRegionInfo, colFamily);
            List<StoreFile> srcFiles = es.getValue();
            if (srcFiles.size() == 2 && (seqA = srcFiles.get(0).getMaxSequenceId()) == (seqB = srcFiles.get(1).getMaxSequenceId())) {
                throw new IOException("Files have same sequenceid: " + seqA);
            }
            for (StoreFile hsf : srcFiles) {
                StoreFile.rename(fs, hsf.getPath(), StoreFile.getUniqueFile(fs, Store.getStoreHomedir(tableDir, newRegionInfo.getEncodedName(), colFamily)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, newRegionDir);
        }
        HRegion dstRegion = HRegion.newHRegion(tableDir, log, fs, conf, newRegionInfo, null);
        dstRegion.initialize();
        dstRegion.compactStores();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, dstRegion.getRegionDir());
        }
        HRegion.deleteRegion(fs, a.getRegionDir());
        HRegion.deleteRegion(fs, b.getRegionDir());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    private static Map<byte[], List<StoreFile>> filesByFamily(Map<byte[], List<StoreFile>> byFamily, List<StoreFile> storeFiles) {
        for (StoreFile src : storeFiles) {
            byte[] family = src.getFamily();
            List<StoreFile> v = byFamily.get(family);
            if (v == null) {
                v = new ArrayList<StoreFile>();
                byFamily.put(family, v);
            }
            v.add(src);
        }
        return byFamily;
    }

    boolean isMajorCompaction() throws IOException {
        for (Store store : this.stores.values()) {
            if (!store.isMajorCompaction()) continue;
            return true;
        }
        return false;
    }

    private static void listPaths(FileSystem fs, Path dir) throws IOException {
        if (LOG.isDebugEnabled()) {
            FileStatus[] stats = fs.listStatus(dir);
            if (stats == null || stats.length == 0) {
                return;
            }
            for (int i = 0; i < stats.length; ++i) {
                String path = stats[i].getPath().toString();
                if (stats[i].isDir()) {
                    LOG.debug((Object)("d " + path));
                    HRegion.listPaths(fs, stats[i].getPath());
                    continue;
                }
                LOG.debug((Object)("f " + path + " size=" + stats[i].getLen()));
            }
        }
    }

    public Result get(Get get2, Integer lockid) throws IOException {
        if (get2.hasFamilies()) {
            for (byte[] family : get2.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                get2.addFamily(family);
            }
        }
        List<KeyValue> result = this.get(get2);
        return new Result(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> getLastIncrement(Get get2) throws IOException {
        InternalScan iscan = new InternalScan(get2);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        iscan.checkOnlyMemStore();
        InternalScanner scanner = null;
        try {
            scanner = this.getScanner(iscan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        int expected = 0;
        Map<byte[], NavigableSet<byte[]>> familyMap = get2.getFamilyMap();
        for (NavigableSet<byte[]> qfs : familyMap.values()) {
            expected += qfs.size();
        }
        if (results.size() == expected) {
            return results;
        }
        if (results != null && !results.isEmpty()) {
            for (KeyValue kv : results) {
                byte[] family = kv.getFamily();
                NavigableSet<byte[]> qfs = familyMap.get(family);
                qfs.remove(kv.getQualifier());
                if (qfs.isEmpty()) {
                    familyMap.remove(family);
                }
                --expected;
            }
            Get newGet = new Get(get2.getRow());
            for (Map.Entry<byte[], NavigableSet<byte[]>> f : familyMap.entrySet()) {
                byte[] family = f.getKey();
                for (byte[] qualifier : f.getValue()) {
                    newGet.addColumn(family, qualifier);
                }
            }
            newGet.setTimeRange(get2.getTimeRange().getMin(), get2.getTimeRange().getMax());
            iscan = new InternalScan(newGet);
        }
        ArrayList<KeyValue> fileResults = new ArrayList<KeyValue>();
        iscan.checkOnlyStoreFiles();
        scanner = null;
        try {
            scanner = this.getScanner(iscan);
            scanner.next(fileResults);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        results.addAll(fileResults);
        Collections.sort(results, KeyValue.COMPARATOR);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> get(Get get2) throws IOException {
        Scan scan = new Scan(get2);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        InternalScanner scanner = null;
        try {
            scanner = this.getScanner(scan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result increment(Increment increment, Integer lockid, boolean writeToWAL) throws IOException {
        byte[] row = increment.getRow();
        this.checkRow(row);
        TimeRange tr = increment.getTimeRange();
        boolean flush = false;
        WALEdit walEdits = null;
        ArrayList<KeyValue> allKVs = new ArrayList<KeyValue>(increment.numColumns());
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(increment.numColumns());
        long now = EnvironmentEdgeManager.currentTimeMillis();
        long size = 0L;
        this.startRegionOperation();
        try {
            Integer lid = this.getLock(lockid, row, true);
            this.updatesLock.readLock().lock();
            try {
                for (Map.Entry<byte[], NavigableMap<byte[], Long>> family : increment.getFamilyMap().entrySet()) {
                    Store store = this.stores.get(family.getKey());
                    Get get2 = new Get(row);
                    for (Map.Entry column : family.getValue().entrySet()) {
                        get2.addColumn(family.getKey(), (byte[])column.getKey());
                    }
                    get2.setTimeRange(tr.getMin(), tr.getMax());
                    List<KeyValue> results = this.getLastIncrement(get2);
                    int idx = 0;
                    for (Map.Entry column : family.getValue().entrySet()) {
                        long amount = (Long)column.getValue();
                        if (idx < results.size() && results.get(idx).matchingQualifier((byte[])column.getKey())) {
                            amount += Bytes.toLong(results.get(idx).getValue());
                            ++idx;
                        }
                        KeyValue newKV = new KeyValue(row, family.getKey(), (byte[])column.getKey(), now, Bytes.toBytes(amount));
                        kvs.add(newKV);
                        if (!writeToWAL) continue;
                        if (walEdits == null) {
                            walEdits = new WALEdit();
                        }
                        walEdits.add(newKV);
                    }
                    size += store.upsert(kvs);
                    allKVs.addAll(kvs);
                    kvs.clear();
                }
                if (writeToWAL) {
                    this.log.append(this.regionInfo, this.regionInfo.getTableDesc().getName(), walEdits, now);
                }
                size = this.memstoreSize.addAndGet(size);
                flush = this.isFlushSize(size);
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
        }
        finally {
            this.closeRegionOperation();
        }
        if (flush) {
            this.requestFlush();
        }
        return new Result(allKVs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkRow(row);
        boolean flush = false;
        long result = amount;
        this.startRegionOperation();
        try {
            Integer lid = this.obtainRowLock(row);
            this.updatesLock.readLock().lock();
            try {
                Store store = this.stores.get(family);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                List<KeyValue> results = this.getLastIncrement(get2);
                if (!results.isEmpty()) {
                    KeyValue kv = results.get(0);
                    byte[] buffer = kv.getBuffer();
                    int valueOffset = kv.getValueOffset();
                    result += Bytes.toLong(buffer, valueOffset, 8);
                }
                KeyValue newKv = new KeyValue(row, family, qualifier, EnvironmentEdgeManager.currentTimeMillis(), Bytes.toBytes(result));
                if (writeToWAL) {
                    long now = EnvironmentEdgeManager.currentTimeMillis();
                    WALEdit walEdit = new WALEdit();
                    walEdit.add(newKv);
                    this.log.append(this.regionInfo, this.regionInfo.getTableDesc().getName(), walEdit, now);
                }
                long size = store.updateColumnValue(row, family, qualifier, result);
                size = this.memstoreSize.addAndGet(size);
                flush = this.isFlushSize(size);
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
        }
        finally {
            this.closeRegionOperation();
        }
        if (flush) {
            this.requestFlush();
        }
        return result;
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.regionInfo.getTableDesc().hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toStringBinary(family) + " does not exist in region " + this + " in table " + this.regionInfo.getTableDesc());
        }
    }

    @Override
    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATLALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, HLog log, Configuration c, boolean majorCompact2) throws IOException {
        block12: {
            HRegion region = null;
            String rootStr = Bytes.toString(HConstants.ROOT_TABLE_NAME);
            String metaStr = Bytes.toString(HConstants.META_TABLE_NAME);
            if (p.getName().startsWith(rootStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.ROOT_REGIONINFO, null);
            } else if (p.getName().startsWith(metaStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.FIRST_META_REGIONINFO, null);
            } else {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            try {
                region.initialize();
                if (majorCompact2) {
                    region.compactStores(true);
                    break block12;
                }
                Scan scan = new Scan();
                InternalScanner scanner = region.getScanner(scan);
                try {
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    boolean done = false;
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
                finally {
                    scanner.close();
                }
            }
            finally {
                region.close();
            }
        }
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getSplitPoint() {
        return this.splitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.splitPoint = sp;
        }
    }

    protected void prepareToSplit() {
    }

    public int getCompactPriority() {
        int count = Integer.MAX_VALUE;
        for (Store store : this.stores.values()) {
            count = Math.min(count, store.getCompactPriority());
        }
        return count;
    }

    public boolean hasTooManyStoreFiles() {
        for (Store store : this.stores.values()) {
            if (!store.hasTooManyStoreFiles()) continue;
            return true;
        }
        return false;
    }

    private void startRegionOperation() throws NotServingRegionException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closing");
        }
        this.lock.readLock().lock();
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closed");
        }
    }

    private void closeRegionOperation() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact2 = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact2 = true;
        }
        Path tableDir = new Path(args[0]);
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"), "hlog" + tableDir.getName() + EnvironmentEdgeManager.currentTimeMillis());
        Path oldLogDir = new Path(c.get("hbase.tmp.dir"), ".oldlogs");
        HLog log = new HLog(fs, logdir, oldLogDir, c);
        try {
            HRegion.processTable(fs, tableDir, log, c, majorCompact2);
        }
        finally {
            log.close();
            BlockCache bc = StoreFile.getBlockCache(c);
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    class RegionScanner
    implements InternalScanner {
        KeyValueHeap storeHeap = null;
        private final byte[] stopRow;
        private Filter filter;
        private List<KeyValue> results = new ArrayList<KeyValue>();
        private int batch;
        private int isScan;
        private boolean filterClosed = false;
        private long readPt;

        public HRegionInfo getRegionName() {
            return HRegion.this.regionInfo;
        }

        RegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
            this.filter = scan.getFilter();
            this.batch = scan.getBatch();
            this.stopRow = (byte[])(Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW) ? null : scan.getStopRow());
            this.isScan = scan.isGetScan() ? -1 : 0;
            this.readPt = ReadWriteConsistencyControl.resetThreadReadPoint(HRegion.this.rwcc);
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null) {
                scanners.addAll(additionalScanners);
            }
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
                Store store = HRegion.this.stores.get(entry.getKey());
                scanners.add(store.getScanner(scan, entry.getValue()));
            }
            this.storeHeap = new KeyValueHeap(scanners, HRegion.this.comparator);
        }

        RegionScanner(Scan scan) throws IOException {
            this(scan, null);
        }

        protected void resetFilters() {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<KeyValue> outResults, int limit) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation();
            try {
                ReadWriteConsistencyControl.setThreadReadPoint(this.readPt);
                this.results.clear();
                boolean returnResult = this.nextInternal(limit);
                outResults.addAll(this.results);
                this.resetFilters();
                if (this.isFilterDone()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = returnResult;
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
        }

        @Override
        public synchronized boolean next(List<KeyValue> outResults) throws IOException {
            return this.next(outResults, this.batch);
        }

        synchronized boolean isFilterDone() {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(int limit) throws IOException {
            boolean stopRow;
            while (true) {
                byte[] nextRow;
                byte[] currentRow;
                if (this.isStopRow(currentRow = this.peekRow())) {
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        this.filter.filterRow(this.results);
                    }
                    if (this.filter != null && this.filter.filterRow()) {
                        this.results.clear();
                    }
                    return false;
                }
                if (this.filterRowKey(currentRow)) {
                    this.nextRow(currentRow);
                    continue;
                }
                do {
                    this.storeHeap.next(this.results, limit - this.results.size());
                    if (limit <= 0 || this.results.size() != limit) continue;
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        throw new IncompatibleFilterException("Filter with filterRow(List<KeyValue>) incompatible with scan with limit!");
                    }
                    return true;
                } while (Bytes.equals(currentRow, nextRow = this.peekRow()));
                stopRow = this.isStopRow(nextRow);
                if (this.filter != null && this.filter.hasFilterRow()) {
                    this.filter.filterRow(this.results);
                }
                if (!this.results.isEmpty() && !this.filterRow()) break;
                this.nextRow(currentRow);
                if (stopRow) break;
            }
            return !stopRow;
        }

        private boolean filterRow() {
            return this.filter != null && this.filter.filterRow();
        }

        private boolean filterRowKey(byte[] row) {
            return this.filter != null && this.filter.filterRowKey(row, 0, row.length);
        }

        protected void nextRow(byte[] currentRow) throws IOException {
            while (Bytes.equals(currentRow, this.peekRow())) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.results.clear();
            this.resetFilters();
        }

        private byte[] peekRow() {
            KeyValue kv = this.storeHeap.peek();
            return kv == null ? null : kv.getRow();
        }

        private boolean isStopRow(byte[] currentRow) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, 0, currentRow.length) <= this.isScan;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            this.filterClosed = true;
        }
    }

    private static class BatchOperationInProgress<T> {
        T[] operations;
        HConstants.OperationStatusCode[] retCodes;
        int nextIndexToProcess = 0;

        public BatchOperationInProgress(T[] operations) {
            this.operations = operations;
            this.retCodes = new HConstants.OperationStatusCode[operations.length];
            Arrays.fill((Object[])this.retCodes, (Object)HConstants.OperationStatusCode.NOT_RUN);
        }

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile boolean compacting = false;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        static final long HEAP_SIZE = ClassSize.align(ClassSize.OBJECT + 5);

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }
    }
}

