/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanDeleteTracker
implements DeleteTracker {
    private long familyStamp = -1L;
    private byte[] deleteBuffer = null;
    private int deleteOffset = 0;
    private int deleteLength = 0;
    private byte deleteType = 0;
    private long deleteTimestamp = 0L;

    @Override
    public void add(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp, byte type) {
        if (timestamp > this.familyStamp) {
            if (type == KeyValue.Type.DeleteFamily.getCode()) {
                this.familyStamp = timestamp;
                return;
            }
            if (this.deleteBuffer != null && type < this.deleteType && Bytes.compareTo(this.deleteBuffer, this.deleteOffset, this.deleteLength, buffer, qualifierOffset, qualifierLength) == 0) {
                return;
            }
            this.deleteBuffer = buffer;
            this.deleteOffset = qualifierOffset;
            this.deleteLength = qualifierLength;
            this.deleteType = type;
            this.deleteTimestamp = timestamp;
        }
    }

    @Override
    public boolean isDeleted(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp) {
        if (timestamp <= this.familyStamp) {
            return true;
        }
        if (this.deleteBuffer != null) {
            int ret = Bytes.compareTo(this.deleteBuffer, this.deleteOffset, this.deleteLength, buffer, qualifierOffset, qualifierLength);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    return true;
                }
                if (timestamp == this.deleteTimestamp) {
                    return true;
                }
                assert (timestamp < this.deleteTimestamp);
                this.deleteBuffer = null;
            } else if (ret < 0) {
                this.deleteBuffer = null;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.deleteBuffer == null && this.familyStamp == 0L;
    }

    @Override
    public void reset() {
        this.familyStamp = 0L;
        this.deleteBuffer = null;
    }

    @Override
    public void update() {
        this.reset();
    }
}

