/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

public class Store
implements HeapSize {
    static final Log LOG = LogFactory.getLog(Store.class);
    protected final MemStore memstore;
    private final Path homedir;
    private final HRegion region;
    private final HColumnDescriptor family;
    final FileSystem fs;
    final Configuration conf;
    protected long ttl;
    private long majorCompactionTime;
    private final int maxFilesToCompact;
    private final long minCompactSize;
    private double compactRatio;
    private long lastCompactSize = 0L;
    static int closeCheckInterval = 0;
    private final long desiredMaxFileSize;
    private final int blockingStoreFileCount;
    private volatile long storeSize = 0L;
    private final Object flushLock = new Object();
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String storeNameStr;
    private final boolean inMemory;
    private ImmutableList<StoreFile> storefiles = null;
    private final CopyOnWriteArraySet<ChangedReadersObserver> changedReaderObservers = new CopyOnWriteArraySet();
    private final Object compactLock = new Object();
    private final int compactionThreshold;
    private final int blocksize;
    private final boolean blockcache;
    private final Compression.Algorithm compression;
    private final Compression.Algorithm compactionCompression;
    final KeyValue.KVComparator comparator;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 15 * ClassSize.REFERENCE + 48 + 8 + 16 + 2);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT);

    protected Store(Path basedir, HRegion region, HColumnDescriptor family, FileSystem fs, Configuration conf) throws IOException {
        HRegionInfo info = region.regionInfo;
        this.fs = fs;
        this.homedir = Store.getStoreHomedir(basedir, info.getEncodedName(), family.getName());
        if (!this.fs.exists(this.homedir) && !this.fs.mkdirs(this.homedir)) {
            throw new IOException("Failed create of: " + this.homedir.toString());
        }
        this.region = region;
        this.family = family;
        this.conf = conf;
        this.blockcache = family.isBlockCacheEnabled();
        this.blocksize = family.getBlocksize();
        this.compression = family.getCompression();
        this.compactionCompression = family.getCompactionCompression() != Compression.Algorithm.NONE ? family.getCompactionCompression() : this.compression;
        this.comparator = info.getComparator();
        this.ttl = family.getTimeToLive();
        this.ttl = this.ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (this.ttl == -1L ? Long.MAX_VALUE : (this.ttl *= 1000L));
        this.memstore = new MemStore(conf, this.comparator);
        this.storeNameStr = Bytes.toString(this.family.getName());
        this.compactionThreshold = Math.max(2, conf.getInt("hbase.hstore.compactionThreshold", 3));
        this.inMemory = family.isInMemory();
        long maxFileSize = info.getTableDesc().getMaxFileSize();
        if (maxFileSize == 0x10000000L) {
            maxFileSize = conf.getLong("hbase.hregion.max.filesize", 0x10000000L);
        }
        this.desiredMaxFileSize = maxFileSize;
        this.blockingStoreFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 7);
        this.majorCompactionTime = this.getNextMajorCompactTime();
        this.maxFilesToCompact = conf.getInt("hbase.hstore.compaction.max", 10);
        this.minCompactSize = conf.getLong("hbase.hstore.compaction.min.size", this.region.memstoreFlushSize);
        this.compactRatio = conf.getFloat("hbase.hstore.compaction.ratio", 1.2f);
        if (closeCheckInterval == 0) {
            closeCheckInterval = conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storefiles = this.sortAndClone(this.loadStoreFiles());
    }

    public HColumnDescriptor getFamily() {
        return this.family;
    }

    long getMaxSequenceId() {
        return StoreFile.getMaxSequenceIdInList(this.getStorefiles());
    }

    public static Path getStoreHomedir(Path tabledir, String encodedName, byte[] family) {
        return new Path(tabledir, new Path(encodedName, new Path(Bytes.toString(family))));
    }

    public Path getHomedir() {
        return this.homedir;
    }

    private List<StoreFile> loadStoreFiles() throws IOException {
        ArrayList<StoreFile> results = new ArrayList<StoreFile>();
        FileStatus[] files = this.fs.listStatus(this.homedir);
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDir()) continue;
            Path p = files[i].getPath();
            if (this.fs.getFileStatus(p).getLen() <= 0L) {
                LOG.warn((Object)("Skipping " + p + " because its empty. HBASE-646 DATA LOSS?"));
                continue;
            }
            StoreFile curfile = null;
            try {
                curfile = new StoreFile(this.fs, p, this.blockcache, this.conf, this.family.getBloomFilterType(), this.inMemory);
                curfile.createReader();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed open of " + p + "; presumption is that file was " + "corrupted at flush and lost edits picked up by commit log replay. " + "Verify!"), (Throwable)ioe);
                continue;
            }
            long length = curfile.getReader().length();
            this.storeSize += length;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loaded " + curfile.toStringDetailed()));
            }
            results.add(curfile);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long add(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.add(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long delete(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.delete(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    List<StoreFile> getStorefiles() {
        return this.storefiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkLoadHFile(String srcPathStr) throws IOException {
        Path srcPath = new Path(srcPathStr);
        HFile.Reader reader = null;
        try {
            LOG.info((Object)("Validating hfile at " + srcPath + " for inclusion in " + "store " + this + " region " + this.region));
            reader = new HFile.Reader(srcPath.getFileSystem(this.conf), srcPath, null, false);
            reader.loadFileInfo();
            byte[] firstKey = reader.getFirstRowKey();
            byte[] lk = reader.getLastKey();
            byte[] lastKey = lk == null ? null : KeyValue.createKeyValueFromKey(lk).getRow();
            LOG.debug((Object)("HFile bounds: first=" + Bytes.toStringBinary(firstKey) + " last=" + Bytes.toStringBinary(lastKey)));
            LOG.debug((Object)("Region bounds: first=" + Bytes.toStringBinary(this.region.getStartKey()) + " last=" + Bytes.toStringBinary(this.region.getEndKey())));
            HRegionInfo hri = this.region.getRegionInfo();
            if (!hri.containsRange(firstKey, lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPathStr + " does not fit inside region " + this.region);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        FileSystem srcFs = srcPath.getFileSystem(this.conf);
        if (!srcFs.equals(this.fs)) {
            LOG.info((Object)("File " + srcPath + " on different filesystem than " + "destination store - moving to this filesystem."));
            Path tmpPath = this.getTmpPath();
            FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)this.fs, (Path)tmpPath, (boolean)false, (Configuration)this.conf);
            LOG.info((Object)("Copied to temporary path on dst filesystem: " + tmpPath));
            srcPath = tmpPath;
        }
        Path dstPath = StoreFile.getRandomFilename(this.fs, this.homedir);
        LOG.info((Object)("Renaming bulk load file " + srcPath + " to " + dstPath));
        StoreFile.rename(this.fs, srcPath, dstPath);
        StoreFile sf = new StoreFile(this.fs, dstPath, this.blockcache, this.conf, this.family.getBloomFilterType(), this.inMemory);
        sf.createReader();
        LOG.info((Object)("Moved hfile " + srcPath + " into store directory " + this.homedir + " - updating store file list."));
        this.lock.writeLock().lock();
        try {
            ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
            newFiles.add(sf);
            this.storefiles = this.sortAndClone(newFiles);
            this.notifyChangedReadersObservers();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.info((Object)("Successfully loaded store file " + srcPath + " into store " + this + " (new location: " + dstPath + ")"));
    }

    private Path getTmpPath() throws IOException {
        return StoreFile.getRandomFilename(this.fs, this.region.getTmpDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableList<StoreFile> close() throws IOException {
        this.lock.writeLock().lock();
        try {
            ImmutableList<StoreFile> result = this.storefiles;
            this.storefiles = ImmutableList.of();
            for (StoreFile f : result) {
                f.closeReader();
            }
            LOG.debug((Object)("closed " + this.storeNameStr));
            ImmutableList<StoreFile> immutableList = result;
            return immutableList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void snapshot() {
        this.memstore.snapshot();
    }

    private StoreFile flushCache(long logCacheFlushId, SortedSet<KeyValue> snapshot, TimeRangeTracker snapshotTimeRangeTracker, MonitoredTask status) throws IOException {
        return this.internalFlushCache(snapshot, logCacheFlushId, snapshotTimeRangeTracker, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile internalFlushCache(SortedSet<KeyValue> set, long logCacheFlushId, TimeRangeTracker snapshotTimeRangeTracker, MonitoredTask status) throws IOException {
        StoreFile.Writer writer = null;
        long flushed = 0L;
        if (set.size() == 0) {
            return null;
        }
        long oldestTimestamp = System.currentTimeMillis() - this.ttl;
        Object object = this.flushLock;
        synchronized (object) {
            status.setStatus("Flushing " + this + ": creating writer");
            writer = this.createWriterInTmp(set.size());
            writer.setTimeRangeTracker(snapshotTimeRangeTracker);
            int entries = 0;
            try {
                for (KeyValue kv : set) {
                    if (Store.isExpired(kv, oldestTimestamp)) continue;
                    writer.append(kv);
                    ++entries;
                    flushed += this.memstore.heapSizeChange(kv, true);
                }
            }
            finally {
                status.setStatus("Flushing " + this + ": appending metadata");
                writer.appendMetadata(logCacheFlushId, false);
                status.setStatus("Flushing " + this + ": closing flushed file");
                writer.close();
            }
        }
        Path dstPath = StoreFile.getUniqueFile(this.fs, this.homedir);
        String msg = "Renaming flushed file at " + writer.getPath() + " to " + dstPath;
        LOG.info((Object)msg);
        status.setStatus("Flushing " + this + ": " + msg);
        if (!this.fs.rename(writer.getPath(), dstPath)) {
            LOG.warn((Object)("Unable to rename " + writer.getPath() + " to " + dstPath));
        }
        status.setStatus("Flushing " + this + ": reopening flushed file");
        StoreFile sf = new StoreFile(this.fs, dstPath, this.blockcache, this.conf, this.family.getBloomFilterType(), this.inMemory);
        StoreFile.Reader r = sf.createReader();
        this.storeSize += r.length();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", memsize=" + StringUtils.humanReadableInt((long)flushed) + ", filesize=" + StringUtils.humanReadableInt((long)r.length())));
        }
        return sf;
    }

    private StoreFile.Writer createWriterInTmp(int maxKeyCount) throws IOException {
        return this.createWriterInTmp(maxKeyCount, this.compression);
    }

    private StoreFile.Writer createWriterInTmp(int maxKeyCount, Compression.Algorithm compression) throws IOException {
        return StoreFile.createWriter(this.fs, this.region.getTmpDir(), this.blocksize, compression, this.comparator, this.conf, this.family.getBloomFilterType(), maxKeyCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(StoreFile sf, SortedSet<KeyValue> set) throws IOException {
        this.lock.writeLock().lock();
        try {
            ArrayList<StoreFile> newList = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
            newList.add(sf);
            this.storefiles = this.sortAndClone(newList);
            this.memstore.clearSnapshot(set);
            this.notifyChangedReadersObservers();
            boolean bl = this.storefiles.size() >= this.compactionThreshold;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void notifyChangedReadersObservers() throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            o.updateReaders();
        }
    }

    void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreSize compact(boolean forceMajor) throws IOException {
        boolean forceSplit = this.region.shouldForceSplit();
        boolean majorcompaction = forceMajor;
        Object object = this.compactLock;
        synchronized (object) {
            this.lastCompactSize = 0L;
            Object filesToCompact = this.storefiles;
            if (filesToCompact.isEmpty()) {
                LOG.debug((Object)(this.storeNameStr + ": no store files to compact"));
                return null;
            }
            if (!majorcompaction) {
                majorcompaction = this.isMajorCompaction((List<StoreFile>)filesToCompact);
            }
            boolean references = this.hasReferences((Collection<StoreFile>)filesToCompact);
            if (!(majorcompaction || references || !forceSplit && filesToCompact.size() >= this.compactionThreshold)) {
                return this.checkSplit(forceSplit);
            }
            int countOfFiles = filesToCompact.size();
            long[] fileSizes = new long[countOfFiles];
            long[] sumSize = new long[countOfFiles];
            for (int i = countOfFiles - 1; i >= 0; --i) {
                StoreFile file = (StoreFile)filesToCompact.get(i);
                Path path = file.getPath();
                if (path == null) {
                    LOG.error((Object)("Path is null for " + file));
                    return null;
                }
                StoreFile.Reader r = file.getReader();
                if (r == null) {
                    LOG.error((Object)("StoreFile " + file + " has a null Reader"));
                    return null;
                }
                fileSizes[i] = file.getReader().length();
                int tooFar = i + this.maxFilesToCompact - 1;
                sumSize[i] = fileSizes[i] + (i + 1 < countOfFiles ? sumSize[i + 1] : 0L) - (tooFar < countOfFiles ? fileSizes[tooFar] : 0L);
            }
            long totalSize = 0L;
            if (!majorcompaction && !references) {
                int start = 0;
                double r = this.compactRatio;
                while (countOfFiles - start >= this.compactionThreshold && fileSizes[start] > Math.max(this.minCompactSize, (long)((double)sumSize[start + 1] * r))) {
                    ++start;
                }
                int end = Math.min(countOfFiles, start + this.maxFilesToCompact);
                totalSize = fileSizes[start] + (start + 1 < countOfFiles ? sumSize[start + 1] : 0L);
                if (end - start < this.compactionThreshold) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Skipped compaction of " + this.storeNameStr + " because only " + (end - start) + " file(s) of size " + StringUtils.humanReadableInt((long)totalSize) + " meet compaction criteria."));
                    }
                    return this.checkSplit(forceSplit);
                }
                if (0 == start && end == countOfFiles) {
                    majorcompaction = true;
                } else {
                    filesToCompact = new ArrayList(filesToCompact.subList(start, end));
                }
            } else {
                for (long i : fileSizes) {
                    totalSize += i;
                }
            }
            this.lastCompactSize = totalSize;
            long maxId = StoreFile.getMaxSequenceIdInList(filesToCompact);
            LOG.info((Object)("Started compaction of " + filesToCompact.size() + " file(s) in cf=" + this.storeNameStr + (references ? ", hasReferences=true," : " ") + " into " + this.region.getTmpDir() + ", seqid=" + maxId + ", totalSize=" + StringUtils.humanReadableInt((long)totalSize)));
            StoreFile.Writer writer = this.compact((List<StoreFile>)filesToCompact, majorcompaction, maxId);
            StoreFile sf = this.completeCompaction((List<StoreFile>)filesToCompact, writer);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Completed" + (majorcompaction ? " major " : " ") + "compaction of " + filesToCompact.size() + " file(s), new file=" + (sf == null ? "none" : sf.toString()) + ", size=" + (sf == null ? "none" : StringUtils.humanReadableInt((long)sf.getReader().length())) + "; total size for store is " + StringUtils.humanReadableInt((long)this.storeSize)));
            }
        }
        return this.checkSplit(forceSplit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compactRecent(int N) throws IOException {
        Object object = this.compactLock;
        synchronized (object) {
            Object filesToCompact = this.storefiles;
            int count = filesToCompact.size();
            if (N > count) {
                throw new RuntimeException("Not enough files");
            }
            filesToCompact = new ArrayList(filesToCompact.subList(count - N, count));
            long maxId = StoreFile.getMaxSequenceIdInList(filesToCompact);
            boolean majorcompaction = N == count;
            StoreFile.Writer writer = this.compact((List<StoreFile>)filesToCompact, majorcompaction, maxId);
            StoreFile sf = this.completeCompaction((List<StoreFile>)filesToCompact, writer);
        }
    }

    private boolean hasReferences(Collection<StoreFile> files) {
        if (files != null && files.size() > 0) {
            for (StoreFile hsf : files) {
                if (!hsf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    private static long getLowestTimestamp(FileSystem fs, Path dir) throws IOException {
        FileStatus[] stats = fs.listStatus(dir);
        if (stats == null || stats.length == 0) {
            return 0L;
        }
        long lowTimestamp = Long.MAX_VALUE;
        for (int i = 0; i < stats.length; ++i) {
            long timestamp = stats[i].getModificationTime();
            if (timestamp >= lowTimestamp) continue;
            lowTimestamp = timestamp;
        }
        return lowTimestamp;
    }

    boolean isMajorCompaction() throws IOException {
        return this.isMajorCompaction((List<StoreFile>)this.storefiles);
    }

    private boolean isMajorCompaction(List<StoreFile> filesToCompact) throws IOException {
        boolean result = false;
        if (filesToCompact == null || filesToCompact.isEmpty() || this.majorCompactionTime == 0L) {
            return result;
        }
        long lowTimestamp = Store.getLowestTimestamp(this.fs, filesToCompact.get(0).getPath().getParent());
        long now = System.currentTimeMillis();
        if (lowTimestamp > 0L && lowTimestamp < now - this.majorCompactionTime) {
            if (filesToCompact.size() == 1) {
                long oldest;
                StoreFile sf = filesToCompact.get(0);
                long l = oldest = sf.getReader().timeRangeTracker == null ? Long.MIN_VALUE : now - sf.getReader().timeRangeTracker.minimumTimestamp;
                if (sf.isMajorCompaction() && (this.ttl == Integer.MAX_VALUE || oldest < this.ttl) && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping major compaction of " + this.storeNameStr + " because one (major) compacted file only and oldestTime " + oldest + "ms is < ttl=" + this.ttl));
                }
                if (this.ttl != Integer.MAX_VALUE && oldest > this.ttl) {
                    LOG.debug((Object)("Major compaction triggered on store " + this.storeNameStr + ", because keyvalues outdated; time since last major compaction " + (now - lowTimestamp) + "ms"));
                    result = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Major compaction triggered on store " + this.storeNameStr + "; time since last major compaction " + (now - lowTimestamp) + "ms"));
                }
                result = true;
                this.majorCompactionTime = this.getNextMajorCompactTime();
            }
        }
        return result;
    }

    long getNextMajorCompactTime() {
        double jitterPct;
        long ret = this.conf.getLong("hbase.hregion.majorcompaction", 86400000L);
        if (this.family.getValue("hbase.hregion.majorcompaction") != null) {
            String strCompactionTime = this.family.getValue("hbase.hregion.majorcompaction");
            ret = new Long(strCompactionTime);
        }
        if (ret > 0L && (jitterPct = (double)this.conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.2f)) > 0.0) {
            long jitter = Math.round((double)ret * jitterPct);
            ret += jitter - Math.round((double)(2L * jitter) * Math.random());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile.Writer compact(List<StoreFile> filesToCompact, boolean majorCompaction, long maxId) throws IOException {
        int maxKeyCount = 0;
        for (StoreFile file : filesToCompact) {
            StoreFile.Reader r = file.getReader();
            if (r == null) continue;
            long keyCount = r.getBloomFilterType() == this.family.getBloomFilterType() ? (long)r.getFilterEntries() : (long)r.getEntries();
            maxKeyCount = (int)((long)maxKeyCount + keyCount);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Compacting " + file + ", keycount=" + keyCount + ", bloomtype=" + r.getBloomFilterType().toString() + ", size=" + StringUtils.humanReadableInt((long)r.length())));
        }
        List<StoreFileScanner> scanners = StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, false);
        StoreFile.Writer writer = null;
        try {
            InternalScanner scanner = null;
            try {
                Scan scan = new Scan();
                scan.setMaxVersions(this.family.getMaxVersions());
                scanner = new StoreScanner(this, scan, scanners, !majorCompaction);
                int bytesWritten = 0;
                ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                while (scanner.next(kvs)) {
                    if (writer == null && !kvs.isEmpty()) {
                        writer = this.createWriterInTmp(maxKeyCount, this.compactionCompression);
                    }
                    if (writer != null) {
                        for (KeyValue kv : kvs) {
                            writer.append(kv);
                            if (closeCheckInterval <= 0 || (bytesWritten += kv.getLength()) <= closeCheckInterval) continue;
                            bytesWritten = 0;
                            if (this.region.areWritesEnabled()) continue;
                            writer.close();
                            this.fs.delete(writer.getPath(), false);
                            throw new InterruptedIOException("Aborting compaction of store " + this + " in region " + this.region + " because user requested stop.");
                        }
                    }
                    kvs.clear();
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.appendMetadata(maxId, majorCompaction);
                writer.close();
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile completeCompaction(List<StoreFile> compactedFiles, StoreFile.Writer compactedFile) throws IOException {
        StoreFile result = null;
        if (compactedFile != null) {
            Path p = null;
            try {
                p = StoreFile.rename(this.fs, compactedFile.getPath(), StoreFile.getRandomFilename(this.fs, this.homedir));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed move of compacted file " + compactedFile.getPath()), (Throwable)e);
                return null;
            }
            result = new StoreFile(this.fs, p, this.blockcache, this.conf, this.family.getBloomFilterType(), this.inMemory);
            result.createReader();
        }
        this.lock.writeLock().lock();
        try {
            try {
                ArrayList<StoreFile> newStoreFiles = new ArrayList<StoreFile>();
                for (StoreFile sf : this.storefiles) {
                    if (compactedFiles.contains(sf)) continue;
                    newStoreFiles.add(sf);
                }
                if (result != null) {
                    newStoreFiles.add(result);
                }
                this.storefiles = this.sortAndClone(newStoreFiles);
                this.notifyChangedReadersObservers();
                for (StoreFile hsf : compactedFiles) {
                    hsf.deleteReader();
                }
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                LOG.error((Object)("Failed replacing compacted files in " + this.storeNameStr + ". Compacted file is " + (result == null ? "none" : result.toString()) + ".  Files replaced " + compactedFiles.toString() + " some of which may have been already removed"), (Throwable)e);
            }
            this.storeSize = 0L;
            for (StoreFile hsf : this.storefiles) {
                StoreFile.Reader r = hsf.getReader();
                if (r == null) {
                    LOG.warn((Object)("StoreFile " + hsf + " has a null Reader"));
                    continue;
                }
                this.storeSize += r.length();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    public ImmutableList<StoreFile> sortAndClone(List<StoreFile> storeFiles) {
        Collections.sort(storeFiles, StoreFile.Comparators.FLUSH_TIME);
        ImmutableList newList = ImmutableList.copyOf(storeFiles);
        return newList;
    }

    public int getNumberOfstorefiles() {
        return this.storefiles.size();
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    static boolean isExpired(KeyValue key, long oldestTimestamp) {
        return key.getTimestamp() < oldestTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValue getRowKeyAtOrBefore(KeyValue kv) throws IOException {
        GetClosestRowBeforeTracker state = new GetClosestRowBeforeTracker(this.comparator, kv, this.ttl, this.region.getRegionInfo().isMetaRegion());
        this.lock.readLock().lock();
        try {
            this.memstore.getRowKeyAtOrBefore(state);
            for (StoreFile sf : Iterables.reverse(this.storefiles)) {
                this.rowAtOrBeforeFromStoreFile(sf, state);
            }
            KeyValue keyValue = state.getCandidate();
            return keyValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rowAtOrBeforeFromStoreFile(StoreFile f, GetClosestRowBeforeTracker state) throws IOException {
        KeyValue kv;
        HFileScanner scanner;
        KeyValue firstOnRow;
        StoreFile.Reader r = f.getReader();
        if (r == null) {
            LOG.warn((Object)("StoreFile " + f + " has a null Reader"));
            return;
        }
        byte[] fk = r.getFirstKey();
        KeyValue firstKV = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
        byte[] lk = r.getLastKey();
        KeyValue lastKV = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
        if (this.comparator.compareRows(lastKV, firstOnRow = state.getTargetKey()) < 0) {
            if (!state.isTargetTable(lastKV)) {
                return;
            }
            firstOnRow = new KeyValue(lastKV.getRow(), Long.MAX_VALUE);
        }
        if (!this.seekToScanner(scanner = r.getScanner(true, true), firstOnRow, firstKV)) {
            return;
        }
        if (this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
            return;
        }
        while (scanner.seekBefore(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength()) && state.isTargetTable(kv = scanner.getKeyValue()) && state.isBetterCandidate(kv) && this.seekToScanner(scanner, firstOnRow = new KeyValue(kv.getRow(), Long.MAX_VALUE), firstKV) && !this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
        }
    }

    private boolean seekToScanner(HFileScanner scanner, KeyValue firstOnRow, KeyValue firstKV) throws IOException {
        int result;
        KeyValue kv = firstOnRow;
        if (this.comparator.compareRows(firstKV, firstOnRow) == 0) {
            kv = firstKV;
        }
        return (result = scanner.seekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength())) >= 0;
    }

    private boolean walkForwardInSingleRow(HFileScanner scanner, KeyValue firstOnRow, GetClosestRowBeforeTracker state) throws IOException {
        boolean foundCandidate = false;
        do {
            KeyValue kv;
            if (this.comparator.compareRows(kv = scanner.getKeyValue(), firstOnRow) < 0) continue;
            if (state.isTooFar(kv, firstOnRow)) break;
            if (state.isExpired(kv) || !state.handle(kv)) continue;
            foundCandidate = true;
            break;
        } while (scanner.next());
        return foundCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreSize checkSplit(boolean force) {
        this.lock.readLock().lock();
        try {
            if (this.storefiles.isEmpty()) {
                StoreSize storeSize = null;
                return storeSize;
            }
            if (!force && this.storeSize < this.desiredMaxFileSize) {
                StoreSize storeSize = null;
                return storeSize;
            }
            if (this.region.getRegionInfo().isMetaRegion()) {
                if (force) {
                    LOG.warn((Object)"Cannot split meta regions in HBase 0.20");
                }
                StoreSize storeSize = null;
                return storeSize;
            }
            boolean splitable = true;
            long maxSize = 0L;
            StoreFile largestSf = null;
            for (StoreFile sf : this.storefiles) {
                StoreFile.Reader r;
                if (splitable) {
                    boolean bl = splitable = !sf.isReference();
                    if (!splitable) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(sf + " is not splittable"));
                        }
                        StoreSize storeSize = null;
                        return storeSize;
                    }
                }
                if ((r = sf.getReader()) == null) {
                    LOG.warn((Object)("Storefile " + sf + " Reader is null"));
                    continue;
                }
                long size = r.length();
                if (size <= maxSize) continue;
                maxSize = size;
                largestSf = sf;
            }
            if (this.region.getSplitPoint() != null) {
                StoreSize i$ = new StoreSize(maxSize, this.region.getSplitPoint());
                return i$;
            }
            StoreFile.Reader r = largestSf.getReader();
            if (r == null) {
                StoreFile sf;
                LOG.warn((Object)("Storefile " + largestSf + " Reader is null"));
                sf = null;
                return sf;
            }
            byte[] midkey = r.midkey();
            if (midkey != null) {
                KeyValue mk = KeyValue.createKeyValueFromKey(midkey, 0, midkey.length);
                byte[] fk = r.getFirstKey();
                KeyValue firstKey = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
                byte[] lk = r.getLastKey();
                KeyValue lastKey = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
                if (this.comparator.compareRows(mk, firstKey) == 0 && this.comparator.compareRows(mk, lastKey) == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"cannot split because midkey is the same as first or last row");
                    }
                    StoreSize storeSize = null;
                    return storeSize;
                }
                StoreSize storeSize = new StoreSize(maxSize, mk.getRow());
                return storeSize;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed getting store size for " + this.storeNameStr), (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    public long getSize() {
        return this.storeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols) throws IOException {
        this.lock.readLock().lock();
        try {
            StoreScanner storeScanner = new StoreScanner(this, scan, targetCols);
            return storeScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.storeNameStr;
    }

    int getStorefilesCount() {
        return this.storefiles.size();
    }

    long getStorefilesSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.length();
        }
        return size;
    }

    long getStorefilesIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.indexSize();
        }
        return size;
    }

    int getCompactPriority() {
        return this.blockingStoreFileCount - this.storefiles.size();
    }

    HRegion getHRegion() {
        return this.region;
    }

    HRegionInfo getHRegionInfo() {
        return this.region.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateColumnValue(byte[] row, byte[] f, byte[] qualifier, long newValue) throws IOException {
        this.lock.readLock().lock();
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            long l = this.memstore.updateColumnValue(row, f, qualifier, newValue, now);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long upsert(List<KeyValue> kvs) throws IOException {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.upsert(kvs);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StoreFlusher getStoreFlusher(long cacheFlushId) {
        return new StoreFlusherImpl(cacheFlushId);
    }

    public boolean hasTooManyStoreFiles() {
        return this.storefiles.size() > this.compactionThreshold;
    }

    @Override
    public long heapSize() {
        return DEEP_OVERHEAD + this.memstore.heapSize();
    }

    private class StoreFlusherImpl
    implements StoreFlusher {
        private long cacheFlushId;
        private SortedSet<KeyValue> snapshot;
        private StoreFile storeFile;
        private TimeRangeTracker snapshotTimeRangeTracker;

        private StoreFlusherImpl(long cacheFlushId) {
            this.cacheFlushId = cacheFlushId;
        }

        @Override
        public void prepare() {
            Store.this.memstore.snapshot();
            this.snapshot = Store.this.memstore.getSnapshot();
            this.snapshotTimeRangeTracker = Store.this.memstore.getSnapshotTimeRangeTracker();
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            this.storeFile = Store.this.flushCache(this.cacheFlushId, this.snapshot, this.snapshotTimeRangeTracker, status);
        }

        @Override
        public boolean commit() throws IOException {
            if (this.storeFile == null) {
                return false;
            }
            return Store.this.updateStorefiles(this.storeFile, this.snapshot);
        }
    }

    static class StoreSize {
        private final long size;
        private final byte[] row;

        StoreSize(long size, byte[] row) {
            this.size = size;
            this.row = row;
        }

        long getSize() {
            return this.size;
        }

        byte[] getSplitRow() {
            return this.row;
        }
    }
}

