/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

public class CloseRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CloseRegionHandler.class);
    private final int FAILED = -1;
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final boolean abort;
    private final boolean zk;

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo) {
        this(server, rsServices, regionInfo, false, true);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk) {
        this(server, rsServices, regionInfo, abort, zk, EventHandler.EventType.M_RS_CLOSE_REGION);
    }

    protected CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, EventHandler.EventType eventType) {
        super(server, eventType);
        this.server = server;
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.abort = abort;
        this.zk = zk;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            String name = this.regionInfo.getRegionNameAsString();
            LOG.debug((Object)("Processing close of " + name));
            String encodedRegionName = this.regionInfo.getEncodedName();
            HRegion region = this.rsServices.getFromOnlineRegions(encodedRegionName);
            if (region == null) {
                LOG.warn((Object)("Received CLOSE for region " + name + " but currently not serving"));
                return;
            }
            int expectedVersion = -1;
            if (this.zk && (expectedVersion = this.setClosingState()) == -1) {
                return;
            }
            if (region.close(this.abort) == null) {
                LOG.warn((Object)("Can't close region: was already closed during close(): " + this.regionInfo.getRegionNameAsString()));
                return;
            }
            this.rsServices.removeFromOnlineRegions(this.regionInfo.getEncodedName());
            if (this.zk) {
                this.setClosedState(expectedVersion, region);
            }
            LOG.debug((Object)("Closed region " + region.getRegionNameAsString()));
        }
        finally {
            this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        }
    }

    private void setClosedState(int expectedVersion, HRegion region) {
        try {
            if (ZKAssign.transitionNodeClosed(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName(), expectedVersion) == -1) {
                LOG.warn((Object)"Completed the CLOSE of a region but when transitioning from  CLOSING to CLOSED got a version mismatch, someone else clashed so now unassigning");
                region.close();
                return;
            }
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"NPE during close -- catching and continuing...", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)"Failed transitioning node from CLOSING to CLOSED", (Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close region after failing to transition", (Throwable)e);
            return;
        }
    }

    private int setClosingState() {
        int expectedVersion = -1;
        try {
            expectedVersion = ZKAssign.createNodeClosing(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName());
            if (expectedVersion == -1) {
                LOG.warn((Object)("Error creating node in CLOSING state, aborting close of " + this.regionInfo.getRegionNameAsString()));
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Error creating node in CLOSING state, aborting close of " + this.regionInfo.getRegionNameAsString()));
        }
        return expectedVersion;
    }
}

