/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;

public class RegionsResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RegionsResource.class);
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public RegionsResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<HRegionInfo, HServerAddress> getTableRegions() throws IOException {
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = pool.getTable(this.tableResource.getName());
        try {
            Map<HRegionInfo, HServerAddress> map = ((HTable)table).getRegionsInfo();
            return map;
        }
        finally {
            pool.putTable(table);
        }
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            String tableName = this.tableResource.getName();
            TableInfoModel model = new TableInfoModel(tableName);
            Map<HRegionInfo, HServerAddress> regions = this.getTableRegions();
            for (Map.Entry<HRegionInfo, HServerAddress> e : regions.entrySet()) {
                HRegionInfo hri = e.getKey();
                HServerAddress addr = e.getValue();
                InetSocketAddress sa = addr.getInetSocketAddress();
                model.add(new TableRegionModel(tableName, hri.getRegionId(), hri.getStartKey(), hri.getEndKey(), sa.getHostName() + ":" + Integer.valueOf(sa.getPort())));
            }
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            return response.build();
        }
        catch (TableNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

