/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.transform.Transform;
import org.apache.hadoop.hbase.util.Bytes;

public class RowResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RowResource.class);
    TableResource tableResource;
    RowSpec rowspec;

    public RowResource(TableResource tableResource, String rowspec, String versions) throws IOException {
        this.tableResource = tableResource;
        this.rowspec = new RowSpec(rowspec);
        if (versions != null) {
            this.rowspec.setMaxVersions(Integer.valueOf(versions));
        }
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            int count = 0;
            CellSetModel model = new CellSetModel();
            KeyValue value = (KeyValue)generator.next();
            byte[] rowKey = value.getRow();
            RowModel rowModel = new RowModel(rowKey);
            do {
                if (!Bytes.equals(value.getRow(), rowKey)) {
                    model.addRow(rowModel);
                    rowKey = value.getRow();
                    rowModel = new RowModel(rowKey);
                }
                byte[] family = value.getFamily();
                byte[] qualifier = value.getQualifier();
                byte[] data = this.tableResource.transform(family, qualifier, value.getValue(), Transform.Direction.OUT);
                rowModel.addCell(new CellModel(family, qualifier, value.getTimestamp(), data));
            } while (++count <= this.rowspec.getMaxValues() && (value = (KeyValue)generator.next()) != null);
            model.addRow(rowModel);
            return Response.ok((Object)model).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (!this.rowspec.hasColumns() || this.rowspec.getColumns().length > 1) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            KeyValue value = (KeyValue)generator.next();
            byte[] family = value.getFamily();
            byte[] qualifier = value.getQualifier();
            byte[] data = this.tableResource.transform(family, qualifier, value.getValue(), Transform.Direction.OUT);
            Response.ResponseBuilder response = Response.ok((Object)data);
            response.header("X-Timestamp", (Object)value.getTimestamp());
            return response.build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    Response update(CellSetModel model, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            List<RowModel> rows = model.getRows();
            table = pool.getTable(this.tableResource.getName());
            ((HTable)table).setAutoFlush(false);
            for (RowModel row : rows) {
                byte[] key = row.getKey();
                if (key == null) {
                    key = this.rowspec.getRow();
                }
                if (key == null) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
                Put put = new Put(key);
                int i = 0;
                for (CellModel cell : row.getCells()) {
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        try {
                            col = this.rowspec.getColumns()[i++];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            col = null;
                        }
                    }
                    if (col == null) {
                        throw new WebApplicationException(Response.Status.BAD_REQUEST);
                    }
                    byte[][] parts = KeyValue.parseColumn(col);
                    if (parts.length == 2 && parts[1].length > 0) {
                        put.add(parts[0], parts[1], cell.getTimestamp(), this.tableResource.transform(parts[0], parts[1], cell.getValue(), Transform.Direction.IN));
                        continue;
                    }
                    put.add(parts[0], null, cell.getTimestamp(), this.tableResource.transform(parts[0], null, cell.getValue(), Transform.Direction.IN));
                }
                table.put(put);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("PUT " + put.toString()));
            }
            ((HTable)table).setAutoFlush(true);
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            Response response2 = response.build();
            if (table != null) {
                pool.putTable(table);
            }
            return response2;
        }
        catch (IOException e) {
            try {
                throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
            }
            catch (Throwable throwable) {
                if (table != null) {
                    pool.putTable(table);
                }
                throw throwable;
            }
        }
    }

    Response updateBinary(byte[] message, HttpHeaders headers, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            byte[] row = this.rowspec.getRow();
            byte[][] columns = this.rowspec.getColumns();
            byte[] column = null;
            if (columns != null) {
                column = columns[0];
            }
            long timestamp = Long.MAX_VALUE;
            List vals = headers.getRequestHeader("X-Row");
            if (vals != null && !vals.isEmpty()) {
                row = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Column")) != null && !vals.isEmpty()) {
                column = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Timestamp")) != null && !vals.isEmpty()) {
                timestamp = Long.valueOf((String)vals.get(0));
            }
            if (column == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            Put put = new Put(row);
            byte[][] parts = KeyValue.parseColumn(column);
            if (parts.length == 2 && parts[1].length > 0) {
                put.add(parts[0], parts[1], timestamp, this.tableResource.transform(parts[0], parts[1], message, Transform.Direction.IN));
            } else {
                put.add(parts[0], null, timestamp, this.tableResource.transform(parts[0], null, message, Transform.Direction.IN));
            }
            table = pool.getTable(this.tableResource.getName());
            table.put(put);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PUT " + put.toString()));
            }
            Response response = Response.ok().build();
            if (table != null) {
                pool.putTable(table);
            }
            return response;
        }
        catch (IOException e) {
            try {
                throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
            }
            catch (Throwable throwable) {
                if (table != null) {
                    pool.putTable(table);
                }
                throw throwable;
            }
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response put(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath()));
        }
        return this.update(model, true);
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public Response putBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, true);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response post(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath()));
        }
        return this.update(model, false);
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public Response postBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, false);
    }

    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Delete delete = null;
        delete = this.rowspec.hasTimestamp() ? new Delete(this.rowspec.getRow(), this.rowspec.getTimestamp(), null) : new Delete(this.rowspec.getRow());
        for (byte[] column : this.rowspec.getColumns()) {
            byte[][] split = KeyValue.parseColumn(column);
            if (this.rowspec.hasTimestamp()) {
                if (split.length == 2 && split[1].length != 0) {
                    delete.deleteColumns(split[0], split[1], this.rowspec.getTimestamp());
                    continue;
                }
                delete.deleteFamily(split[0], this.rowspec.getTimestamp());
                continue;
            }
            if (split.length == 2 && split[1].length != 0) {
                delete.deleteColumns(split[0], split[1]);
                continue;
            }
            delete.deleteFamily(split[0]);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            table = pool.getTable(this.tableResource.getName());
            table.delete(delete);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE " + delete.toString()));
            }
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                pool.putTable(table);
            }
        }
        return Response.ok().build();
    }
}

