/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.util.StringUtils;

public class RowResultGenerator
extends ResultGenerator {
    private static final Log LOG = LogFactory.getLog(RowResultGenerator.class);
    private Iterator<KeyValue> valuesI;
    private KeyValue cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowResultGenerator(String tableName, RowSpec rowspec, Filter filter) throws IllegalArgumentException, IOException {
        HTablePool pool = RESTServlet.getInstance().getTablePool();
        HTableInterface table = pool.getTable(tableName);
        try {
            Result result;
            Get get2 = new Get(rowspec.getRow());
            if (rowspec.hasColumns()) {
                for (byte[] col : rowspec.getColumns()) {
                    byte[][] split = KeyValue.parseColumn(col);
                    if (split.length == 2 && split[1].length != 0) {
                        get2.addColumn(split[0], split[1]);
                        continue;
                    }
                    get2.addFamily(split[0]);
                }
            } else {
                for (HColumnDescriptor family : table.getTableDescriptor().getFamilies()) {
                    get2.addFamily(family.getName());
                }
            }
            get2.setTimeRange(rowspec.getStartTime(), rowspec.getEndTime());
            get2.setMaxVersions(rowspec.getMaxVersions());
            if (filter != null) {
                get2.setFilter(filter);
            }
            if ((result = table.get(get2)) != null && !result.isEmpty()) {
                this.valuesI = result.list().iterator();
            }
        }
        catch (NoSuchColumnFamilyException e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
        }
        finally {
            pool.putTable(table);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.cache != null) {
            return true;
        }
        if (this.valuesI == null) {
            return false;
        }
        return this.valuesI.hasNext();
    }

    @Override
    public KeyValue next() {
        if (this.cache != null) {
            KeyValue kv = this.cache;
            this.cache = null;
            return kv;
        }
        if (this.valuesI == null) {
            return null;
        }
        try {
            return this.valuesI.next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public void putBack(KeyValue kv) {
        this.cache = kv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

