/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;

public class StorageClusterVersionResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(StorageClusterVersionResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            HBaseAdmin admin = new HBaseAdmin(this.servlet.getConfiguration());
            StorageClusterVersionModel model = new StorageClusterVersionModel();
            model.setVersion(admin.getClusterStatus().getHBaseVersion());
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            return response.build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

