/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Encoded;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.rest.ExistsResource;
import org.apache.hadoop.hbase.rest.RegionsResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowResource;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.SchemaResource;
import org.apache.hadoop.hbase.rest.transform.NullTransform;
import org.apache.hadoop.hbase.rest.transform.Transform;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

public class TableResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(TableResource.class);
    private static final String DIRECTIVE_KEY = "Transform$";
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("([^\\:]+)\\:([^\\,]+)\\,?");
    private static final Transform defaultTransform = new NullTransform();
    private static final Map<String, Map<byte[], Map<byte[], Transform>>> transformMap = new ConcurrentHashMap<String, Map<byte[], Map<byte[], Transform>>>();
    private static final Map<String, Long> lastCheckedMap = new ConcurrentHashMap<String, Long>();
    String table;

    static Transform getTransform(String table, byte[] family, byte[] qualifier) {
        Map<byte[], Transform> columnMap;
        Map<byte[], Map<byte[], Transform>> familyMap;
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        if ((familyMap = transformMap.get(table)) != null && (columnMap = familyMap.get(family)) != null) {
            Transform t = columnMap.get(qualifier);
            if (t == null) {
                t = columnMap.get(HConstants.EMPTY_BYTE_ARRAY);
            }
            if (t != null) {
                return t;
            }
        }
        return defaultTransform;
    }

    static synchronized void setTransform(String table, byte[] family, byte[] qualifier, Transform transform) {
        Map<byte[], Transform> columnMap;
        Map<byte[], Map<byte[], Transform>> familyMap = transformMap.get(table);
        if (familyMap == null) {
            familyMap = new ConcurrentSkipListMap<byte[], Map<byte[], Transform>>(Bytes.BYTES_COMPARATOR);
            transformMap.put(table, familyMap);
        }
        if ((columnMap = familyMap.get(family)) == null) {
            columnMap = new ConcurrentSkipListMap<byte[], Transform>(Bytes.BYTES_COMPARATOR);
            familyMap.put(family, columnMap);
        }
        if (transform != null) {
            columnMap.put(qualifier, transform);
        } else {
            columnMap.remove(qualifier);
        }
    }

    void scanTransformAttrs() throws IOException {
        try {
            HBaseAdmin admin = new HBaseAdmin(this.servlet.getConfiguration());
            HTableDescriptor htd = admin.getTableDescriptor(Bytes.toBytes(this.table));
            for (HColumnDescriptor hcd : htd.getFamilies()) {
                for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : hcd.getValues().entrySet()) {
                    String key = Bytes.toString(e.getKey().get());
                    if (!key.startsWith(DIRECTIVE_KEY)) continue;
                    byte[] value = e.getValue().get();
                    Matcher m = DIRECTIVE_PATTERN.matcher(Bytes.toString(value));
                    block8: while (m.find()) {
                        byte[] qualifier = HConstants.EMPTY_BYTE_ARRAY;
                        String s = m.group(1);
                        if (s.length() > 0 && !s.equals("*")) {
                            qualifier = Bytes.toBytes(s);
                        }
                        boolean retry = false;
                        String className = m.group(2);
                        while (true) {
                            try {
                                TableResource.setTransform(this.table, hcd.getName(), qualifier, (Transform)Class.forName(className).newInstance());
                                continue block8;
                            }
                            catch (InstantiationException ex) {
                                LOG.error((Object)StringUtils.stringifyException((Throwable)ex));
                                if (retry) continue block8;
                                retry = true;
                                continue;
                            }
                            catch (IllegalAccessException ex) {
                                LOG.error((Object)StringUtils.stringifyException((Throwable)ex));
                                if (retry) continue block8;
                                retry = true;
                                continue;
                            }
                            catch (ClassNotFoundException ex) {
                                if (retry) {
                                    LOG.error((Object)StringUtils.stringifyException((Throwable)ex));
                                    continue block8;
                                }
                                className = "org.apache.hadoop.hbase.rest.transform." + className;
                                retry = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    public TableResource(String table) throws IOException {
        this.table = table;
        long now = System.currentTimeMillis();
        Long lastChecked = lastCheckedMap.get(table);
        if (lastChecked != null) {
            long interval = this.servlet.getConfiguration().getLong("hbase.rest.transform.check.interval", 60000L);
            if (interval > 0L && now - lastChecked > interval) {
                this.scanTransformAttrs();
                lastCheckedMap.put(table, now);
            }
        } else {
            this.scanTransformAttrs();
            lastCheckedMap.put(table, now);
        }
    }

    String getName() {
        return this.table;
    }

    boolean exists() throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.servlet.getConfiguration());
        return admin.tableExists(this.table);
    }

    byte[] transform(byte[] family, byte[] qualifier, byte[] value, Transform.Direction direction) throws IOException {
        Transform t = TableResource.getTransform(this.table, family, qualifier);
        if (t != null) {
            return t.transform(value, direction);
        }
        return value;
    }

    @Path(value="exists")
    public ExistsResource getExistsResource() throws IOException {
        return new ExistsResource(this);
    }

    @Path(value="regions")
    public RegionsResource getRegionsResource() throws IOException {
        return new RegionsResource(this);
    }

    @Path(value="scanner")
    public ScannerResource getScannerResource() throws IOException {
        return new ScannerResource(this);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() throws IOException {
        return new SchemaResource(this);
    }

    @Path(value="{rowspec: .+}")
    public RowResource getRowResource(@PathParam(value="rowspec") @Encoded String rowspec, @QueryParam(value="v") String versions) throws IOException {
        return new RowResource(this, rowspec, versions);
    }
}

