/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRegionInfo;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftServer {
    private static final String DEFAULT_LISTEN_PORT = "9090";

    private static void printUsageAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, options, "To start the Thrift server run 'bin/hbase-daemon.sh start thrift'\nTo shutdown the thrift server run 'bin/hbase-daemon.sh stop thrift' or send a kill signal to the thrift server pid", true);
        System.exit(exitCode);
    }

    private static void doMain(String[] args) throws Exception {
        TNonblockingServer server;
        TCompactProtocol.Factory protocolFactory;
        Log LOG = LogFactory.getLog((String)"ThriftServer");
        Options options = new Options();
        options.addOption("b", "bind", true, "Address to bind the Thrift server to. Not supported by the Nonblocking and HsHa server [default: 0.0.0.0]");
        options.addOption("p", "port", true, "Port to bind to [default: 9090]");
        options.addOption("f", "framed", false, "Use framed transport");
        options.addOption("c", "compact", false, "Use the compact protocol");
        options.addOption("h", "help", false, "Print help information");
        OptionGroup servers = new OptionGroup();
        servers.addOption(new Option("nonblocking", false, "Use the TNonblockingServer. This implies the framed transport."));
        servers.addOption(new Option("hsha", false, "Use the THsHaServer. This implies the framed transport."));
        servers.addOption(new Option("threadpool", false, "Use the TThreadPoolServer. This is the default."));
        options.addOptionGroup(servers);
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List<String> commandLine = Arrays.asList(args);
        boolean stop = commandLine.contains("stop");
        boolean start = commandLine.contains("start");
        if (cmd.hasOption("help") || !start || stop) {
            ThriftServer.printUsageAndExit(options, 1);
        }
        int listenPort = 0;
        try {
            listenPort = Integer.parseInt(cmd.getOptionValue("port", DEFAULT_LISTEN_PORT));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Could not parse the value provided for the port option", (Throwable)e);
            ThriftServer.printUsageAndExit(options, -1);
        }
        if (cmd.hasOption("compact")) {
            LOG.debug((Object)"Using compact protocol");
            protocolFactory = new TCompactProtocol.Factory();
        } else {
            LOG.debug((Object)"Using binary protocol");
            protocolFactory = new TBinaryProtocol.Factory();
        }
        HBaseHandler handler = new HBaseHandler();
        Hbase.Processor processor = new Hbase.Processor(handler);
        if (cmd.hasOption("nonblocking") || cmd.hasOption("hsha")) {
            if (cmd.hasOption("bind")) {
                LOG.error((Object)"The Nonblocking and HsHa servers don't support IP address binding at the moment. See https://issues.apache.org/jira/browse/HBASE-2155 for details.");
                ThriftServer.printUsageAndExit(options, -1);
            }
            TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(listenPort);
            TFramedTransport.Factory transportFactory = new TFramedTransport.Factory();
            if (cmd.hasOption("nonblocking")) {
                LOG.info((Object)("starting HBase Nonblocking Thrift server on " + Integer.toString(listenPort)));
                server = new TNonblockingServer((TProcessor)processor, (TNonblockingServerTransport)serverTransport, transportFactory, (TProtocolFactory)protocolFactory);
            } else {
                LOG.info((Object)("starting HBase HsHA Thrift server on " + Integer.toString(listenPort)));
                server = new THsHaServer((TProcessor)processor, (TNonblockingServerTransport)serverTransport, transportFactory, (TProtocolFactory)protocolFactory);
            }
        } else {
            TFramedTransport.Factory transportFactory;
            InetAddress listenAddress = null;
            if (cmd.hasOption("bind")) {
                try {
                    listenAddress = InetAddress.getByName(cmd.getOptionValue("bind"));
                }
                catch (UnknownHostException e) {
                    LOG.error((Object)"Could not bind to provided ip address", (Throwable)e);
                    ThriftServer.printUsageAndExit(options, -1);
                }
            } else {
                listenAddress = InetAddress.getByName("0.0.0.0");
            }
            TServerSocket serverTransport = new TServerSocket(new InetSocketAddress(listenAddress, listenPort));
            if (cmd.hasOption("framed")) {
                transportFactory = new TFramedTransport.Factory();
                LOG.debug((Object)"Using framed transport");
            } else {
                transportFactory = new TTransportFactory();
            }
            LOG.info((Object)("starting HBase ThreadPool Thrift server on " + listenAddress + ":" + Integer.toString(listenPort)));
            server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, (TTransportFactory)transportFactory, (TProtocolFactory)protocolFactory);
        }
        server.serve();
    }

    public static void main(String[] args) throws Exception {
        ThriftServer.doMain(args);
    }

    public static class HBaseHandler
    implements Hbase.Iface {
        protected Configuration conf;
        protected HBaseAdmin admin = null;
        protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
        protected int nextScannerId = 0;
        protected HashMap<Integer, ResultScanner> scannerMap = null;
        private static ThreadLocal<Map<String, HTable>> threadLocalTables = new ThreadLocal<Map<String, HTable>>(){

            @Override
            protected Map<String, HTable> initialValue() {
                return new TreeMap<String, HTable>();
            }
        };

        byte[][] getAllColumns(HTable table) throws IOException {
            HColumnDescriptor[] cds = table.getTableDescriptor().getColumnFamilies();
            byte[][] columns = new byte[cds.length][];
            for (int i = 0; i < cds.length; ++i) {
                columns[i] = Bytes.add(cds[i].getName(), KeyValue.COLUMN_FAMILY_DELIM_ARRAY);
            }
            return columns;
        }

        protected HTable getTable(byte[] tableName) throws IOError, IOException {
            String table = new String(tableName);
            Map<String, HTable> tables = threadLocalTables.get();
            if (!tables.containsKey(table)) {
                tables.put(table, new HTable(this.conf, tableName));
            }
            return tables.get(table);
        }

        protected synchronized int addScanner(ResultScanner scanner) {
            int id = this.nextScannerId++;
            this.scannerMap.put(id, scanner);
            return id;
        }

        protected synchronized ResultScanner getScanner(int id) {
            return this.scannerMap.get(id);
        }

        protected synchronized ResultScanner removeScanner(int id) {
            return this.scannerMap.remove(id);
        }

        HBaseHandler() throws IOException {
            this(HBaseConfiguration.create());
        }

        HBaseHandler(Configuration c) throws IOException {
            this.conf = c;
            this.admin = new HBaseAdmin(this.conf);
            this.scannerMap = new HashMap();
        }

        @Override
        public void enableTable(byte[] tableName) throws IOError {
            try {
                this.admin.enableTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void disableTable(byte[] tableName) throws IOError {
            try {
                this.admin.disableTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOError {
            try {
                return HTable.isTableEnabled(this.conf, tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void compact(byte[] tableNameOrRegionName) throws IOError {
            try {
                this.admin.compact(tableNameOrRegionName);
            }
            catch (InterruptedException e) {
                throw new IOError(e.getMessage());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void majorCompact(byte[] tableNameOrRegionName) throws IOError {
            try {
                this.admin.majorCompact(tableNameOrRegionName);
            }
            catch (InterruptedException e) {
                throw new IOError(e.getMessage());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<byte[]> getTableNames() throws IOError {
            try {
                HTableDescriptor[] tables = this.admin.listTables();
                ArrayList<byte[]> list = new ArrayList<byte[]>(tables.length);
                for (int i = 0; i < tables.length; ++i) {
                    list.add(tables[i].getName());
                }
                return list;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRegionInfo> getTableRegions(byte[] tableName) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Map<HRegionInfo, HServerAddress> regionsInfo = table.getRegionsInfo();
                ArrayList<TRegionInfo> regions = new ArrayList<TRegionInfo>();
                for (HRegionInfo regionInfo : regionsInfo.keySet()) {
                    TRegionInfo region = new TRegionInfo();
                    region.startKey = regionInfo.getStartKey();
                    region.endKey = regionInfo.getEndKey();
                    region.id = regionInfo.getRegionId();
                    region.name = regionInfo.getRegionName();
                    region.version = regionInfo.getVersion();
                    regions.add(region);
                }
                return regions;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> get(byte[] tableName, byte[] row, byte[] column) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            if (famAndQf.length == 1) {
                return this.get(tableName, row, famAndQf[0], new byte[0]);
            }
            return this.get(tableName, row, famAndQf[0], famAndQf[1]);
        }

        public List<TCell> get(byte[] tableName, byte[] row, byte[] family, byte[] qualifier) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                if (qualifier == null || qualifier.length == 0) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.sorted());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVer(byte[] tableName, byte[] row, byte[] column, int numVersions) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            if (famAndQf.length == 1) {
                return this.getVer(tableName, row, famAndQf[0], new byte[0], numVersions);
            }
            return this.getVer(tableName, row, famAndQf[0], famAndQf[1], numVersions);
        }

        public List<TCell> getVer(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, int numVersions) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.sorted());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] column, long timestamp, int numVersions) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            if (famAndQf.length == 1) {
                return this.getVerTs(tableName, row, famAndQf[0], new byte[0], timestamp, numVersions);
            }
            return this.getVerTs(tableName, row, famAndQf[0], famAndQf[1], timestamp, numVersions);
        }

        public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, long timestamp, int numVersions) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                get2.setTimeRange(Long.MIN_VALUE, timestamp);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.sorted());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRowResult> getRow(byte[] tableName, byte[] row) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowWithColumns(byte[] tableName, byte[] row, List<byte[]> columns) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, columns, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, timestamp);
        }

        @Override
        public List<TRowResult> getRowWithColumnsTs(byte[] tableName, byte[] row, List<byte[]> columns, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                if (columns == null) {
                    Get get2 = new Get(row);
                    get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    Result result = table.get(get2);
                    return ThriftUtilities.rowResultFromHBase(result);
                }
                byte[][] columnArr = (byte[][])columns.toArray((T[])new byte[columns.size()][]);
                Get get3 = new Get(row);
                for (byte[] column : columnArr) {
                    byte[][] famAndQf = KeyValue.parseColumn(column);
                    if (famAndQf.length == 1) {
                        get3.addFamily(famAndQf[0]);
                        continue;
                    }
                    get3.addColumn(famAndQf[0], famAndQf[1]);
                }
                get3.setTimeRange(Long.MIN_VALUE, timestamp);
                Result result = table.get(get3);
                return ThriftUtilities.rowResultFromHBase(result);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRowResult> getRows(byte[] tableName, List<byte[]> rows) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowsWithColumns(byte[] tableName, List<byte[]> rows, List<byte[]> columns) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, columns, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowsTs(byte[] tableName, List<byte[]> rows, long timestamp) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, timestamp);
        }

        @Override
        public List<TRowResult> getRowsWithColumnsTs(byte[] tableName, List<byte[]> rows, List<byte[]> columns, long timestamp) throws IOError {
            try {
                ArrayList<Get> gets = new ArrayList<Get>(rows.size());
                HTable table = this.getTable(tableName);
                for (byte[] row : rows) {
                    Get get2 = new Get(row);
                    if (columns != null) {
                        byte[][] columnArr;
                        for (byte[] column : columnArr = (byte[][])columns.toArray((T[])new byte[columns.size()][])) {
                            byte[][] famAndQf = KeyValue.parseColumn(column);
                            if (famAndQf.length == 1) {
                                get2.addFamily(famAndQf[0]);
                                continue;
                            }
                            get2.addColumn(famAndQf[0], famAndQf[1]);
                        }
                        get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    }
                    gets.add(get2);
                }
                Result[] result = table.get(gets);
                return ThriftUtilities.rowResultFromHBase(result);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAll(byte[] tableName, byte[] row, byte[] column) throws IOError {
            this.deleteAllTs(tableName, row, column, Long.MAX_VALUE);
        }

        @Override
        public void deleteAllTs(byte[] tableName, byte[] row, byte[] column, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(row);
                byte[][] famAndQf = KeyValue.parseColumn(column);
                if (famAndQf.length == 1) {
                    delete.deleteFamily(famAndQf[0], timestamp);
                } else {
                    delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                }
                table.delete(delete);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAllRow(byte[] tableName, byte[] row) throws IOError {
            this.deleteAllRowTs(tableName, row, Long.MAX_VALUE);
        }

        @Override
        public void deleteAllRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(row, timestamp, null);
                table.delete(delete);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void createTable(byte[] tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists {
            try {
                if (this.admin.tableExists(tableName)) {
                    throw new AlreadyExists("table name already in use");
                }
                HTableDescriptor desc = new HTableDescriptor(tableName);
                for (ColumnDescriptor col : columnFamilies) {
                    HColumnDescriptor colDesc = ThriftUtilities.colDescFromThrift(col);
                    desc.addFamily(colDesc);
                }
                this.admin.createTable(desc);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void deleteTable(byte[] tableName) throws IOError {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("deleteTable: table=" + new String(tableName)));
            }
            try {
                if (!this.admin.tableExists(tableName)) {
                    throw new IOError("table does not exist");
                }
                this.admin.deleteTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void mutateRow(byte[] tableName, byte[] row, List<Mutation> mutations) throws IOError, IllegalArgument {
            this.mutateRowTs(tableName, row, mutations, Long.MAX_VALUE);
        }

        @Override
        public void mutateRowTs(byte[] tableName, byte[] row, List<Mutation> mutations, long timestamp) throws IOError, IllegalArgument {
            HTable table = null;
            try {
                table = this.getTable(tableName);
                Put put = new Put(row, timestamp, null);
                Delete delete = new Delete(row);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(m.column);
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                            continue;
                        }
                        delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        put.add(famAndQf[0], new byte[0], m.value);
                        continue;
                    }
                    put.add(famAndQf[0], famAndQf[1], m.value);
                }
                if (!delete.isEmpty()) {
                    table.delete(delete);
                }
                if (!put.isEmpty()) {
                    table.put(put);
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void mutateRows(byte[] tableName, List<BatchMutation> rowBatches) throws IOError, IllegalArgument, TException {
            this.mutateRowsTs(tableName, rowBatches, Long.MAX_VALUE);
        }

        @Override
        public void mutateRowsTs(byte[] tableName, List<BatchMutation> rowBatches, long timestamp) throws IOError, IllegalArgument, TException {
            ArrayList<Put> puts = new ArrayList<Put>();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (BatchMutation batch : rowBatches) {
                byte[] row = batch.row;
                List<Mutation> mutations = batch.mutations;
                Delete delete = new Delete(row);
                Put put = new Put(row, timestamp, null);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(m.column);
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                            continue;
                        }
                        delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        put.add(famAndQf[0], new byte[0], m.value);
                        continue;
                    }
                    put.add(famAndQf[0], famAndQf[1], m.value);
                }
                if (!delete.isEmpty()) {
                    deletes.add(delete);
                }
                if (put.isEmpty()) continue;
                puts.add(put);
            }
            HTable table = null;
            try {
                table = this.getTable(tableName);
                if (!puts.isEmpty()) {
                    table.put(puts);
                }
                for (Delete del : deletes) {
                    table.delete(del);
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public long atomicIncrement(byte[] tableName, byte[] row, byte[] column, long amount) throws IOError, IllegalArgument, TException {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            if (famAndQf.length == 1) {
                return this.atomicIncrement(tableName, row, famAndQf[0], new byte[0], amount);
            }
            return this.atomicIncrement(tableName, row, famAndQf[0], famAndQf[1], amount);
        }

        public long atomicIncrement(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, long amount) throws IOError, IllegalArgument, TException {
            try {
                HTable table = this.getTable(tableName);
                return table.incrementColumnValue(row, family, qualifier, amount);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void scannerClose(int id) throws IOError, IllegalArgument {
            this.LOG.debug((Object)("scannerClose: id=" + id));
            ResultScanner scanner = this.getScanner(id);
            if (scanner == null) {
                throw new IllegalArgument("scanner ID is invalid");
            }
            scanner.close();
            this.removeScanner(id);
        }

        @Override
        public List<TRowResult> scannerGetList(int id, int nbRows) throws IllegalArgument, IOError {
            this.LOG.debug((Object)("scannerGetList: id=" + id));
            ResultScanner scanner = this.getScanner(id);
            if (null == scanner) {
                throw new IllegalArgument("scanner ID is invalid");
            }
            Result[] results = null;
            try {
                results = scanner.next(nbRows);
                if (null == results) {
                    return new ArrayList<TRowResult>();
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            return ThriftUtilities.rowResultFromHBase(results);
        }

        @Override
        public List<TRowResult> scannerGet(int id) throws IllegalArgument, IOError {
            return this.scannerGetList(id, 1);
        }

        @Override
        public int scannerOpen(byte[] tableName, byte[] startRow, List<byte[]> columns) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(startRow);
                if (columns != null && columns.size() != 0) {
                    for (byte[] column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(column);
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStop(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(startRow, stopRow);
                if (columns != null && columns.size() != 0) {
                    for (byte[] column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(column);
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithPrefix(byte[] tableName, byte[] startAndPrefix, List<byte[]> columns) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(startAndPrefix);
                WhileMatchFilter f = new WhileMatchFilter(new PrefixFilter(startAndPrefix));
                scan.setFilter(f);
                if (columns != null && columns.size() != 0) {
                    for (byte[] column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(column);
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenTs(byte[] tableName, byte[] startRow, List<byte[]> columns, long timestamp) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(startRow);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (byte[] column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(column);
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStopTs(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns, long timestamp) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(startRow, stopRow);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (byte[] column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(column);
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public Map<byte[], ColumnDescriptor> getColumnDescriptors(byte[] tableName) throws IOError, TException {
            try {
                TreeMap<byte[], ColumnDescriptor> columns = new TreeMap<byte[], ColumnDescriptor>(Bytes.BYTES_COMPARATOR);
                HTable table = this.getTable(tableName);
                HTableDescriptor desc = table.getTableDescriptor();
                for (HColumnDescriptor e : desc.getFamilies()) {
                    ColumnDescriptor col = ThriftUtilities.colDescFromHbase(e);
                    columns.put(col.name, col);
                }
                return columns;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }
    }
}

