/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class TRowResult
implements TBase<_Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TRowResult");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 13, 2);
    public byte[] row;
    public Map<byte[], TCell> columns;
    public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class){
        {
            this.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11)));
            this.put(_Fields.COLUMNS, new FieldMetaData("columns", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, TCell.class))));
        }
    });

    public TRowResult() {
    }

    public TRowResult(byte[] row, Map<byte[], TCell> columns) {
        this();
        this.row = row;
        this.columns = columns;
    }

    public TRowResult(TRowResult other) {
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetColumns()) {
            HashMap<byte[], TCell> __this__columns = new HashMap<byte[], TCell>();
            for (Map.Entry<byte[], TCell> other_element : other.columns.entrySet()) {
                byte[] other_element_key = other_element.getKey();
                TCell other_element_value = other_element.getValue();
                byte[] __this__columns_copy_key = other_element_key;
                TCell __this__columns_copy_value = new TCell(other_element_value);
                __this__columns.put(__this__columns_copy_key, __this__columns_copy_value);
            }
            this.columns = __this__columns;
        }
    }

    public TRowResult deepCopy() {
        return new TRowResult(this);
    }

    @Deprecated
    public TRowResult clone() {
        return new TRowResult(this);
    }

    public byte[] getRow() {
        return this.row;
    }

    public TRowResult setRow(byte[] row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public void putToColumns(byte[] key, TCell val) {
        if (this.columns == null) {
            this.columns = new HashMap<byte[], TCell>();
        }
        this.columns.put(key, val);
    }

    public Map<byte[], TCell> getColumns() {
        return this.columns;
    }

    public TRowResult setColumns(Map<byte[], TCell> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((byte[])value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((Map)value);
            }
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        this.setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case COLUMNS: {
                return this.getColumns();
            }
        }
        throw new IllegalStateException();
    }

    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
    }

    public boolean isSet(_Fields field) {
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(int fieldID) {
        return this.isSet(_Fields.findByThriftIdOrThrow(fieldID));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TRowResult) {
            return this.equals((TRowResult)that);
        }
        return false;
    }

    public boolean equals(TRowResult that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!Arrays.equals(this.row, that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_row = this.isSetRow();
        builder.append(present_row);
        if (present_row) {
            builder.append(this.row);
        }
        boolean present_columns = this.isSetColumns();
        builder.append(present_columns);
        if (present_columns) {
            builder.append(this.columns);
        }
        return builder.toHashCode();
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            _Fields fieldId = _Fields.findByThriftId(field.id);
            if (fieldId == null) {
                TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                continue;
            }
            switch (fieldId) {
                case ROW: {
                    if (field.type == 11) {
                        this.row = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case COLUMNS: {
                    if (field.type == 13) {
                        TMap _map4 = iprot.readMapBegin();
                        this.columns = new HashMap<byte[], TCell>(2 * _map4.size);
                        for (int _i5 = 0; _i5 < _map4.size; ++_i5) {
                            byte[] _key6 = iprot.readBinary();
                            TCell _val7 = new TCell();
                            _val7.read(iprot);
                            this.columns.put(_key6, _val7);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.row != null) {
            oprot.writeFieldBegin(ROW_FIELD_DESC);
            oprot.writeBinary(this.row);
            oprot.writeFieldEnd();
        }
        if (this.columns != null) {
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 12, this.columns.size()));
            for (Map.Entry<byte[], TCell> _iter8 : this.columns.entrySet()) {
                oprot.writeBinary(_iter8.getKey());
                _iter8.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRowResult(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            sb.append(this.row);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(TRowResult.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        COLUMNS(2, "columns");

        private static final Map<Integer, _Fields> byId;
        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            return byId.get(fieldId);
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byId = new HashMap<Integer, _Fields>();
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byId.put(Integer.valueOf(field._thriftId), field);
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

