/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.KeyRange;

public class RegionSplitCalculator<R extends KeyRange> {
    static final Log LOG = LogFactory.getLog(RegionSplitCalculator.class);
    private final Comparator<R> rangeCmp;
    private final TreeSet<byte[]> splits = new TreeSet<byte[]>(BYTES_COMPARATOR);
    private final Multimap<byte[], R> starts = ArrayListMultimap.create();
    private static final byte[] ENDKEY = null;
    public static final Comparator<byte[]> BYTES_COMPARATOR = new Bytes.ByteArrayComparator(){

        @Override
        public int compare(byte[] l, byte[] r) {
            if (l == null && r == null) {
                return 0;
            }
            if (l == null) {
                return 1;
            }
            if (r == null) {
                return -1;
            }
            return super.compare(l, r);
        }
    };

    public RegionSplitCalculator(Comparator<R> cmp) {
        this.rangeCmp = cmp;
    }

    private byte[] specialEndKey(R range) {
        byte[] end = range.getEndKey();
        if (end.length == 0) {
            return ENDKEY;
        }
        return end;
    }

    public boolean add(R range) {
        byte[] start = range.getStartKey();
        byte[] end = this.specialEndKey(range);
        if (end != ENDKEY && Bytes.compareTo(start, end) > 0) {
            LOG.debug((Object)("attempted to add backwards edge: " + Bytes.toString(start) + " " + Bytes.toString(end)));
            return false;
        }
        this.splits.add(start);
        this.splits.add(end);
        this.starts.put((Object)start, range);
        return true;
    }

    public Multimap<byte[], R> calcCoverage() {
        TreeMultimap regions = TreeMultimap.create(BYTES_COMPARATOR, this.rangeCmp);
        for (Map.Entry start : this.starts.asMap().entrySet()) {
            byte[] key = (byte[])start.getKey();
            for (KeyRange r : (Collection)start.getValue()) {
                regions.put((Object)key, (Object)r);
                for (byte[] coveredSplit : this.splits.subSet(r.getStartKey(), this.specialEndKey(r))) {
                    regions.put((Object)coveredSplit, (Object)r);
                }
            }
        }
        return regions;
    }

    public TreeSet<byte[]> getSplits() {
        return this.splits;
    }

    public Multimap<byte[], R> getStarts() {
        return this.starts;
    }
}

