/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class SoftValueSortedMap<K, V>
implements SortedMap<K, V> {
    private final SortedMap<K, SoftValue<K, V>> internalMap;
    private final ReferenceQueue rq = new ReferenceQueue();

    public SoftValueSortedMap() {
        this(new TreeMap());
    }

    public SoftValueSortedMap(Comparator<K> c) {
        this(new TreeMap(c));
    }

    private SoftValueSortedMap(SortedMap<K, SoftValue<K, V>> original) {
        this.internalMap = original;
    }

    private int checkReferences() {
        Reference obj;
        int i = 0;
        while ((obj = this.rq.poll()) != null) {
            ++i;
            this.internalMap.remove(((SoftValue)obj).key);
        }
        return i;
    }

    @Override
    public synchronized V put(K key, V value) {
        this.checkReferences();
        SoftValue<K, V> oldValue = this.internalMap.put(key, new SoftValue<K, V>(key, value, this.rq));
        return oldValue == null ? null : (V)oldValue.get();
    }

    @Override
    public synchronized void putAll(Map map) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public synchronized V get(Object key) {
        this.checkReferences();
        SoftValue value = (SoftValue)this.internalMap.get(key);
        if (value == null) {
            return null;
        }
        if (value.get() == null) {
            this.internalMap.remove(key);
            return null;
        }
        return (V)value.get();
    }

    @Override
    public synchronized V remove(Object key) {
        this.checkReferences();
        SoftValue value = (SoftValue)this.internalMap.remove(key);
        return value == null ? null : (V)value.get();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        this.checkReferences();
        return this.internalMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Don't support containsValue!");
    }

    @Override
    public synchronized K firstKey() {
        this.checkReferences();
        return this.internalMap.firstKey();
    }

    @Override
    public synchronized K lastKey() {
        this.checkReferences();
        return this.internalMap.lastKey();
    }

    @Override
    public synchronized SoftValueSortedMap<K, V> headMap(K key) {
        this.checkReferences();
        return new SoftValueSortedMap<K, V>(this.internalMap.headMap(key));
    }

    @Override
    public synchronized SoftValueSortedMap<K, V> tailMap(K key) {
        this.checkReferences();
        return new SoftValueSortedMap<K, V>(this.internalMap.tailMap(key));
    }

    @Override
    public synchronized SoftValueSortedMap<K, V> subMap(K fromKey, K toKey) {
        this.checkReferences();
        return new SoftValueSortedMap<K, V>(this.internalMap.subMap(fromKey, toKey));
    }

    @Override
    public synchronized boolean isEmpty() {
        this.checkReferences();
        return this.internalMap.isEmpty();
    }

    @Override
    public synchronized int size() {
        this.checkReferences();
        return this.internalMap.size();
    }

    @Override
    public synchronized void clear() {
        this.checkReferences();
        this.internalMap.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        this.checkReferences();
        return this.internalMap.keySet();
    }

    @Override
    public synchronized Comparator comparator() {
        return this.internalMap.comparator();
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public synchronized Collection<V> values() {
        this.checkReferences();
        Collection<SoftValue<K, V>> softValues = this.internalMap.values();
        ArrayList hardValues = new ArrayList();
        for (SoftValue<K, V> softValue : softValues) {
            hardValues.add(softValue.get());
        }
        return hardValues;
    }

    private static class SoftValue<K, V>
    extends SoftReference<V> {
        final K key;

        SoftValue(K key, V value, ReferenceQueue q) {
            super(value, q);
            this.key = key;
        }
    }
}

