/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ClusterStatusTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(ClusterStatusTracker.class);

    public ClusterStatusTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.clusterStateZNode, abortable);
    }

    public boolean isClusterUp() {
        return super.getData() != null;
    }

    public void setClusterUp() throws KeeperException {
        byte[] upData = Bytes.toBytes(new Date().toString());
        try {
            ZKUtil.createAndWatch(this.watcher, this.watcher.clusterStateZNode, upData);
        }
        catch (KeeperException.NodeExistsException nee) {
            ZKUtil.setData(this.watcher, this.watcher.clusterStateZNode, upData);
        }
    }

    public void setClusterDown() throws KeeperException {
        try {
            ZKUtil.deleteNode(this.watcher, this.watcher.clusterStateZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn((Object)("Attempted to set cluster as down but already down, cluster state node (" + this.watcher.clusterStateZNode + ") not found"));
        }
    }
}

