/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;

public class MiniZooKeeperCluster {
    private static final Log LOG = LogFactory.getLog(MiniZooKeeperCluster.class);
    private static final int TICK_TIME = 2000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private boolean started = false;
    private int clientPort = 21818;
    private NIOServerCnxn.Factory standaloneServerFactory;
    private int tickTime = 0;
    private Configuration configuration;

    public MiniZooKeeperCluster() {
        this(HBaseConfiguration.create());
    }

    public MiniZooKeeperCluster(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    private static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)100L);
    }

    public int startup(File baseDir) throws IOException, InterruptedException {
        MiniZooKeeperCluster.setupTestEnv();
        this.shutdown();
        File dir = new File(baseDir, "zookeeper").getAbsoluteFile();
        this.recreateDir(dir);
        int tickTimeToUse = this.tickTime > 0 ? this.tickTime : 2000;
        ZooKeeperServer server = new ZooKeeperServer(dir, dir, tickTimeToUse);
        while (true) {
            try {
                int numberOfConnections = this.configuration.getInt("hbase.zookeeper.property.maxClientCnxns", 5000);
                this.standaloneServerFactory = new NIOServerCnxn.Factory(new InetSocketAddress(this.clientPort), numberOfConnections);
            }
            catch (BindException e) {
                LOG.info((Object)("Failed binding ZK Server to client port: " + this.clientPort));
                ++this.clientPort;
                continue;
            }
            break;
        }
        this.standaloneServerFactory.startup(server);
        if (!MiniZooKeeperCluster.waitForServerUp(this.clientPort, 30000L)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        this.started = true;
        LOG.info((Object)("Started MiniZK Server on client port: " + this.clientPort));
        return this.clientPort;
    }

    private void recreateDir(File dir) throws IOException {
        if (dir.exists()) {
            FileUtil.fullyDelete((File)dir);
        }
        try {
            dir.mkdirs();
        }
        catch (SecurityException e) {
            throw new IOException("creating dir: " + dir, e);
        }
    }

    public void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        this.standaloneServerFactory.shutdown();
        if (!MiniZooKeeperCluster.waitForServerDown(this.clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForServerDown(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket("localhost", port);
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                }
                finally {
                    sock.close();
                }
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForServerUp(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket("localhost", port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    InputStreamReader isr = new InputStreamReader(sock.getInputStream());
                    reader = new BufferedReader(isr);
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("server localhost:" + port + " not up " + e));
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
            }
        }
    }
}

