/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class RegionServerTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(RegionServerTracker.class);
    private ServerManager serverManager;
    private Abortable abortable;

    public RegionServerTracker(ZooKeeperWatcher watcher, Abortable abortable, ServerManager serverManager) {
        super(watcher);
        this.abortable = abortable;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException {
        this.watcher.registerListener(this);
        ZKUtil.watchAndGetNewChildren(this.watcher, this.watcher.rsZNode);
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.rsZNode)) {
            String serverName = ZKUtil.getNodeName(path);
            LOG.info((Object)("RegionServer ephemeral node deleted, processing expiration [" + serverName + "]"));
            HServerInfo hsi = this.serverManager.getServerInfo(serverName);
            if (hsi == null) {
                LOG.info((Object)("No HServerInfo found for " + serverName));
                return;
            }
            this.serverManager.expireServer(hsi);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.rsZNode)) {
            try {
                ZKUtil.watchAndGetNewChildren(this.watcher, this.watcher.rsZNode);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", e);
            }
        }
    }

    public List<HServerAddress> getOnlineServers() throws KeeperException {
        return ZKUtil.listChildrenAndGetAsAddresses(this.watcher, this.watcher.rsZNode);
    }
}

