/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZKUtil {
    private static final Log LOG = LogFactory.getLog(ZKUtil.class);
    private static final char ZNODE_PATH_SEPARATOR = '/';

    public static ZooKeeper connect(Configuration conf, Watcher watcher) throws IOException {
        Properties properties = ZKConfig.makeZKProps(conf);
        String ensemble = ZKConfig.getZKQuorumServersString(properties);
        return ZKUtil.connect(conf, ensemble, watcher);
    }

    public static ZooKeeper connect(Configuration conf, String ensemble, Watcher watcher) throws IOException {
        return ZKUtil.connect(conf, ensemble, watcher, "");
    }

    public static ZooKeeper connect(Configuration conf, String ensemble, Watcher watcher, String descriptor) throws IOException {
        if (ensemble == null) {
            throw new IOException("Unable to determine ZooKeeper ensemble");
        }
        int timeout = conf.getInt("zookeeper.session.timeout", 180000);
        LOG.debug((Object)(descriptor + " opening connection to ZooKeeper with ensemble (" + ensemble + ")"));
        return new ZooKeeper(ensemble, timeout, watcher);
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(HServerInfo serverInfo) {
        return serverInfo.getServerName();
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getZooKeeperClusterKey(Configuration conf) {
        return ZKUtil.getZooKeeperClusterKey(conf, null);
    }

    public static String getZooKeeperClusterKey(Configuration conf, String name) {
        String ensemble = conf.get("hbase.zookeeper.quorum".replaceAll("[\\t\\n\\x0B\\f\\r]", ""));
        StringBuilder builder = new StringBuilder(ensemble);
        builder.append(":");
        builder.append(conf.get("hbase.zookeeper.property.clientPort"));
        builder.append(":");
        builder.append(conf.get("zookeeper.znode.parent"));
        if (name != null && !name.isEmpty()) {
            builder.append(",");
            builder.append(name);
        }
        return builder.toString();
    }

    public static void applyClusterKeyToConf(Configuration conf, String key) throws IOException {
        String[] parts = ZKUtil.transformClusterKey(key);
        conf.set("hbase.zookeeper.quorum", parts[0]);
        conf.set("hbase.zookeeper.property.clientPort", parts[1]);
        conf.set("zookeeper.znode.parent", parts[2]);
    }

    public static String[] transformClusterKey(String key) throws IOException {
        String[] parts = key.split(":");
        if (parts.length != 3) {
            throw new IOException("Cluster key invalid, the format should be:hbase.zookeeper.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        }
        return parts;
    }

    public static boolean watchAndCheckExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getZooKeeper().exists(znode, (Watcher)zkw);
            LOG.debug((Object)zkw.prefix("Set watcher on existing znode " + znode));
            return s != null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getZooKeeper().exists(znode, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            List children = zkw.getZooKeeper().getChildren(znode, (Watcher)zkw);
            return children;
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<String> listChildrenAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil.watchAndCheckExists(zkw, ZKUtil.joinZNode(znode, child));
        }
        return children;
    }

    public static List<HServerAddress> listChildrenAndGetAsAddresses(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, znode);
        if (children == null) {
            return null;
        }
        ArrayList<HServerAddress> addresses = new ArrayList<HServerAddress>(children.size());
        for (String child : children) {
            addresses.add(ZKUtil.getDataAsAddress(zkw, ZKUtil.joinZNode(znode, child)));
        }
        return addresses;
    }

    public static List<String> listChildrenNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List children = null;
        try {
            children = zkw.getZooKeeper().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeAndData> watchAndGetNewChildren(ZooKeeperWatcher zkw, String baseNode) throws KeeperException {
        ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
        Set<String> set = zkw.getNodes();
        synchronized (set) {
            List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, baseNode);
            for (String node : nodes) {
                String nodePath = ZKUtil.joinZNode(baseNode, node);
                if (zkw.getNodes().contains(nodePath)) continue;
                byte[] data = ZKUtil.getDataAndWatch(zkw, nodePath);
                newNodes.add(new NodeAndData(nodePath, data));
                zkw.getNodes().add(nodePath);
            }
        }
        return newNodes;
    }

    public static boolean nodeHasChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getZooKeeper().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " " + "because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getZooKeeper().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            byte[] data = zkw.getZooKeeper().getData(znode, null, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            byte[] data = zkw.getZooKeeper().getData(znode, (Watcher)zkw, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, true);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getZooKeeper().getData(znode, (Watcher)zkw, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static HServerAddress getDataAsAddress(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        byte[] data = ZKUtil.getDataAndWatch(zkw, znode);
        if (data == null) {
            return null;
        }
        String addrString = Bytes.toString(data);
        LOG.debug((Object)zkw.prefix("Read server address from znode " + znode + ": " + addrString));
        return new HServerAddress(addrString);
    }

    public static void updateExistingNodeData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getZooKeeper().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setAddressAndWatch(ZooKeeperWatcher zkw, String znode, HServerAddress address) throws KeeperException {
        return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, Bytes.toBytes(address.toString()));
    }

    public static boolean setData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getZooKeeper().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zkw, znode) == -1) {
            ZKUtil.createWithParents(zkw, znode);
        }
        ZKUtil.setData(zkw, znode, data);
    }

    public static void setData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil.setData(zkw, znode, data, -1);
    }

    public static boolean createEphemeralNodeAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            zkw.getZooKeeper().create(znode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            if (!ZKUtil.watchAndCheckExists(zkw, znode)) {
                return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, data);
            }
            return false;
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            zkw.getZooKeeper().create(znode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            try {
                zkw.getZooKeeper().exists(znode, (Watcher)zkw);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return false;
            }
            return false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return true;
    }

    public static int createAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getZooKeeper().create(znode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return zkw.getZooKeeper().exists(znode, (Watcher)zkw).getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZooKeeperWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) throws KeeperException, KeeperException.NodeExistsException {
        zkw.getZooKeeper().create(znode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            ZooKeeper zk = zkw.getZooKeeper();
            if (zk.exists(znode, false) == null) {
                zk.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException.NodeExistsException nee) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getZooKeeper().create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zkw, ZKUtil.getParent(znode));
            ZKUtil.createWithParents(zkw, znode);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getZooKeeper().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher zkw, String node) throws KeeperException {
        try {
            zkw.getZooKeeper().delete(node, -1);
        }
        catch (KeeperException.NoNodeException nne) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNodeRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        try {
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
            if (!children.isEmpty()) {
                for (String child : children) {
                    ZKUtil.deleteNodeRecursively(zkw, ZKUtil.joinZNode(node, child));
                }
            }
            zkw.getZooKeeper().delete(node, -1);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteChildrenRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
        if (children == null || children.isEmpty()) {
            return;
        }
        for (String child : children) {
            ZKUtil.deleteNodeRecursively(zkw, ZKUtil.joinZNode(node, child));
        }
    }

    public static String dump(ZooKeeperWatcher zkw) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] servers;
            sb.append("HBase is rooted at ").append(zkw.baseZNode);
            sb.append("\nMaster address: ").append(ZKUtil.getDataAsAddress(zkw, zkw.masterAddressZNode));
            sb.append("\nRegion server holding ROOT: ").append(ZKUtil.getDataAsAddress(zkw, zkw.rootServerZNode));
            sb.append("\nRegion servers:");
            for (HServerAddress address : ZKUtil.listChildrenAndGetAsAddresses(zkw, zkw.rsZNode)) {
                sb.append("\n ").append(address);
            }
            sb.append("\nQuorum Server Statistics:");
            for (String server : servers = zkw.getQuorum().split(",")) {
                sb.append("\n ").append(server);
                try {
                    String[] stat;
                    for (String s : stat = ZKUtil.getServerStats(server)) {
                        sb.append("\n  ").append(s);
                    }
                }
                catch (Exception e) {
                    sb.append("\n  ERROR: ").append(e.getMessage());
                }
            }
        }
        catch (KeeperException ke) {
            sb.append("\nFATAL ZooKeeper Exception!\n");
            sb.append("\n" + ke.getMessage());
        }
        return sb.toString();
    }

    public static String[] getServerStats(String server) throws IOException {
        return ZKUtil.getServerStats(server, 60000);
    }

    public static String[] getServerStats(String server, int timeout) throws IOException {
        String line;
        String[] sp = server.split(":");
        Socket socket = new Socket(sp[0], sp.length > 1 ? Integer.parseInt(sp[1]) : 2181);
        socket.setSoTimeout(timeout);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println("stat");
        out.flush();
        ArrayList<String> res = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            res.add(line);
        }
        socket.close();
        return res.toArray(new String[res.size()]);
    }

    private static void logRetrievedMsg(ZooKeeperWatcher zkw, String znode, byte[] data, boolean watcherSet) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)zkw.prefix("Retrieved " + (data == null ? 0 : data.length) + " byte(s) of data from znode " + znode + (watcherSet ? " and set watcher; " : "; data=") + (data == null ? "null" : (znode.startsWith(zkw.assignmentZNode) ? RegionTransitionData.fromBytes(data).toString() : StringUtils.abbreviate((String)Bytes.toStringBinary(data), (int)32)))));
    }

    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node + " (" + RegionTransitionData.fromBytes(this.data) + ")";
        }
    }
}

