/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperWatcher
implements Watcher,
Abortable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    private String identifier;
    private String quorum;
    private ZooKeeper zooKeeper;
    private Abortable abortable;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    private Set<String> unassignedNodes = new HashSet<String>();
    public String baseZNode;
    public String rootServerZNode;
    public String rsZNode;
    public String masterAddressZNode;
    public String clusterStateZNode;
    public String assignmentZNode;
    public String tableZNode;
    private final Configuration conf;
    private final Exception constructorCaller;

    public ZooKeeperWatcher(Configuration conf, String descriptor, Abortable abortable) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        try {
            throw new Exception("ZKW CONSTRUCTOR STACK TRACE FOR DEBUGGING");
        }
        catch (Exception e) {
            this.constructorCaller = e;
            this.quorum = ZKConfig.getZKQuorumServersString(conf);
            this.identifier = descriptor;
            this.abortable = abortable;
            this.setNodeNames(conf);
            this.zooKeeper = ZKUtil.connect(conf, this.quorum, this, descriptor);
            try {
                long wait = conf.getLong("hbase.zookeeper.recoverable.waittime", 10000L);
                long finished = System.currentTimeMillis() + wait;
                KeeperException.ConnectionLossException ke = null;
                while (true) {
                    try {
                        ZKUtil.createAndFailSilent(this, this.baseZNode);
                        ke = null;
                    }
                    catch (KeeperException.ConnectionLossException e2) {
                        if (LOG.isDebugEnabled() && this.isFinishedRetryingRecoverable(finished)) {
                            LOG.debug((Object)("Retrying zk create for another " + (finished - System.currentTimeMillis()) + "ms; set 'hbase.zookeeper.recoverable.waittime' to change " + "wait time); " + e2.getMessage()));
                        }
                        ke = e2;
                        if (this.isFinishedRetryingRecoverable(finished)) continue;
                    }
                    break;
                }
                if (ke != null) {
                    try {
                        this.zooKeeper.close();
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                        LOG.warn((Object)"Interrupted while closing", (Throwable)e3);
                    }
                    throw new ZooKeeperConnectionException("HBase is able to connect to ZooKeeper but the connection closes immediately. This could be a sign that the server has too many connections (30 is the default). Consider inspecting your ZK server logs for that error and then make sure you are reusing HBaseConfiguration as often as you can. See HTable's javadoc for more information.", (Exception)((Object)ke));
                }
                ZKUtil.createAndFailSilent(this, this.assignmentZNode);
                ZKUtil.createAndFailSilent(this, this.rsZNode);
                ZKUtil.createAndFailSilent(this, this.tableZNode);
            }
            catch (KeeperException e4) {
                throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), (Exception)((Object)e4));
            }
            return;
        }
    }

    private boolean isFinishedRetryingRecoverable(long finished) {
        return System.currentTimeMillis() < finished;
    }

    public String toString() {
        return this.identifier;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.rootServerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rootserver", "root-region-server"));
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "shutdown"));
        this.assignmentZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.unassigned", "unassigned"));
        this.tableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void process(WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + event.getType() + ", " + "state=" + event.getState() + ", " + "path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                long finished = System.currentTimeMillis() + this.conf.getLong("hbase.zookeeper.watcher.sync.connected.wait", 2000L);
                while (System.currentTimeMillis() < finished) {
                    Threads.sleep(1);
                    if (this.zooKeeper == null) continue;
                }
                if (this.zooKeeper == null) {
                    LOG.error((Object)"ZK is null on connection event -- see stack trace for the stack trace when constructor was called on this zkw", (Throwable)this.constructorCaller);
                    throw new NullPointerException("ZK is null");
                }
                this.identifier = this.identifier + "-0x" + Long.toHexString(this.zooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from " + "ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, (Throwable)new KeeperException.SessionExpiredException());
            }
        }
    }

    public void sync(String path) {
        this.zooKeeper.sync(path, null, null);
    }

    public Set<String> getNodes() {
        return this.unassignedNodes;
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) {
        LOG.debug((Object)this.prefix("Received InterruptedException, doing nothing here"), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    public void close() {
        try {
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void abort(String why, Throwable e) {
        this.abortable.abort(why, e);
    }
}

