/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples;

import java.util.List;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.TableSplit;

public class Driver {
    static String[] usage = new String[]{"", "usage: Driver <namespace> <command> [ <args> ... ]", "", "commands:", "  get-splits <table> Fetch table splits for table <table>", "  hql <hql-command>   Execute <hql-command> and display results", "", null};

    public static void DumpUsageAndExit() {
        System.out.println();
        int i = 0;
        while (usage[i] != null) {
            System.out.println(usage[i]);
            ++i;
        }
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] args) {
        long namespace = 0L;
        if (args.length < 2) {
            Driver.DumpUsageAndExit();
        }
        try {
            ThriftClient client = ThriftClient.create((String)"localhost", (int)38080);
            namespace = client.open_namespace(args[0]);
            if (args.length < 3) {
                client.close_namespace(namespace);
                Driver.DumpUsageAndExit();
            }
            if (args[1].equals("get-splits")) {
                List splits = client.get_table_splits(namespace, args[2]);
                for (TableSplit s : splits) {
                    System.out.println(s);
                }
            } else if (args[1].equals("hql")) {
                System.out.println(client.hql_query(namespace, args[2]));
            } else {
                client.close_namespace(namespace);
                Driver.DumpUsageAndExit();
            }
            client.close_namespace(namespace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

